/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.props.DatabaseConnectionProperties;
import org.firebirdsql.jaybird.xca.FBLocalTransaction;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBCallableStatement;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverConsistencyCheckException;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSavepoint;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.GeneratedKeysSupport;
import org.firebirdsql.jdbc.GeneratedKeysSupportFactory;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.StoredProcedureMetaData;
import org.firebirdsql.jdbc.StoredProcedureMetaDataFactory;
import org.firebirdsql.jdbc.escape.FBEscapedParser;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBConnection
implements FirebirdConnection {
    private static final Logger log = LoggerFactory.getLogger(FBConnection.class);
    private static final String GET_CLIENT_INFO_SQL = "SELECT     rdb$get_context('USER_SESSION', ?) session_context   , rdb$get_context('USER_TRANSACTION', ?) tx_context FROM rdb$database";
    private static final String SET_CLIENT_INFO_SQL = "SELECT   rdb$set_context('USER_SESSION', ?, ?) session_context FROM rdb$database";
    private static final String PERMISSION_SET_NETWORK_TIMEOUT = "setNetworkTimeout";
    protected volatile FBManagedConnection mc;
    private FBLocalTransaction localTransaction;
    private FBDatabaseMetaData metaData;
    protected final InternalTransactionCoordinator txCoordinator;
    private SQLWarning firstWarning;
    protected final Set<Statement> activeStatements = Collections.synchronizedSet(new HashSet());
    private int resultSetHoldability;
    private StoredProcedureMetaData storedProcedureMetaData;
    private GeneratedKeysSupport generatedKeysSupport;
    private final Set<String> clientInfoPropNames = new HashSet<String>();
    private static final AtomicIntegerFieldUpdater<FBConnection> SAVEPOINT_COUNTER_UPDATE = AtomicIntegerFieldUpdater.newUpdater(FBConnection.class, "savepointCounter");
    private volatile int savepointCounter;
    private final List<FBSavepoint> savepoints = new ArrayList<FBSavepoint>();

    public FBConnection(FBManagedConnection mc) {
        this.mc = mc;
        this.txCoordinator = new InternalTransactionCoordinator(this);
        IConnectionProperties props = mc.getConnectionRequestInfo().asIConnectionProperties();
        this.resultSetHoldability = props.isDefaultResultSetHoldable() ? 1 : 2;
    }

    @Deprecated
    public FBObjectListener.StatementListener getStatementListener() {
        return this.txCoordinator;
    }

    @Override
    public int getHoldability() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            int n = this.resultSetHoldability;
            return n;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.resultSetHoldability = holdability;
        }
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("This connection is closed and cannot be used now.", "08003");
        }
    }

    void notifyStatementClosed(FBStatement stmt) {
        if (!this.activeStatements.remove(stmt)) {
            if (stmt instanceof FBPreparedStatement && !((FBPreparedStatement)stmt).isInitialized()) {
                return;
            }
            log.warnf("Specified statement was not created by this connection: %s", (Object)stmt);
        }
    }

    protected void freeStatements() throws SQLException {
        ArrayList<Statement> statements = new ArrayList<Statement>(this.activeStatements);
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        for (Statement stmt : statements) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    public void setManagedConnection(FBManagedConnection mc) {
        try (LockCloseable ignored = this.withLock();){
            if (this.mc != mc && this.metaData != null) {
                try {
                    this.metaData.close();
                }
                finally {
                    this.metaData = null;
                }
            }
            this.mc = mc;
        }
    }

    public FBManagedConnection getManagedConnection() {
        try (LockCloseable ignored = this.withLock();){
            FBManagedConnection fBManagedConnection = this.mc;
            return fBManagedConnection;
        }
    }

    @Override
    public FbDatabase getFbDatabase() throws SQLException {
        return this.getGDSHelper().getCurrentDatabase();
    }

    public DatabaseConnectionProperties connectionProperties() {
        return this.mc != null ? this.mc.getConnectionRequestInfo().asIConnectionProperties().asImmutable() : null;
    }

    @Override
    @Deprecated
    public void setTransactionParameters(int isolationLevel, int[] parameters) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            TransactionParameterBuffer tpbParams = this.createTransactionParameterBuffer();
            for (int parameter : parameters) {
                tpbParams.addArgument(parameter);
            }
            this.setTransactionParameters(isolationLevel, tpbParams);
        }
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolationLevel) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            TransactionParameterBuffer transactionParameterBuffer = this.mc.getTransactionParameters(isolationLevel);
            return transactionParameterBuffer;
        }
    }

    @Override
    public TransactionParameterBuffer createTransactionParameterBuffer() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            TransactionParameterBuffer transactionParameterBuffer = this.getFbDatabase().createTransactionParameterBuffer();
            return transactionParameterBuffer;
        }
    }

    @Override
    public void setTransactionParameters(int isolationLevel, TransactionParameterBuffer tpb) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.mc.isManagedEnvironment()) {
                throw new FBSQLException("Cannot set transaction parameters in managed environment.");
            }
            this.mc.setTransactionParameters(isolationLevel, tpb);
        }
    }

    @Override
    public void setTransactionParameters(TransactionParameterBuffer tpb) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getLocalTransaction().inTransaction()) {
                throw new FBSQLException("Cannot set transaction parameters when transaction is already started.");
            }
            this.mc.setTransactionParameters(tpb);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public Blob createBlob() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBBlob fBBlob = this.createBlob(FBBlob.createConfig(0, this.connectionProperties(), this.getFbDatabase().getDatatypeCoder()));
            return fBBlob;
        }
    }

    private FBBlob createBlob(FBBlob.Config blobConfig) throws SQLException {
        return new FBBlob(this.getGDSHelper(), this.txCoordinator, blobConfig);
    }

    @Override
    public Clob createClob() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBBlob blob = this.createBlob(FBBlob.createConfig(1, this.connectionProperties(), this.getFbDatabase().getDatatypeCoder()));
            FBClob fBClob = new FBClob(blob);
            return fBClob;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type STRUCT not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            String string = FBEscapedParser.toNativeSql(sql);
            return string;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getAutoCommit() == autoCommit) {
                return;
            }
            this.txCoordinator.switchTransactionCoordinator(autoCommit);
        }
    }

    protected void setTransactionCoordinator(boolean managedConnection, boolean autoCommit) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.txCoordinator.setTransactionCoordinator(managedConnection, autoCommit);
        }
    }

    public void setManagedEnvironment(boolean managedConnection) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.setTransactionCoordinator(managedConnection, true);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.isClosed()) {
                throw new FBSQLException("You cannot getAutoCommit on an unassociated closed connection.");
            }
            boolean bl = this.txCoordinator.getAutoCommit();
            return bl;
        }
    }

    @Override
    public void commit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.isClosed()) {
                throw new FBSQLException("You cannot commit a closed connection.", "08003");
            }
            if (this.mc.inDistributedTransaction()) {
                throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
            }
            this.txCoordinator.commit();
            this.invalidateTransactionLifetimeObjects();
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.isClosed()) {
                throw new FBSQLException("You cannot rollback closed connection.", "08003");
            }
            if (this.mc.inDistributedTransaction()) {
                throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
            }
            this.txCoordinator.rollback();
            this.invalidateTransactionLifetimeObjects();
        }
    }

    protected void invalidateTransactionLifetimeObjects() {
        this.invalidateSavepoints();
        this.storedProcedureMetaData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Connection closed requested at", new RuntimeException("Connection close logging"));
        }
        SQLExceptionChainBuilder<SQLException> chainBuilder = new SQLExceptionChainBuilder<SQLException>();
        try (LockCloseable ignored = this.withLock();){
            try {
                if (this.metaData != null) {
                    this.metaData.close();
                }
                this.freeStatements();
            }
            catch (SQLException e) {
                chainBuilder.append(e);
            }
            finally {
                this.metaData = null;
                this.closeMc(chainBuilder);
            }
        }
        if (chainBuilder.hasException()) {
            throw chainBuilder.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMc(SQLExceptionChainBuilder<SQLException> chainBuilder) {
        FBManagedConnection mc = this.mc;
        if (mc == null) {
            return;
        }
        if (!mc.inDistributedTransaction()) {
            try {
                this.txCoordinator.handleConnectionClose();
            }
            catch (SQLException e) {
                chainBuilder.append(e);
            }
            finally {
                block14: {
                    try {
                        this.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        if ("08003".equals(e.getSQLState())) break block14;
                        chainBuilder.append(e);
                    }
                }
            }
        }
        mc.close(this);
    }

    @Override
    public boolean isClosed() {
        return this.mc == null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout should be >= 0", "HY009");
        }
        if (this.isLockedByCurrentThread()) {
            return this.isValidImpl(timeout);
        }
        return this.isValidAsync(timeout);
    }

    private boolean isValidAsync(int timeout) {
        Future isValidFuture = ForkJoinPool.commonPool().submit(() -> this.isValidImpl(timeout));
        try {
            return timeout != 0 ? (Boolean)isValidFuture.get(timeout, TimeUnit.SECONDS) : (Boolean)isValidFuture.get();
        }
        catch (ExecutionException e) {
            log.debug("isValidImpl produced an exception", e);
            return false;
        }
        catch (InterruptedException e) {
            isValidFuture.cancel(true);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            isValidFuture.cancel(true);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isValidImpl(int timeout) {
        try (LockCloseable ignored = this.withLock();){
            boolean bl;
            boolean networkTimeoutChanged;
            int originalNetworkTimeout;
            block28: {
                if (this.isClosed()) {
                    boolean bl2 = false;
                    return bl2;
                }
                originalNetworkTimeout = -1;
                networkTimeoutChanged = false;
                FbDatabase db = this.getFbDatabase();
                if (timeout != 0) {
                    try {
                        originalNetworkTimeout = db.getNetworkTimeout();
                        db.setNetworkTimeout((int)TimeUnit.SECONDS.toMillis(timeout));
                        networkTimeoutChanged = true;
                    }
                    catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                        // empty catch block
                    }
                }
                db.getDatabaseInfo(new byte[]{32, 1}, 10);
                bl = true;
                if (!networkTimeoutChanged) break block28;
                try {
                    this.getFbDatabase().setNetworkTimeout(originalNetworkTimeout);
                }
                catch (SQLException e) {
                    log.debug("Exception while resetting connection network timeout", e);
                    boolean bl3 = false;
                    if (ignored != null) {
                        ignored.close();
                    }
                    return bl3;
                }
            }
            return bl;
            catch (SQLException ex) {
                boolean bl4;
                block29: {
                    try {
                        log.debug("Exception while checking connection validity", ex);
                        bl4 = false;
                        if (!networkTimeoutChanged) break block29;
                    }
                    catch (Throwable throwable) {
                        block30: {
                            if (!networkTimeoutChanged) break block30;
                            try {
                                this.getFbDatabase().setNetworkTimeout(originalNetworkTimeout);
                            }
                            catch (SQLException e) {
                                log.debug("Exception while resetting connection network timeout", e);
                                boolean bl5 = false;
                                if (ignored != null) {
                                    ignored.close();
                                }
                                return bl5;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.getFbDatabase().setNetworkTimeout(originalNetworkTimeout);
                    }
                    catch (SQLException e) {
                        log.debug("Exception while resetting connection network timeout", e);
                        boolean bl6 = false;
                        if (ignored != null) {
                            ignored.close();
                        }
                        return bl6;
                    }
                }
                if (ignored != null) {
                    ignored.close();
                }
                return bl4;
            }
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.metaData == null) {
                this.metaData = new FBDatabaseMetaData(this);
            }
            FBDatabaseMetaData fBDatabaseMetaData = this.metaData;
            return fBDatabaseMetaData;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getLocalTransaction().inTransaction() && !this.mc.isManagedEnvironment()) {
                throw new FBSQLException("Calling setReadOnly(boolean) method is not allowed when transaction is already started.");
            }
            this.mc.setReadOnly(readOnly);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            boolean bl = this.mc.isReadOnly();
            return bl;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkValidity();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (!this.getAutoCommit() && !this.mc.isManagedEnvironment()) {
                this.txCoordinator.commit();
            }
            this.mc.setTransactionIsolation(level);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            int n = this.mc.getTransactionIsolation();
            return n;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            SQLWarning sQLWarning = this.firstWarning;
            return sQLWarning;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.firstWarning = null;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (resultSetHoldability == 1 && resultSetType == 1003) {
                this.addWarning(FbExceptionBuilder.forWarning(337248265).toSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            if (resultSetType == 1005) {
                this.addWarning(FbExceptionBuilder.forWarning(337248266).toSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            this.checkHoldability(resultSetType, resultSetHoldability);
            FBStatement stmt = new FBStatement(this.getGDSHelper(), resultSetType, resultSetConcurrency, resultSetHoldability, this.txCoordinator);
            this.activeStatements.add(stmt);
            FBStatement fBStatement = stmt;
            return fBStatement;
        }
    }

    private void checkHoldability(int resultSetType, int resultSetHoldability) throws SQLException {
        boolean notScrollable;
        boolean holdable = resultSetHoldability == 1;
        boolean bl = notScrollable = resultSetType != 1004;
        if (holdable && notScrollable) {
            throw new FBDriverNotCapableException("Holdable cursors are supported only for scrollable insensitive result sets.");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
    }

    @Deprecated
    protected PreparedStatement prepareMetaDataStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability, true, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.getGeneratedKeysSupport().buildQuery(sql, autoGeneratedKeys);
            PreparedStatement preparedStatement = this.prepareStatement(query);
            return preparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.getGeneratedKeysSupport().buildQuery(sql, columnIndexes);
            PreparedStatement preparedStatement = this.prepareStatement(query);
            return preparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.getGeneratedKeysSupport().buildQuery(sql, columnNames);
            PreparedStatement preparedStatement = this.prepareStatement(query);
            return preparedStatement;
        }
    }

    private PreparedStatement prepareStatement(GeneratedKeysSupport.Query query) throws SQLException {
        if (query.generatesKeys()) {
            return this.prepareStatement(query.getQueryString(), 1003, 1007, 2, false, true);
        }
        return this.prepareStatement(query.getQueryString());
    }

    protected PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean metaData, boolean generatedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (resultSetHoldability == 1 && resultSetType == 1003) {
                this.addWarning(FbExceptionBuilder.forWarning(337248265).toSQLException(SQLWarning.class));
                resultSetType = 1004;
            } else if (resultSetType == 1005) {
                this.addWarning(FbExceptionBuilder.forWarning(337248266).toSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            this.checkHoldability(resultSetType, resultSetHoldability);
            FBObjectListener.StatementListener coordinator = this.txCoordinator;
            if (metaData) {
                coordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.txCoordinator);
            }
            InternalTransactionCoordinator blobCoordinator = metaData ? null : this.txCoordinator;
            FBPreparedStatement stmt = new FBPreparedStatement(this.getGDSHelper(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, coordinator, blobCoordinator, metaData, false, generatedKeys);
            this.activeStatements.add(stmt);
            FBPreparedStatement fBPreparedStatement = stmt;
            return fBPreparedStatement;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (resultSetHoldability == 1 && resultSetType == 1003) {
                this.addWarning(FbExceptionBuilder.forWarning(337248265).toSQLException(SQLWarning.class));
                resultSetType = 1004;
            } else if (resultSetType == 1005) {
                this.addWarning(FbExceptionBuilder.forWarning(337248266).toSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            if (resultSetConcurrency != 1007) {
                this.addWarning(FbExceptionBuilder.forWarning(337248267).toSQLException(SQLWarning.class));
                resultSetConcurrency = 1007;
            }
            this.checkHoldability(resultSetType, resultSetHoldability);
            if (this.storedProcedureMetaData == null) {
                this.storedProcedureMetaData = StoredProcedureMetaDataFactory.getInstance(this);
            }
            FBCallableStatement stmt = new FBCallableStatement(this.getGDSHelper(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, this.storedProcedureMetaData, this.txCoordinator, this.txCoordinator);
            this.activeStatements.add(stmt);
            FBCallableStatement fBCallableStatement = stmt;
            return fBCallableStatement;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    private int getNextSavepointCounter() {
        return SAVEPOINT_COUNTER_UPDATE.getAndIncrement(this);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBSavepoint savepoint = new FBSavepoint(this.getNextSavepointCounter());
            this.setSavepoint(savepoint);
            FBSavepoint fBSavepoint = savepoint;
            return fBSavepoint;
        }
    }

    private void setSavepoint(FBSavepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.", "25000");
        }
        if (this.mc.inDistributedTransaction()) {
            throw new SQLException("Connection enlisted in distributed transaction", "25000");
        }
        this.txCoordinator.ensureTransaction();
        StringBuilder setSavepoint = new StringBuilder("SAVEPOINT ");
        this.getQuoteStrategy().appendQuoted(savepoint.getServerSavepointId(), setSavepoint);
        this.getGDSHelper().executeImmediate(setSavepoint.toString());
        this.savepoints.add(savepoint);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBSavepoint savepoint = new FBSavepoint(name);
            this.setSavepoint(savepoint);
            FBSavepoint fBSavepoint = savepoint;
            return fBSavepoint;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getAutoCommit()) {
                throw new SQLException("Connection.rollback(Savepoint) method cannot be used in auto-commit mode.", "25000");
            }
            if (!(savepoint instanceof FBSavepoint)) {
                throw new SQLException("Specified savepoint was not obtained from this connection.");
            }
            if (this.mc.inDistributedTransaction()) {
                throw new SQLException("Connection enlisted in distributed transaction", "25000");
            }
            FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
            if (!fbSavepoint.isValid()) {
                throw new SQLException("Savepoint is no longer valid.");
            }
            StringBuilder rollbackSavepoint = new StringBuilder("ROLLBACK TO ");
            this.getQuoteStrategy().appendQuoted(fbSavepoint.getServerSavepointId(), rollbackSavepoint);
            this.getGDSHelper().executeImmediate(rollbackSavepoint.toString());
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getAutoCommit()) {
                throw new SQLException("Connection.releaseSavepoint() method cannot be used in auto-commit mode.", "25000");
            }
            if (!(savepoint instanceof FBSavepoint)) {
                throw new SQLException("Specified savepoint was not obtained from this connection.");
            }
            FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
            if (!fbSavepoint.isValid()) {
                throw new SQLException("Savepoint is no longer valid.");
            }
            StringBuilder rollbackSavepoint = new StringBuilder("RELEASE SAVEPOINT ");
            this.getQuoteStrategy().appendQuoted(fbSavepoint.getServerSavepointId(), rollbackSavepoint).append(" ONLY");
            this.getGDSHelper().executeImmediate(rollbackSavepoint.toString());
            fbSavepoint.invalidate();
            this.savepoints.remove(fbSavepoint);
        }
    }

    protected void invalidateSavepoints() {
        try (LockCloseable ignored = this.withLock();){
            for (FBSavepoint savepoint : this.savepoints) {
                savepoint.invalidate();
            }
            this.savepoints.clear();
        }
    }

    public FBLocalTransaction getLocalTransaction() {
        try (LockCloseable ignored = this.withLock();){
            if (this.localTransaction == null) {
                this.localTransaction = this.mc.getLocalTransaction();
            }
            FBLocalTransaction fBLocalTransaction = this.localTransaction;
            return fBLocalTransaction;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(FBConnection.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkValidity();
        return null;
    }

    @Deprecated
    public boolean inTransaction() throws SQLException {
        return this.getGDSHelper().inTransaction();
    }

    @Override
    @Deprecated
    public String getIscEncoding() throws SQLException {
        return this.getGDSHelper().getIscEncoding();
    }

    public void addWarning(SQLWarning warning) {
        try (LockCloseable ignored = this.withLock();){
            if (this.firstWarning == null) {
                this.firstWarning = warning;
            } else {
                this.firstWarning.setNextWarning(warning);
            }
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        return (NClob)this.createClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    public GDSHelper getGDSHelper() throws SQLException {
        if (this.mc == null) {
            throw new FbExceptionBuilder().exception(335544363).toSQLException();
        }
        return this.mc.getGDSHelper();
    }

    @Override
    public boolean isUseFirebirdAutoCommit() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isUseFirebirdAutocommit();
    }

    @Deprecated
    protected void checkClientInfoSupport() throws SQLException {
        if (!this.getFbDatabase().getServerVersion().isEqualOrAbove(2, 0)) {
            throw new FBDriverNotCapableException("Required functionality (RDB$SET_CONTEXT()) only available in Firebird 2.0 or higher");
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkValidity();
        this.checkClientInfoSupport();
        Properties result = new Properties();
        try (PreparedStatement stmt = this.prepareStatement(GET_CLIENT_INFO_SQL);){
            for (String propName : this.clientInfoPropNames) {
                result.put(propName, this.getClientInfo(stmt, propName));
            }
        }
        return result;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkValidity();
        this.checkClientInfoSupport();
        try (PreparedStatement stmt = this.prepareStatement(GET_CLIENT_INFO_SQL);){
            String string = this.getClientInfo(stmt, name);
            return string;
        }
    }

    protected String getClientInfo(PreparedStatement stmt, String name) throws SQLException {
        stmt.clearParameters();
        stmt.setString(1, name);
        stmt.setString(2, name);
        try (ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String sessionContext = rs.getString(1);
            String transactionContext = rs.getString(2);
            if (transactionContext != null) {
                String string = transactionContext;
                return string;
            }
            String string = sessionContext;
            return string;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        SQLExceptionChainBuilder<SQLClientInfoException> chain = new SQLExceptionChainBuilder<SQLClientInfoException>();
        try {
            this.checkValidity();
            this.checkClientInfoSupport();
            try (PreparedStatement stmt = this.prepareStatement(SET_CLIENT_INFO_SQL);){
                for (String propName : properties.stringPropertyNames()) {
                    String propValue = properties.getProperty(propName);
                    try {
                        this.setClientInfo(stmt, propName, propValue);
                    }
                    catch (SQLClientInfoException ex) {
                        chain.append(ex);
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null, (Throwable)ex);
        }
        if (chain.hasException()) {
            throw (SQLClientInfoException)chain.getException();
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkValidity();
            this.checkClientInfoSupport();
            try (PreparedStatement stmt = this.prepareStatement(SET_CLIENT_INFO_SQL);){
                this.setClientInfo(stmt, name, value);
            }
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null, (Throwable)ex);
        }
    }

    protected void setClientInfo(PreparedStatement stmt, String name, String value) throws SQLException {
        try {
            stmt.clearParameters();
            stmt.setString(1, name);
            stmt.setString(2, value);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    throw new FBDriverConsistencyCheckException("Expected result from RDB$SET_CONTEXT call");
                }
                rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(null, (Throwable)ex);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            SQLPermission sqlPermission = new SQLPermission(PERMISSION_SET_NETWORK_TIMEOUT);
            securityManager.checkPermission(sqlPermission);
        }
        if (executor == null) {
            throw FbExceptionBuilder.forException(337248297).toSQLException();
        }
        if (milliseconds < 0) {
            throw FbExceptionBuilder.forException(337248296).toSQLException();
        }
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.getFbDatabase().setNetworkTimeout(milliseconds);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.getFbDatabase().getNetworkTimeout();
    }

    protected final LockCloseable withLock() {
        FBManagedConnection mc = this.mc;
        if (mc != null) {
            return mc.withLock();
        }
        return LockCloseable.NO_OP;
    }

    protected final boolean isLockedByCurrentThread() {
        FBManagedConnection mc = this.mc;
        if (mc != null) {
            return mc.isLockedByCurrentThread();
        }
        return false;
    }

    QuoteStrategy getQuoteStrategy() throws SQLException {
        return QuoteStrategy.forDialect(this.getGDSHelper().getDialect());
    }

    GeneratedKeysSupport getGeneratedKeysSupport() throws SQLException {
        if (this.generatedKeysSupport == null) {
            this.generatedKeysSupport = GeneratedKeysSupportFactory.createFor(this.getGeneratedKeysEnabled(), (FirebirdDatabaseMetaData)this.getMetaData());
        }
        return this.generatedKeysSupport;
    }

    private String getGeneratedKeysEnabled() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null ? props.getGeneratedKeysEnabled() : null;
    }

    boolean isIgnoreProcedureType() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isIgnoreProcedureType();
    }

    boolean isScrollableCursor(String scrollableCursor) {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && scrollableCursor != null && scrollableCursor.equalsIgnoreCase(props.getScrollableCursor());
    }

    boolean isUseServerBatch() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isUseServerBatch();
    }

    int getServerBatchBufferSize() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null ? props.getServerBatchBufferSize() : 0;
    }

    boolean isExtendedMetadata() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isExtendedMetadata();
    }
}

