/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBDriverPropertyManager;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBConnectionProperties
implements FirebirdConnectionProperties,
Serializable,
Cloneable {
    private static final long serialVersionUID = 611228437520889118L;
    public static final String DATABASE_PROPERTY = "database";
    public static final String TYPE_PROPERTY = "type";
    public static final String ISOLATION_PROPERTY = "isolation";
    public static final String DEFAULT_ISOLATION_PROPERTY = "defaultIsolation";
    public static final String BLOB_BUFFER_SIZE_PROPERTY = "blobBufferSize";
    public static final String LOCAL_ENCODING_PROPERTY = "localEncoding";
    public static final String ENCODING_PROPERTY = "encoding";
    public static final String ROLE_NAME_PROPERTY = "roleName";
    public static final String SQL_DIALECT_PROPERTY = "sqlDialect";
    public static final String USE_TRANSLATION_PROPERTY = "useTranslation";
    public static final String USE_STREAM_BLOBS_PROPERTY = "useStreamBlobs";
    public static final String USE_STANDARD_UDF_PROPERTY = "useStandardUdf";
    public static final String SOCKET_BUFFER_SIZE_PROPERTY = "socketBufferSize";
    public static final String TIMESTAMP_USES_LOCAL_TIMEZONE_PROPERTY = "timestampUsesLocalTimezone";
    public static final String USER_NAME_PROPERTY = "userName";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String BUFFERS_NUMBER_PROPERTY = "buffersNumber";
    public static final String DEFAULT_HOLDABLE_RS_PROPERTY = "defaultHoldable";
    public static final String SO_TIMEOUT = "soTimeout";
    public static final String CONNECT_TIMEOUT = "connectTimeout";
    public static final String USE_FIREBIRD_AUTOCOMMIT = "useFirebirdAutocommit";
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String type;
    private String database;
    private String tpbMapping;
    private int defaultTransactionIsolation = 2;
    private Map<Integer, TransactionParameterBuffer> customMapping = new HashMap<Integer, TransactionParameterBuffer>();
    private FBTpbMapper mapper;

    private int getIntProperty(String name) {
        Integer value = (Integer)this.properties.get(this.getCanonicalName(name));
        return value != null ? value : 0;
    }

    private String getCanonicalName(String propertyName) {
        return FBDriverPropertyManager.getCanonicalName(propertyName);
    }

    private String getStringProperty(String name) {
        Object value = this.properties.get(this.getCanonicalName(name));
        return value != null ? value.toString() : null;
    }

    private boolean getBooleanProperty(String name) {
        String canonicalName = this.getCanonicalName(name);
        return this.properties.containsKey(canonicalName) && (Boolean)this.properties.get(canonicalName) != false;
    }

    private void setIntProperty(String name, int value) {
        this.properties.put(this.getCanonicalName(name), value);
    }

    private void setStringProperty(String name, String value) {
        if (DATABASE_PROPERTY.equals(name)) {
            this.setDatabase(value);
        } else if (TYPE_PROPERTY.equals(name)) {
            this.setType(value);
        }
        name = this.getCanonicalName(name);
        Object objValue = FBConnectionHelper.parseDpbString(name, value);
        this.properties.put(name, objValue);
    }

    private void setBooleanProperty(String name, boolean value) {
        if (value) {
            this.properties.put(this.getCanonicalName(name), null);
        } else {
            this.properties.remove(name);
        }
    }

    public int hashCode() {
        int result = 17;
        result = result * 151 + (this.type != null ? this.type.hashCode() : 0);
        result = result * 151 + (this.database != null ? this.database.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBConnectionProperties)) {
            return false;
        }
        FBConnectionProperties that = (FBConnectionProperties)obj;
        boolean result = ((Object)this.properties).equals(that.properties);
        result &= this.type != null ? this.type.equals(that.type) : that.type == null;
        result &= this.database != null ? this.database.equals(that.database) : that.database == null;
        result &= this.tpbMapping != null ? this.tpbMapping.equals(that.tpbMapping) : that.tpbMapping == null;
        result &= this.defaultTransactionIsolation == that.defaultTransactionIsolation;
        result &= ((Object)this.customMapping).equals(that.customMapping);
        return result &= this.mapper == null || that.mapper == null || this.mapper.equals(that.mapper);
    }

    public Object clone() {
        try {
            FBConnectionProperties clone = (FBConnectionProperties)super.clone();
            clone.properties = new HashMap<String, Object>(this.properties);
            clone.customMapping = new HashMap<Integer, TransactionParameterBuffer>(this.customMapping);
            clone.mapper = this.mapper != null ? (FBTpbMapper)this.mapper.clone() : null;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure: clone not supported");
        }
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int getBlobBufferSize() {
        return this.getIntProperty(BLOB_BUFFER_SIZE_PROPERTY);
    }

    @Override
    public void setBlobBufferSize(int bufferSize) {
        this.setIntProperty(BLOB_BUFFER_SIZE_PROPERTY, bufferSize);
    }

    @Override
    public String getCharSet() {
        return this.getStringProperty(LOCAL_ENCODING_PROPERTY);
    }

    @Override
    public void setCharSet(String charSet) {
        String encoding;
        if (charSet == null) {
            return;
        }
        String normalizedCharSet = EncodingFactory.getJavaEncodingForAlias(charSet);
        if (normalizedCharSet != null) {
            this.setStringProperty(LOCAL_ENCODING_PROPERTY, normalizedCharSet);
        }
        if ((encoding = this.getStringProperty(ENCODING_PROPERTY)) != null) {
            return;
        }
        encoding = EncodingFactory.getIscEncoding(charSet);
        if (encoding != null) {
            this.setStringProperty(ENCODING_PROPERTY, encoding);
        }
    }

    @Override
    public String getEncoding() {
        return this.getStringProperty(ENCODING_PROPERTY);
    }

    @Override
    public void setEncoding(String encoding) {
        if (encoding == null) {
            return;
        }
        this.setStringProperty(ENCODING_PROPERTY, encoding);
        String charSet = this.getStringProperty(LOCAL_ENCODING_PROPERTY);
        if (charSet != null) {
            return;
        }
        charSet = EncodingFactory.getJavaEncoding(encoding);
        if (charSet != null) {
            this.setStringProperty(LOCAL_ENCODING_PROPERTY, charSet);
        }
    }

    @Override
    public String getRoleName() {
        return this.getStringProperty(ROLE_NAME_PROPERTY);
    }

    @Override
    public void setRoleName(String roleName) {
        if (roleName != null) {
            this.setStringProperty(ROLE_NAME_PROPERTY, roleName);
        }
    }

    @Override
    public String getSqlDialect() {
        return this.getStringProperty(SQL_DIALECT_PROPERTY);
    }

    @Override
    public void setSqlDialect(String sqlDialect) {
        if (sqlDialect != null) {
            this.setStringProperty(SQL_DIALECT_PROPERTY, sqlDialect);
        }
    }

    @Override
    public String getUseTranslation() {
        return this.getStringProperty(USE_TRANSLATION_PROPERTY);
    }

    @Override
    public void setUseTranslation(String translationPath) {
        if (translationPath != null) {
            this.setStringProperty(USE_TRANSLATION_PROPERTY, translationPath);
        }
    }

    @Override
    public boolean isUseStreamBlobs() {
        return this.getBooleanProperty(USE_STREAM_BLOBS_PROPERTY);
    }

    @Override
    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.setBooleanProperty(USE_STREAM_BLOBS_PROPERTY, useStreamBlobs);
    }

    @Override
    public boolean isUseStandardUdf() {
        return this.getBooleanProperty(USE_STANDARD_UDF_PROPERTY);
    }

    @Override
    public void setUseStandardUdf(boolean useStandardUdf) {
        this.setBooleanProperty(USE_STANDARD_UDF_PROPERTY, useStandardUdf);
    }

    @Override
    public int getSocketBufferSize() {
        return this.getIntProperty(SOCKET_BUFFER_SIZE_PROPERTY);
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.setIntProperty(SOCKET_BUFFER_SIZE_PROPERTY, socketBufferSize);
    }

    @Override
    public boolean isTimestampUsesLocalTimezone() {
        return this.getBooleanProperty(TIMESTAMP_USES_LOCAL_TIMEZONE_PROPERTY);
    }

    @Override
    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.setBooleanProperty(TIMESTAMP_USES_LOCAL_TIMEZONE_PROPERTY, timestampUsesLocalTimezone);
    }

    @Override
    public String getUserName() {
        return this.getStringProperty(USER_NAME_PROPERTY);
    }

    @Override
    public void setUserName(String userName) {
        this.setStringProperty(USER_NAME_PROPERTY, userName);
    }

    @Override
    public String getPassword() {
        return this.getStringProperty(PASSWORD_PROPERTY);
    }

    @Override
    public void setPassword(String password) {
        this.setStringProperty(PASSWORD_PROPERTY, password);
    }

    @Override
    public int getBuffersNumber() {
        return this.getIntProperty(BUFFERS_NUMBER_PROPERTY);
    }

    @Override
    public void setBuffersNumber(int buffersNumber) {
        this.setIntProperty(BUFFERS_NUMBER_PROPERTY, buffersNumber);
    }

    @Override
    public String getNonStandardProperty(String key) {
        return this.getStringProperty(key);
    }

    @Override
    public void setNonStandardProperty(String key, String value) {
        if (ISOLATION_PROPERTY.equals(key) || DEFAULT_ISOLATION_PROPERTY.equals(key)) {
            this.setDefaultIsolation(value);
        } else {
            this.setStringProperty(key, value);
        }
    }

    @Override
    public boolean isDefaultResultSetHoldable() {
        return this.getBooleanProperty(DEFAULT_HOLDABLE_RS_PROPERTY);
    }

    @Override
    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.setBooleanProperty(DEFAULT_HOLDABLE_RS_PROPERTY, isHoldable);
    }

    @Override
    public int getSoTimeout() {
        return this.getIntProperty(SO_TIMEOUT);
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.setIntProperty(SO_TIMEOUT, soTimeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.getIntProperty(CONNECT_TIMEOUT);
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.setIntProperty(CONNECT_TIMEOUT, connectTimeout);
    }

    @Override
    public boolean isUseFirebirdAutocommit() {
        return this.getBooleanProperty(USE_FIREBIRD_AUTOCOMMIT);
    }

    @Override
    public void setUseFirebirdAutocommit(boolean useFirebirdAutocommit) {
        this.setBooleanProperty(USE_FIREBIRD_AUTOCOMMIT, useFirebirdAutocommit);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        char[] chars = propertyMapping.toCharArray();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean keyProcessed = false;
        for (char ch : chars) {
            boolean isSeparator;
            boolean bl = isSeparator = Character.isWhitespace(ch) || ch == '=' || ch == ':';
            if (key.length() == 0 && isSeparator) continue;
            if (!keyProcessed && !isSeparator) {
                key.append(ch);
                continue;
            }
            if (!keyProcessed) {
                keyProcessed = true;
                continue;
            }
            if (value.length() == 0 && isSeparator) continue;
            value.append(ch);
        }
        String keyStr = key.toString().trim();
        String valueStr = value.length() > 0 ? value.toString().trim() : null;
        this.setNonStandardProperty(keyStr, valueStr);
    }

    @Override
    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        GDS gds = this.getGds();
        DatabaseParameterBuffer dpb = gds.createDatabaseParameterBuffer();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String propertyName = entry.getKey();
            Object value = entry.getValue();
            Integer dpbType = FBConnectionHelper.getDpbKey(propertyName);
            if (dpbType == null) continue;
            if (value instanceof Boolean) {
                if (!((Boolean)value).booleanValue()) continue;
                dpb.addArgument(dpbType);
                continue;
            }
            if (value instanceof Byte) {
                dpb.addArgument((int)dpbType, new byte[]{(Byte)value});
                continue;
            }
            if (value instanceof Integer) {
                dpb.addArgument((int)dpbType, (Integer)value);
                continue;
            }
            if (value instanceof String) {
                dpb.addArgument((int)dpbType, (String)value);
                continue;
            }
            if (value != null) continue;
            dpb.addArgument(dpbType);
        }
        return dpb;
    }

    @Override
    public String getTpbMapping() {
        return this.tpbMapping;
    }

    @Override
    public void setTpbMapping(String tpbMapping) {
        if (this.mapper != null) {
            throw new IllegalStateException("Properties are already initialized.");
        }
        this.tpbMapping = tpbMapping;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        if (this.mapper != null) {
            return this.mapper.getDefaultTransactionIsolation();
        }
        return this.defaultTransactionIsolation;
    }

    @Override
    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.defaultTransactionIsolation = defaultIsolationLevel;
        if (this.mapper != null) {
            this.mapper.setDefaultTransactionIsolation(defaultIsolationLevel);
        }
    }

    @Override
    public String getDefaultIsolation() {
        return FBTpbMapper.getTransactionIsolationName(this.getDefaultTransactionIsolation());
    }

    @Override
    public void setDefaultIsolation(String isolation) {
        this.setDefaultTransactionIsolation(FBTpbMapper.getTransactionIsolationLevel(isolation));
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        if (this.mapper != null) {
            return this.mapper.getMapping(isolation);
        }
        return this.customMapping.get(isolation);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.customMapping.put(isolation, tpb);
        if (this.mapper != null) {
            this.mapper.setMapping(isolation, tpb);
        }
    }

    public FBTpbMapper getMapper() throws FBResourceException {
        if (this.mapper != null) {
            return this.mapper;
        }
        GDS gds = this.getGds();
        this.mapper = this.tpbMapping == null ? FBTpbMapper.getDefaultMapper(gds) : new FBTpbMapper(gds, this.tpbMapping, this.getClass().getClassLoader());
        this.mapper.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
        for (Map.Entry<Integer, TransactionParameterBuffer> entry : this.customMapping.entrySet()) {
            Integer isolation = entry.getKey();
            TransactionParameterBuffer tpb = entry.getValue();
            this.mapper.setMapping(isolation, tpb);
        }
        return this.mapper;
    }

    private GDS getGds() {
        GDSType gdsType = GDSType.getType(this.type);
        if (gdsType == null && this.type != null) {
            throw new IllegalArgumentException("Unknown GDS type " + this.type);
        }
        return GDSFactory.getGDSForType(gdsType);
    }
}

