/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBBlobField
extends FBField
implements FBFlushableField {
    private FBBlob blob;
    private int length;
    private InputStream binaryStream;
    private Reader characterStream;
    private byte[] bytes;

    FBBlobField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.close();
            }
        }
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        finally {
            this.blob = null;
            this.bytes = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.length = 0;
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        byte[] bytes = this.getFieldData();
        if (bytes == null) {
            return BLOB_NULL_VALUE;
        }
        this.blob = new FBBlob(this.gdsHelper, this.field.decodeLong(bytes));
        return this.blob;
    }

    @Override
    public Clob getClob() throws SQLException {
        FBBlob blob = (FBBlob)this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return CLOB_NULL_VALUE;
        }
        return new FBClob(blob);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.field.sqlsubtype < 0) {
            throw (SQLException)FBBlobField.createException(BINARY_STREAM_CONVERSION_ERROR).fillInStackTrace();
        }
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return STREAM_NULL_VALUE;
        }
        return blob.getBinaryStream();
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.getBytesInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytesInternal() throws SQLException {
        byte[] blobIdBuffer = this.getFieldData();
        if (blobIdBuffer == null) {
            return BYTES_NULL_VALUE;
        }
        long blobId = this.field.decodeLong(blobIdBuffer);
        Object object = ((Synchronizable)((Object)this.getBlob())).getSynchronizationObject();
        synchronized (object) {
            byte[] byArray;
            IscBlobHandle blobHandle = this.gdsHelper.openBlob(blobId, true);
            try {
                byte[] segmentBuffer;
                int blobLength = this.gdsHelper.getBlobLength(blobHandle);
                int bufferLength = this.gdsHelper.getBlobBufferLength();
                byte[] resultBuffer = new byte[blobLength];
                for (int offset = 0; offset < blobLength; offset += segmentBuffer.length) {
                    segmentBuffer = this.gdsHelper.getBlobSegment(blobHandle, bufferLength);
                    if (segmentBuffer.length == 0) {
                        throw FBBlobField.createException(BYTES_CONVERSION_ERROR);
                    }
                    System.arraycopy(segmentBuffer, 0, resultBuffer, offset, segmentBuffer.length);
                }
                byArray = resultBuffer;
            }
            catch (Throwable throwable) {
                try {
                    this.gdsHelper.closeBlob(blobHandle);
                    throw throwable;
                }
                catch (GDSException e) {
                    throw new FBSQLException(e);
                }
            }
            this.gdsHelper.closeBlob(blobHandle);
            return byArray;
        }
    }

    @Override
    public byte[] getCachedData() throws SQLException {
        if (this.getFieldData() != null) {
            return this.getBytesInternal();
        }
        if (this.bytes != null) {
            return this.bytes;
        }
        return BYTES_NULL_VALUE;
    }

    @Override
    public FBFlushableField.CachedObject getCachedObject() throws SQLException {
        if (this.getFieldData() == null) {
            return new FBFlushableField.CachedObject(this.bytes, this.binaryStream, this.characterStream, this.length);
        }
        byte[] bytesInternal = this.getBytesInternal();
        return new FBFlushableField.CachedObject(bytesInternal, null, null, bytesInternal.length);
    }

    @Override
    public void setCachedObject(FBFlushableField.CachedObject cachedObject) throws SQLException {
        this.setNull();
        this.bytes = cachedObject.bytes;
        this.binaryStream = cachedObject.binaryStream;
        this.characterStream = cachedObject.characterStream;
        this.length = cachedObject.length;
    }

    @Override
    public String getString() throws SQLException {
        if (this.field.sqlsubtype < 0) {
            throw (SQLException)FBBlobField.createException(STRING_CONVERSION_ERROR).fillInStackTrace();
        }
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeString(this.getBytes(), this.javaEncoding, this.mappingPath);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public void setAsciiStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, length);
    }

    @Override
    public void setCharacterStream(Reader in, int length) throws SQLException {
        this.setNull();
        if (in != READER_NULL_VALUE) {
            this.characterStream = in;
            this.length = length;
        }
    }

    @Override
    public void setBinaryStream(InputStream in, int length) throws SQLException {
        this.setNull();
        if (in != STREAM_NULL_VALUE) {
            this.binaryStream = in;
            this.length = length;
        }
    }

    @Override
    public void flushCachedData() throws SQLException {
        if (this.binaryStream != null) {
            this.copyBinaryStream(this.binaryStream, this.length);
        } else if (this.characterStream != null) {
            this.copyCharacterStream(this.characterStream, this.length, this.javaEncoding);
        } else if (this.bytes != null) {
            this.copyBytes(this.bytes, this.length);
        } else if (this.blob == null) {
            this.setNull();
        }
        this.characterStream = null;
        this.binaryStream = null;
        this.bytes = null;
        this.length = 0;
    }

    private void copyBinaryStream(InputStream in, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyStream(in, length);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }

    private void copyCharacterStream(Reader in, int length, String encoding) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyCharacterStream(in, length, encoding);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }

    private void copyBytes(byte[] bytes, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyBytes(bytes, 0, length);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        this.setNull();
        if (value != BYTES_NULL_VALUE) {
            this.bytes = value;
            this.length = value.length;
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setBytes(this.field.encodeString(value, this.javaEncoding, this.mappingPath));
    }

    @Override
    public void setUnicodeStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, length);
    }

    @Override
    public void setBlob(FBBlob blob) throws SQLException {
        this.setNull();
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
        this.blob = blob;
    }

    @Override
    public void setClob(FBClob clob) throws SQLException {
        FBBlob blob = clob.getWrappedBlob();
        this.setBlob(blob);
    }

    @Override
    public void setNull() {
        super.setNull();
        try {
            if (this.blob != null) {
                this.blob.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.blob = null;
        this.binaryStream = null;
        this.characterStream = null;
        this.bytes = null;
        this.length = 0;
    }
}

