/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.UnsupportedEncodingException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;

public abstract class Encoding_OneByte
implements Encoding {
    protected static void Initialize(String encoding, char[] byteToChar, byte[] charToByte) {
        Encoding_OneByte.Initialize(encoding, byteToChar, charToByte, EncodingFactory.DEFAULT_MAPPING);
    }

    protected static void Initialize(String encoding, char[] byteToChar, byte[] charToByte, char[] charMapping) {
        byte[] val = new byte[1];
        char[] charArray = null;
        for (int i = 0; i < 256; ++i) {
            val[0] = (byte)i;
            try {
                charArray = new String(val, 0, 1, encoding).toCharArray();
                char ch = charArray[0];
                byteToChar[i] = charMapping[ch];
                charToByte[byteToChar[i]] = (byte)i;
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
    }

    @Override
    public byte[] encodeToCharset(String str) {
        byte[] result = new byte[str.length()];
        this.encodeToCharset(str.toCharArray(), 0, str.length(), result);
        return result;
    }

    public abstract int encodeToCharset(char[] var1, int var2, int var3, byte[] var4);

    public int encodeToCharset(byte[] charToByte, char[] in, int off, int len, byte[] out) {
        for (int i = off; i < off + len; ++i) {
            out[i] = charToByte[in[i]];
        }
        return len;
    }

    @Override
    public String decodeFromCharset(byte[] in) {
        char[] bufferC = new char[in.length];
        int length = this.decodeFromCharset(in, 0, in.length, bufferC);
        return new String(bufferC, 0, length);
    }

    public abstract int decodeFromCharset(byte[] var1, int var2, int var3, char[] var4);

    public int decodeFromCharset(char[] byteToChar, byte[] in, int off, int len, char[] out) {
        for (int i = off; i < off + len; ++i) {
            out[i] = byteToChar[in[i] & 0xFF];
        }
        return len;
    }
}

