/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdResultSetMetaData;

public class FBResultSetMetaData
implements FirebirdResultSetMetaData {
    private final XSQLVAR[] xsqlvars;
    private Map<FieldKey, ExtendedFieldInfo> extendedInfo;
    private final AbstractConnection connection;
    private final ColumnStrategy columnStrategy;
    private final boolean octetsAsBytes;
    @Deprecated
    final int columnNoNulls = 0;
    @Deprecated
    final int columnNullable = 1;
    @Deprecated
    final int columnNullableUnknown = 2;
    private static final String GET_FIELD_INFO = "SELECT   RF.RDB$RELATION_NAME as RELATION_NAME, RF.RDB$FIELD_NAME as FIELD_NAME, F.RDB$FIELD_LENGTH as FIELD_LENGTH, F.RDB$FIELD_PRECISION as FIELD_PRECISION, F.RDB$FIELD_SCALE as FIELD_SCALE, F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE, F.RDB$CHARACTER_LENGTH as CHAR_LEN, F.RDB$CHARACTER_SET_ID as CHARACTER_SET_ID FROM  RDB$RELATION_FIELDS RF , RDB$FIELDS F  WHERE   RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME AND  RF.RDB$FIELD_NAME = ? AND  RF.RDB$RELATION_NAME = ?";

    protected FBResultSetMetaData(XSQLVAR[] xsqlvars, AbstractConnection connection) throws SQLException {
        this.xsqlvars = xsqlvars;
        this.connection = connection;
        if (connection != null) {
            DatabaseParameterBuffer dpb = connection.getDatabaseParameterBuffer();
            this.columnStrategy = dpb.hasArgument(142) ? ColumnStrategy.COLUMN_LABEL_FOR_NAME : ColumnStrategy.DEFAULT;
            this.octetsAsBytes = dpb.hasArgument(140);
        } else {
            this.columnStrategy = ColumnStrategy.DEFAULT;
            this.octetsAsBytes = false;
        }
    }

    private String getIscEncoding() throws SQLException {
        return this.connection != null ? this.connection.getIscEncoding() : "NONE";
    }

    @Override
    public int getColumnCount() {
        return this.xsqlvars.length;
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int sqlType = this.getXsqlvar((int)column).sqltype & 0xFFFFFFFE;
        return sqlType != 540 && sqlType != 520;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if ((this.getXsqlvar((int)column).sqltype & 1) == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        switch (this.getXsqlvar((int)column).sqltype & 0xFFFFFFFE) {
            case 480: 
            case 482: 
            case 496: 
            case 500: 
            case 530: 
            case 580: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int colType = this.getColumnType(column);
        switch (colType) {
            case 2: 
            case 3: {
                ExtendedFieldInfo fieldInfo = this.getExtFieldInfo(column);
                return fieldInfo == null || fieldInfo.fieldPrecision == 0 ? this.estimatePrecision(column) : fieldInfo.fieldPrecision;
            }
            case 1: 
            case 12: {
                XSQLVAR var = this.getXsqlvar(column);
                int charset = var.sqlsubtype & 0xFF;
                int charSetSize = charset == 127 ? EncodingFactory.getIscEncodingSize(this.getIscEncoding()) : EncodingFactory.getCharacterSetSize(charset);
                return var.sqllen / charSetSize;
            }
            case -3: 
            case -2: {
                XSQLVAR var = this.getXsqlvar(column);
                return var.sqllen;
            }
            case 6: {
                return 9;
            }
            case 8: {
                return 17;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 21;
            }
            case 5: {
                return 6;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 19;
            }
            case 16: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnStrategy.getColumnLabel(this.getXsqlvar(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnStrategy.getColumnName(this.getXsqlvar(column));
    }

    public String getSourceColumnName(int column) throws SQLException {
        String result = this.getXsqlvar((int)column).sqlname;
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int colType = this.getColumnType(column);
        switch (colType) {
            case 2: 
            case 3: {
                ExtendedFieldInfo fieldInfo = this.getExtFieldInfo(column);
                return fieldInfo == null || fieldInfo.fieldPrecision == 0 ? this.estimatePrecision(column) : fieldInfo.fieldPrecision;
            }
            case 1: 
            case 12: {
                XSQLVAR var = this.getXsqlvar(column);
                int charset = var.sqlsubtype & 0xFF;
                int charSetSize = charset == 127 ? EncodingFactory.getIscEncodingSize(this.getIscEncoding()) : EncodingFactory.getCharacterSetSize(charset);
                return var.sqllen / charSetSize;
            }
            case -3: 
            case -2: {
                XSQLVAR var = this.getXsqlvar(column);
                return var.sqllen;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 5: {
                return 5;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 19;
            }
            case 16: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getXsqlvar((int)column).sqlscale * -1;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        String result = this.getXsqlvar((int)column).relname;
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public String getTableAlias(int column) throws SQLException {
        String result = this.getXsqlvar((int)column).relaliasname;
        if (result == null) {
            result = this.getTableName(column);
        }
        return result;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int sqltype = this.getXsqlvar((int)column).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)column).sqlscale;
        int sqlsubtype = this.getXsqlvar((int)column).sqlsubtype;
        if (sqlscale < 0) {
            switch (sqltype) {
                case 480: 
                case 496: 
                case 500: 
                case 580: {
                    if (sqlsubtype == 2) {
                        return 3;
                    }
                    return 2;
                }
            }
        }
        switch (sqltype) {
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 480: 
            case 530: {
                return 8;
            }
            case 482: {
                return 6;
            }
            case 452: {
                if (this.octetsAsBytes && sqlsubtype == 1) {
                    return -2;
                }
                return 1;
            }
            case 448: {
                if (this.octetsAsBytes && sqlsubtype == 1) {
                    return -3;
                }
                return 12;
            }
            case 510: {
                return 93;
            }
            case 560: {
                return 92;
            }
            case 570: {
                return 91;
            }
            case 580: {
                if (sqlsubtype == 1) {
                    return 2;
                }
                if (sqlsubtype == 2) {
                    return 3;
                }
                return -5;
            }
            case 520: {
                if (sqlsubtype < 0) {
                    return 2004;
                }
                if (sqlsubtype == 0 || sqlsubtype > 1) {
                    return -4;
                }
                if (sqlsubtype == 1) {
                    return -1;
                }
                return 1111;
            }
            case 550: {
                return 1111;
            }
            case 32764: {
                return 16;
            }
        }
        return 0;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int sqltype = this.getXsqlvar((int)column).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)column).sqlscale;
        int sqlsubtype = this.getXsqlvar((int)column).sqlsubtype;
        if (sqlscale < 0) {
            switch (sqltype) {
                case 480: 
                case 496: 
                case 500: 
                case 580: {
                    if (sqlsubtype == 2) {
                        return "DECIMAL";
                    }
                    return "NUMERIC";
                }
            }
        }
        switch (sqltype) {
            case 500: {
                return "SMALLINT";
            }
            case 496: {
                return "INTEGER";
            }
            case 480: 
            case 530: {
                return "DOUBLE PRECISION";
            }
            case 482: {
                return "FLOAT";
            }
            case 452: {
                return "CHAR";
            }
            case 448: {
                return "VARCHAR";
            }
            case 510: {
                return "TIMESTAMP";
            }
            case 560: {
                return "TIME";
            }
            case 570: {
                return "DATE";
            }
            case 580: {
                if (sqlsubtype == 1) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "BIGINT";
            }
            case 520: {
                if (sqlsubtype < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (sqlsubtype == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (sqlsubtype == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE " + sqlsubtype;
            }
            case 550: {
                return "ARRAY";
            }
            case 32764: {
                return "BOOLEAN";
            }
        }
        return "NULL";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        switch (this.getXsqlvar((int)column).sqltype & 0xFFFFFFFE) {
            case 448: 
            case 452: {
                XSQLVAR var = this.getXsqlvar(column);
                if (this.octetsAsBytes && var.sqlsubtype == 1) {
                    return byte[].class.getName();
                }
                return String.class.getName();
            }
            case 496: 
            case 500: {
                return Integer.class.getName();
            }
            case 480: 
            case 482: 
            case 530: {
                return Double.class.getName();
            }
            case 510: {
                return Timestamp.class.getName();
            }
            case 520: {
                XSQLVAR field = this.getXsqlvar(column);
                if (field.sqlsubtype < 0) {
                    return Blob.class.getName();
                }
                if (field.sqlsubtype == 1) {
                    return String.class.getName();
                }
                return byte[].class.getName();
            }
            case 540: {
                return Array.class.getName();
            }
            case 550: {
                return Long.class.getName();
            }
            case 560: {
                return Time.class.getName();
            }
            case 570: {
                return Date.class.getName();
            }
            case 580: {
                if (this.getXsqlvar((int)column).sqlscale == 0) {
                    return Long.class.getName();
                }
                return BigDecimal.class.getName();
            }
            case 32764: {
                return Boolean.class.getName();
            }
        }
        throw new FBSQLException("Unknown SQL type.", "HY105");
    }

    private XSQLVAR getXsqlvar(int columnIndex) {
        return this.xsqlvars[columnIndex - 1];
    }

    private ExtendedFieldInfo getExtFieldInfo(int columnIndex) throws SQLException {
        if (this.extendedInfo == null) {
            this.extendedInfo = this.getExtendedFieldInfo(this.connection);
        }
        FieldKey key = new FieldKey(this.getXsqlvar((int)columnIndex).relname, this.getXsqlvar((int)columnIndex).sqlname);
        return this.extendedInfo.get(key);
    }

    private int estimatePrecision(int columnIndex) {
        int sqltype = this.getXsqlvar((int)columnIndex).sqltype & 0xFFFFFFFE;
        switch (sqltype) {
            case 500: {
                return 5;
            }
            case 496: {
                return 10;
            }
            case 580: {
                return 19;
            }
            case 480: {
                return 19;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FieldKey, ExtendedFieldInfo> getExtendedFieldInfo(AbstractConnection connection) throws SQLException {
        int maxLength;
        if (connection == null) {
            return Collections.emptyMap();
        }
        HashMap<FieldKey, ExtendedFieldInfo> result = new HashMap<FieldKey, ExtendedFieldInfo>();
        FBDatabaseMetaData metaData = (FBDatabaseMetaData)connection.getMetaData();
        for (int pending = this.xsqlvars.length; pending > 0; pending -= maxLength) {
            StringBuilder sb = new StringBuilder();
            maxLength = pending > 70 ? 70 : pending;
            ArrayList<String> params = new ArrayList<String>(2 * maxLength);
            for (int i = 0; i < maxLength; ++i) {
                String relationName = this.xsqlvars[i].relname;
                String fieldName = this.xsqlvars[i].sqlname;
                if (relationName == null || fieldName == null) continue;
                sb.append(GET_FIELD_INFO);
                params.add(fieldName);
                params.add(relationName);
                if (i >= maxLength - 1) continue;
                sb.append("\n").append("UNION").append("\n");
            }
            ResultSet rs = metaData.doQuery(sb.toString(), params, true);
            try {
                while (rs.next()) {
                    ExtendedFieldInfo fieldInfo = new ExtendedFieldInfo();
                    fieldInfo.relationName = rs.getString("RELATION_NAME");
                    fieldInfo.fieldName = rs.getString("FIELD_NAME");
                    fieldInfo.fieldLength = rs.getInt("FIELD_LENGTH");
                    fieldInfo.fieldPrecision = rs.getInt("FIELD_PRECISION");
                    fieldInfo.fieldScale = rs.getInt("FIELD_SCALE");
                    fieldInfo.fieldSubtype = rs.getInt("FIELD_SUB_TYPE");
                    fieldInfo.characterSetId = rs.getInt("CHARACTER_SET_ID");
                    fieldInfo.characterLength = rs.getInt("CHAR_LEN");
                    if (rs.wasNull()) {
                        fieldInfo.characterLength = fieldInfo.fieldLength / EncodingFactory.getCharacterSetSize(fieldInfo.characterSetId);
                    }
                    result.put(new FieldKey(fieldInfo.relationName, fieldInfo.fieldName), fieldInfo);
                }
                continue;
            }
            finally {
                rs.close();
            }
        }
        return result;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new FBDriverNotCapableException();
        }
        return iface.cast(this);
    }

    private static enum ColumnStrategy {
        DEFAULT{

            @Override
            String getColumnName(XSQLVAR xsqlvar) {
                if (xsqlvar.sqlname == null) {
                    return this.getColumnLabel(xsqlvar);
                }
                return xsqlvar.sqlname;
            }
        }
        ,
        COLUMN_LABEL_FOR_NAME{

            @Override
            String getColumnName(XSQLVAR xsqlvar) {
                return this.getColumnLabel(xsqlvar);
            }
        };


        abstract String getColumnName(XSQLVAR var1);

        String getColumnLabel(XSQLVAR xsqlvar) {
            if (xsqlvar.aliasname != null) {
                return xsqlvar.aliasname;
            }
            if (xsqlvar.sqlname != null) {
                return xsqlvar.sqlname;
            }
            return "";
        }
    }

    private static final class FieldKey {
        private String relationName;
        private String fieldName;

        FieldKey(String relationName, String fieldName) {
            this.relationName = relationName;
            this.fieldName = fieldName;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof FieldKey)) {
                return false;
            }
            FieldKey that = (FieldKey)obj;
            return (this.relationName != null ? this.relationName.equals(that.relationName) : that.relationName == null) && (this.fieldName != null ? this.fieldName.equals(that.fieldName) : that.fieldName == null);
        }

        public int hashCode() {
            int result = 971;
            result = 23 * result + (this.relationName != null ? this.relationName.hashCode() : 0);
            result = 23 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            return result;
        }
    }

    private static class ExtendedFieldInfo {
        String relationName;
        String fieldName;
        int fieldLength;
        int fieldPrecision;
        int fieldScale;
        int fieldSubtype;
        int characterLength;
        int characterSetId;

        private ExtendedFieldInfo() {
        }
    }
}

