/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.firebirdsql.ds.PooledConnectionHandler;
import org.firebirdsql.jdbc.FBSQLException;

public abstract class AbstractPooledConnection
implements PooledConnection {
    private final List connectionEventListeners = Collections.synchronizedList(new LinkedList());
    protected Connection connection;
    protected volatile PooledConnectionHandler handler;
    private static final String[] FATAL_SQL_STATE_CLASSES = new String[]{"08", "XX", "01002", "01S00", "2D000", "2E000", "HY000", "HY001", "HYT00", "HYT01"};

    protected AbstractPooledConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            FBSQLException ex = new FBSQLException("The PooledConnection has been closed", "08003");
            this.fireFatalConnectionError(ex);
            throw ex;
        }
        try {
            if (this.handler != null) {
                this.handler.close();
            }
            this.resetConnection();
        }
        catch (SQLException ex) {
            this.fireFatalConnectionError(ex);
            throw ex;
        }
        this.handler = this.createConnectionHandler();
        return this.handler.getProxy();
    }

    protected void resetConnection() throws SQLException {
        this.connection.setAutoCommit(true);
    }

    protected PooledConnectionHandler createConnectionHandler() {
        return new PooledConnectionHandler(this.connection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        SQLException receivedException = null;
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            catch (SQLException se) {
                receivedException = se;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException se) {
                if (receivedException != null) {
                    se.setNextException(receivedException);
                }
                receivedException = se;
            }
            finally {
                this.connection = null;
            }
        }
        if (receivedException != null) {
            throw receivedException;
        }
    }

    protected void fireFatalConnectionError(SQLException ex) {
        ConnectionEvent evt = new ConnectionEvent(this, ex);
        ArrayList listeners = new ArrayList(this.connectionEventListeners);
        for (ConnectionEventListener listener : listeners) {
            listener.connectionErrorOccurred(evt);
        }
    }

    protected void fireConnectionError(SQLException ex) {
        String sqlState = ex.getSQLState();
        if (this.isFatalState(sqlState)) {
            this.fireFatalConnectionError(ex);
        }
    }

    private boolean isFatalState(String sqlState) {
        if (sqlState == null || sqlState.length() < 2) {
            return true;
        }
        for (int idx = 0; idx < FATAL_SQL_STATE_CLASSES.length; ++idx) {
            if (!sqlState.startsWith(FATAL_SQL_STATE_CLASSES[idx])) continue;
            return true;
        }
        return false;
    }

    protected void fireConnectionClosed() {
        ConnectionEvent evt = new ConnectionEvent(this);
        ArrayList listeners = new ArrayList(this.connectionEventListeners);
        for (ConnectionEventListener listener : listeners) {
            listener.connectionClosed(evt);
        }
    }

    protected synchronized void releaseConnectionHandler(PooledConnectionHandler pch) {
        if (this.handler == pch) {
            this.handler = null;
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }
}

