/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractGeneratedKeysQuery;
import org.firebirdsql.jdbc.AbstractPreparedStatement;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatementFactory;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractDatabaseMetaData
implements FirebirdDatabaseMetaData {
    private static final Logger log = LoggerFactory.getLogger(FBDatabaseMetaData.class, false);
    private static final String SPACES_31 = "                               ";
    private static final String SPACES_15 = "               ";
    private GDSHelper gdsHelper;
    private AbstractConnection connection;
    private final Map<String, AbstractPreparedStatement> statements = new HashMap<String, AbstractPreparedStatement>();
    private static final String fbSQLKeywords = "ACTIVE,ADMIN,AFTER,ASCENDING,AUTO,BASE_NAME,BEFORE,BIGINT,BLOB,BREAK,CACHE,CHECK_POINT_LENGTH,COMPUTED,CONDITIONAL,CONNECTION_ID,CONTAINING,CSTRING,CURRENT_ROLE,DATABASE,DEBUG,DESCENDING,DO,ENTRY_POINT,EXIT,FILE,FILTER,FREE_IT,FUNCTION,GDSCODE,GENERATOR,GEN_ID,GROUP_COMMIT_WAIT_TIME,IF,INACTIVE,INDEX,INPUT_TYPE,LOGFILE,LOG_BUFFER_SIZE,LONG,MANUAL,MAXIMUM_SEGMENT,MERGE,MESSAGE,MODULE_NAME,NULLS,LOCK,NUM_LOG_BUFFERS,OUTPUT_TYPE,OVERFLOW,PAGE,PAGES,PAGE_SIZE,PARAMETER,PASSWORD,PLAN,POST_EVENT,PROTECTED,RAW_PARTITIONS,RDB$DB_KEY,RECORD_VERSION,RECREATE,RESERV,RESERVING,RETAIN,RETURNING_VALUES,RETURNS,ROLE,ROWS_AFFECTED,SAVEPOINT,SEGMENT,SHADOW,SHARED,SINGULAR,SKIP,SNAPSHOT,SORT,STABILITY,STARTING,STARTS,STATISTICS,SUB_TYPE,SUSPEND,TRANSACTION_ID,TRIGGER,VARIABLE,WAIT,WEEKDAY,WHILE,YEARDAY";
    private static final String GET_PROCEDURES_START = "select cast(RDB$PROCEDURE_NAME as varchar(31)) as PROCEDURE_NAME,RDB$DESCRIPTION as REMARKS,RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE from RDB$PROCEDURES where ";
    private static final String GET_PROCEDURES_END = "1 = 1 order by 1";
    private static final String GET_PROCEDURE_COLUMNS_START = "select cast(PP.RDB$PROCEDURE_NAME as varchar(31)) as PROCEDURE_NAME,cast(PP.RDB$PARAMETER_NAME as varchar(31)) as COLUMN_NAME,PP.RDB$PARAMETER_TYPE as COLUMN_TYPE,F.RDB$FIELD_TYPE as FIELD_TYPE,F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,F.RDB$FIELD_PRECISION as FIELD_PRECISION,F.RDB$FIELD_SCALE as FIELD_SCALE,F.RDB$FIELD_LENGTH as FIELD_LENGTH,F.RDB$NULL_FLAG as NULL_FLAG,PP.RDB$DESCRIPTION as REMARKS,F.RDB$CHARACTER_LENGTH AS CHAR_LEN,PP.RDB$PARAMETER_NUMBER + 1 AS PARAMETER_NUMBER from RDB$PROCEDURE_PARAMETERS PP,RDB$FIELDS F where ";
    private static final String GET_PROCEDURE_COLUMNS_END = " PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by PP.RDB$PROCEDURE_NAME,PP.RDB$PARAMETER_TYPE desc,PP.RDB$PARAMETER_NUMBER ";
    public static final String TABLE = "TABLE";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String VIEW = "VIEW";
    public static final String[] ALL_TYPES = new String[]{"TABLE", "SYSTEM TABLE", "VIEW"};
    private static final String TABLE_COLUMNS_FORMAT = " select cast(null as varchar(31)) as TABLE_CAT,cast(null as varchar(31)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(31)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(31)) as TYPE_CAT,cast(null as varchar(31)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(31)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(31)) as OWNER_NAME from RDB$RELATIONS";
    private static final String TABLE_COLUMNS_SYSTEM = String.format(" select cast(null as varchar(31)) as TABLE_CAT,cast(null as varchar(31)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(31)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(31)) as TYPE_CAT,cast(null as varchar(31)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(31)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(31)) as OWNER_NAME from RDB$RELATIONS", "SYSTEM TABLE");
    private static final String TABLE_COLUMNS_NORMAL = String.format(" select cast(null as varchar(31)) as TABLE_CAT,cast(null as varchar(31)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(31)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(31)) as TYPE_CAT,cast(null as varchar(31)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(31)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(31)) as OWNER_NAME from RDB$RELATIONS", "TABLE");
    private static final String TABLE_COLUMNS_VIEW = String.format(" select cast(null as varchar(31)) as TABLE_CAT,cast(null as varchar(31)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(31)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(31)) as TYPE_CAT,cast(null as varchar(31)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(31)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(31)) as OWNER_NAME from RDB$RELATIONS", "VIEW");
    private static final String GET_TABLES_ALL = TABLE_COLUMNS_SYSTEM + " where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null" + " union" + TABLE_COLUMNS_NORMAL + " where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null" + " union" + TABLE_COLUMNS_VIEW + " where ? = 'T' and RDB$VIEW_SOURCE is not null " + " order by 3 ";
    private static final String GET_TABLES_EXACT = TABLE_COLUMNS_SYSTEM + " where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null" + " and ? = RDB$RELATION_NAME" + " union" + TABLE_COLUMNS_NORMAL + " where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null" + " and ? = RDB$RELATION_NAME" + " union" + TABLE_COLUMNS_VIEW + " where ? = 'T' and RDB$VIEW_SOURCE is not null" + " and ? = RDB$RELATION_NAME";
    private static final String GET_TABLES_LIKE = TABLE_COLUMNS_SYSTEM + " where ? = 'T' and RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null" + " and RDB$RELATION_NAME || '" + "                               " + "' like ? escape '\\'" + " union" + TABLE_COLUMNS_NORMAL + " where ? = 'T' and RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null" + " and RDB$RELATION_NAME || '" + "                               " + "' like ? escape '\\'" + " union" + TABLE_COLUMNS_VIEW + " where ? = 'T' and RDB$VIEW_SOURCE is not null" + " and RDB$RELATION_NAME || '" + "                               " + "' like ? escape '\\' " + " order by 3 ";
    private static final String GET_COLUMNS_START = "SELECT cast(RF.RDB$RELATION_NAME as varchar(31)) AS RELATION_NAME,cast(RF.RDB$FIELD_NAME as varchar(31)) AS FIELD_NAME,F.RDB$FIELD_TYPE AS FIELD_TYPE,F.RDB$FIELD_SUB_TYPE AS FIELD_SUB_TYPE,F.RDB$FIELD_PRECISION AS FIELD_PRECISION,F.RDB$FIELD_SCALE AS FIELD_SCALE,F.RDB$FIELD_LENGTH AS FIELD_LENGTH,F.RDB$CHARACTER_LENGTH AS CHAR_LEN,RF.RDB$DESCRIPTION AS REMARKS,RF.RDB$DEFAULT_SOURCE AS DEFAULT_SOURCE,F.RDB$DEFAULT_SOURCE AS DOMAIN_DEFAULT_SOURCE,RF.RDB$FIELD_POSITION + 1 AS FIELD_POSITION,RF.RDB$NULL_FLAG AS NULL_FLAG,F.RDB$NULL_FLAG AS SOURCE_NULL_FLAG,F.RDB$COMPUTED_BLR AS COMPUTED_BLR FROM RDB$RELATION_FIELDS RF,RDB$FIELDS F WHERE ";
    public static final String GET_COLUMNS_END = " RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by RF.RDB$RELATION_NAME, RF.RDB$FIELD_POSITION";
    private static final short smallint_type = 7;
    private static final short integer_type = 8;
    private static final short quad_type = 9;
    private static final short float_type = 10;
    private static final short d_float_type = 11;
    private static final short date_type = 12;
    private static final short time_type = 13;
    private static final short char_type = 14;
    private static final short int64_type = 16;
    private static final short double_type = 27;
    private static final short timestamp_type = 35;
    private static final short varchar_type = 37;
    private static final short blob_type = 261;
    private static final short boolean_type = 23;
    private static final String GET_COLUMN_PRIVILEGES_START = "select cast(RF.RDB$RELATION_NAME as varchar(31)) as TABLE_NAME,cast(RF.RDB$FIELD_NAME as varchar(31)) as COLUMN_NAME,cast(UP.RDB$GRANTOR as varchar(31)) as GRANTOR,cast(UP.RDB$USER as varchar(31)) as GRANTEE,cast(UP.RDB$PRIVILEGE as varchar(6)) as PRIVILEGE,UP.RDB$GRANT_OPTION as IS_GRANTABLE from RDB$RELATION_FIELDS RF,RDB$FIELDS F,RDB$USER_PRIVILEGES UP where RF.RDB$RELATION_NAME = UP.RDB$RELATION_NAME and RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME  and (UP.RDB$FIELD_NAME is null or UP.RDB$FIELD_NAME = RF.RDB$FIELD_NAME) and CAST(UP.RDB$RELATION_NAME AS VARCHAR(40)) = ? and ((";
    private static final String GET_COLUMN_PRIVILEGES_END = " UP.RDB$OBJECT_TYPE = 0) or (RF.RDB$FIELD_NAME is null and UP.RDB$OBJECT_TYPE = 0)) order by 2,5 ";
    private static final String GET_TABLE_PRIVILEGES_START = "select cast(RDB$RELATION_NAME as varchar(31)) as TABLE_NAME,cast(RDB$GRANTOR as varchar(31)) as GRANTOR,cast(RDB$USER as varchar(31)) as GRANTEE,cast(RDB$PRIVILEGE as varchar(6)) as PRIVILEGE,RDB$GRANT_OPTION as IS_GRANTABLE from RDB$USER_PRIVILEGES where ";
    private static final String GET_TABLE_PRIVILEGES_END = " RDB$OBJECT_TYPE = 0 and RDB$FIELD_NAME is null order by 1, 4";
    private static final String GET_BEST_ROW_IDENT = "SELECT CAST(rf.rdb$field_name AS varchar(31)) AS column_name, f.rdb$field_type AS field_type, f.rdb$field_sub_type AS field_sub_type, f.rdb$field_scale AS field_scale, f.rdb$field_precision AS field_precision FROM rdb$relation_constraints rc INNER JOIN rdb$index_segments idx ON idx.rdb$index_name = rc.rdb$index_name INNER JOIN rdb$relation_fields rf ON rf.rdb$field_name = idx.rdb$field_name     AND rf.rdb$relation_name = rc.rdb$relation_name INNER JOIN rdb$fields f ON f.rdb$field_name = rf.rdb$field_source WHERE CAST(rc.rdb$relation_name AS VARCHAR(40)) = ? AND rc.rdb$constraint_type = 'PRIMARY KEY'";
    private static final String GET_PRIMARY_KEYS = "select cast(RC.RDB$RELATION_NAME as varchar(31)) as TABLE_NAME,cast(ISGMT.RDB$FIELD_NAME as varchar(31)) as COLUMN_NAME,CAST((ISGMT.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$CONSTRAINT_NAME as varchar(31)) as PK_NAME from RDB$RELATION_CONSTRAINTS RC INNER JOIN RDB$INDEX_SEGMENTS ISGMT ON RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME where CAST(RC.RDB$RELATION_NAME AS VARCHAR(40)) = ? and RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' order by ISGMT.RDB$FIELD_NAME ";
    private static final String GET_IMPORTED_KEYS = "select cast(PK.RDB$RELATION_NAME as varchar(31)) as PKTABLE_NAME,cast(ISP.RDB$FIELD_NAME as varchar(31)) as PKCOLUMN_NAME,cast(FK.RDB$RELATION_NAME as varchar(31)) as FKTABLE_NAME,cast(ISF.RDB$FIELD_NAME as varchar(31)) as FKCOLUMN_NAME,CAST((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$UPDATE_RULE as varchar(11)) as UPDATE_RULE,cast(RC.RDB$DELETE_RULE as varchar(11)) as DELETE_RULE,cast(PK.RDB$CONSTRAINT_NAME as varchar(31)) as PK_NAME,cast(FK.RDB$CONSTRAINT_NAME as varchar(31)) as FK_NAME from RDB$RELATION_CONSTRAINTS PK,RDB$RELATION_CONSTRAINTS FK,RDB$REF_CONSTRAINTS RC,RDB$INDEX_SEGMENTS ISP,RDB$INDEX_SEGMENTS ISF WHERE CAST(FK.RDB$RELATION_NAME AS VARCHAR(40)) = ? and  FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION order by 1, 5 ";
    private static final String GET_EXPORTED_KEYS = "select cast(PK.RDB$RELATION_NAME as varchar(31)) as PKTABLE_NAME,cast(ISP.RDB$FIELD_NAME as varchar(31)) as PKCOLUMN_NAME,cast(FK.RDB$RELATION_NAME as varchar(31)) as FKTABLE_NAME,cast(ISF.RDB$FIELD_NAME as varchar(31)) as FKCOLUMN_NAME,CAST((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$UPDATE_RULE as varchar(11)) as UPDATE_RULE,cast(RC.RDB$DELETE_RULE as varchar(11)) as DELETE_RULE,cast(PK.RDB$CONSTRAINT_NAME as varchar(31)) as PK_NAME,cast(FK.RDB$CONSTRAINT_NAME as varchar(31)) as FK_NAME from RDB$RELATION_CONSTRAINTS PK,RDB$RELATION_CONSTRAINTS FK,RDB$REF_CONSTRAINTS RC,RDB$INDEX_SEGMENTS ISP,RDB$INDEX_SEGMENTS ISF WHERE CAST(PK.RDB$RELATION_NAME AS VARCHAR(40)) = ? and FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION order by 3, 5 ";
    private static final String GET_CROSS_KEYS = "select cast(PK.RDB$RELATION_NAME as varchar(31)) as PKTABLE_NAME,cast(ISP.RDB$FIELD_NAME as varchar(31)) as PKCOLUMN_NAME,cast(FK.RDB$RELATION_NAME as varchar(31)) as FKTABLE_NAME,cast(ISF.RDB$FIELD_NAME as varchar(31)) as FKCOLUMN_NAME,CAST((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$UPDATE_RULE as varchar(11)) as UPDATE_RULE,cast(RC.RDB$DELETE_RULE as varchar(11)) as DELETE_RULE,cast(PK.RDB$CONSTRAINT_NAME as varchar(31)) as PK_NAME,cast(FK.RDB$CONSTRAINT_NAME as varchar(31)) as FK_NAME from RDB$RELATION_CONSTRAINTS PK,RDB$RELATION_CONSTRAINTS FK,RDB$REF_CONSTRAINTS RC,RDB$INDEX_SEGMENTS ISP,RDB$INDEX_SEGMENTS ISF WHERE CAST(PK.RDB$RELATION_NAME AS VARCHAR(40)) = ? and CAST(FK.RDB$RELATION_NAME AS VARCHAR(40)) = ? and  FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION order by 3, 5 ";
    private static final String GET_INDEX_INFO = "SELECT cast(ind.RDB$RELATION_NAME as varchar(31)) AS TABLE_NAME,ind.RDB$UNIQUE_FLAG AS UNIQUE_FLAG,cast(ind.RDB$INDEX_NAME as varchar(31)) as INDEX_NAME,ise.rdb$field_position + 1 as ORDINAL_POSITION,cast(ise.rdb$field_name as varchar(31)) as COLUMN_NAME,ind.RDB$EXPRESSION_SOURCE as EXPRESSION_SOURCE,ind.RDB$INDEX_TYPE as ASC_OR_DESC FROM rdb$indices ind LEFT JOIN rdb$index_segments ise ON ind.rdb$index_name = ise.rdb$index_name WHERE CAST(ind.rdb$relation_name AS VARCHAR(40)) = ? ORDER BY 2, 3, 4";

    protected AbstractDatabaseMetaData(AbstractConnection c) throws GDSException {
        this.gdsHelper = c.getGDSHelper();
        this.connection = c;
    }

    @Override
    public void close() {
        for (AbstractPreparedStatement stmt : new ArrayList<AbstractPreparedStatement>(this.statements.values())) {
            if (stmt.isClosed()) continue;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.warn("error in DatabaseMetaData.close", e);
            }
        }
        this.statements.clear();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        AbstractGDS gds = (AbstractGDS)this.connection.getInternalAPIHandler();
        return GDSFactory.getJdbcUrl(gds.getType(), this.connection.mc.getDatabase());
    }

    @Override
    public String getUserName() throws SQLException {
        return this.gdsHelper.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.gdsHelper.compareToVersion(2, 0) >= 0;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.gdsHelper.compareToVersion(2, 0) < 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.gdsHelper.getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Jaybird JCA/JDBC driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "2.2";
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 2;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return fbSQLKeywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "SUBSTRING,UCASE,CONCAT";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYOFYEAR,HOUR,MINUTE,MONTH,NOW,SECOND,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "$";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        if (this.gdsHelper.compareToVersion(2, 0) < 0) {
            return 252;
        }
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        if (this.gdsHelper.compareToVersion(1, 5) >= 0) {
            return 65531;
        }
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 65536;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        if (procedureNamePattern == null || procedureNamePattern.equals("")) {
            procedureNamePattern = "%";
        }
        XSQLVAR[] xsqlvars = new XSQLVAR[9];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PROCEDURE_CAT";
        xsqlvars[0].relname = "RDB$PROCEDURES";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PROCEDURE_SCHEM";
        xsqlvars[1].relname = "RDB$PROCEDURES";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PROCEDURE_NAME";
        xsqlvars[2].relname = "RDB$PROCEDURES";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "FUTURE1";
        xsqlvars[3].relname = "RDB$PROCEDURES";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FUTURE2";
        xsqlvars[4].relname = "RDB$PROCEDURES";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FUTURE3";
        xsqlvars[5].relname = "RDB$PROCEDURES";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 80;
        xsqlvars[6].sqlname = "REMARKS";
        xsqlvars[6].relname = "RDB$PROCEDURES";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PROCEDURE_TYPE";
        xsqlvars[7].relname = "RDB$PROCEDURES";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 448;
        xsqlvars[8].sqllen = 31;
        xsqlvars[8].sqlname = "SPECIFIC_NAME";
        xsqlvars[8].relname = "RDB$PROCEDURES";
        Clause procedureClause = new Clause("RDB$PROCEDURE_NAME", procedureNamePattern);
        String sql = GET_PROCEDURES_START;
        sql = sql + procedureClause.getCondition();
        sql = sql + GET_PROCEDURES_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!procedureClause.getCondition().equals("")) {
            params.add(procedureClause.getOriginalCaseValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        if (!rs.next()) {
            params.clear();
            if (!procedureClause.getCondition().equals("")) {
                params.add(procedureClause.getValue());
            }
            if (!(rs = this.doQuery(sql, params)).next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            short procedureType;
            byte[][] row = new byte[9][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PROCEDURE_NAME"));
            row[3] = null;
            row[4] = null;
            row[5] = null;
            String remarks = rs.getString("REMARKS");
            row[6] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[6].sqllen) {
                xsqlvars[6].sqllen = remarks.length();
            }
            row[7] = (procedureType = rs.getShort("PROCEDURE_TYPE")) == 0 ? xsqlvars[0].encodeShort((short)1) : xsqlvars[0].encodeShort((short)2);
            row[8] = row[2];
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        XSQLVAR[] xsqlvars = new XSQLVAR[20];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PROCEDURE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PROCEDURE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PROCEDURE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "COLUMN_TYPE";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 496;
        xsqlvars[5].sqlname = "DATA_TYPE";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "TYPE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 496;
        xsqlvars[7].sqlname = "PRECISION";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 496;
        xsqlvars[8].sqlname = "LENGTH";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "SCALE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "RADIX";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 500;
        xsqlvars[11].sqlname = "NULLABLE";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 80;
        xsqlvars[12].sqlname = "REMARKS";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 448;
        xsqlvars[13].sqllen = 31;
        xsqlvars[13].sqlname = "COLUMN_DEF";
        xsqlvars[13].relname = "COLUMNINFO";
        xsqlvars[14] = new XSQLVAR();
        xsqlvars[14].sqltype = 496;
        xsqlvars[14].sqlname = "SQL_DATA_TYPE";
        xsqlvars[14].relname = "COLUMNINFO";
        xsqlvars[15] = new XSQLVAR();
        xsqlvars[15].sqltype = 496;
        xsqlvars[15].sqlname = "SQL_DATETIME_SUB";
        xsqlvars[15].relname = "COLUMNINFO";
        xsqlvars[16] = new XSQLVAR();
        xsqlvars[16].sqltype = 496;
        xsqlvars[16].sqlname = "CHAR_OCTET_LENGTH";
        xsqlvars[16].relname = "COLUMNINFO";
        xsqlvars[17] = new XSQLVAR();
        xsqlvars[17].sqltype = 496;
        xsqlvars[17].sqlname = "ORDINAL_POSITION";
        xsqlvars[17].relname = "COLUMNINFO";
        xsqlvars[18] = new XSQLVAR();
        xsqlvars[18].sqltype = 448;
        xsqlvars[18].sqllen = 3;
        xsqlvars[18].sqlname = "IS_NULLABLE";
        xsqlvars[18].relname = "COLUMNINFO";
        xsqlvars[19] = new XSQLVAR();
        xsqlvars[19].sqltype = 448;
        xsqlvars[19].sqllen = 31;
        xsqlvars[19].sqlname = "SPECIFIC_NAME";
        xsqlvars[19].relname = "COLUMNINFO";
        Clause procedureClause = new Clause("PP.RDB$PROCEDURE_NAME", procedureNamePattern);
        Clause columnClause = new Clause("PP.RDB$PARAMETER_NAME", columnNamePattern);
        String sql = GET_PROCEDURE_COLUMNS_START;
        sql = sql + procedureClause.getCondition();
        sql = sql + columnClause.getCondition();
        sql = sql + GET_PROCEDURE_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!procedureClause.getCondition().equals("")) {
            params.add(procedureClause.getOriginalCaseValue());
        }
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getOriginalCaseValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        if (!rs.next()) {
            params.clear();
            if (!procedureClause.getCondition().equals("")) {
                params.add(procedureClause.getValue());
            }
            if (!columnClause.getCondition().equals("")) {
                params.add(columnClause.getValue());
            }
            if (!(rs = this.doQuery(sql, params)).next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            byte[][] row = new byte[20][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PROCEDURE_NAME"));
            row[3] = this.getBytes(rs.getString("COLUMN_NAME"));
            short columnType = rs.getShort("COLUMN_TYPE");
            row[4] = columnType == 0 ? xsqlvars[0].encodeShort((short)1) : xsqlvars[0].encodeShort((short)4);
            short fieldType = rs.getShort("FIELD_TYPE");
            short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
            short fieldScale = rs.getShort("FIELD_SCALE");
            int dataType = AbstractDatabaseMetaData.getDataType(fieldType, fieldSubType, fieldScale);
            row[5] = xsqlvars[0].encodeInt(dataType);
            row[6] = this.getBytes(AbstractDatabaseMetaData.getDataTypeName(fieldType, fieldSubType, fieldScale));
            row[8] = xsqlvars[0].encodeInt(rs.getShort("FIELD_LENGTH"));
            row[7] = null;
            row[9] = null;
            row[10] = xsqlvars[0].encodeShort((short)10);
            row[16] = null;
            switch (dataType) {
                case 2: 
                case 3: {
                    row[7] = xsqlvars[0].encodeInt(rs.getShort("FIELD_PRECISION"));
                    row[9] = xsqlvars[0].encodeShort((short)(fieldScale * -1));
                    break;
                }
                case 1: 
                case 12: {
                    short charLen = rs.getShort("CHAR_LEN");
                    row[7] = !rs.wasNull() ? xsqlvars[0].encodeInt(charLen) : row[8];
                    row[16] = row[8];
                    break;
                }
                case 6: {
                    row[7] = xsqlvars[0].encodeInt(7);
                    break;
                }
                case 8: {
                    row[7] = xsqlvars[0].encodeInt(15);
                    break;
                }
                case -5: {
                    row[7] = xsqlvars[0].encodeInt(19);
                    row[9] = xsqlvars[0].encodeShort((short)0);
                    break;
                }
                case 4: {
                    row[7] = xsqlvars[0].encodeInt(10);
                    row[9] = xsqlvars[0].encodeShort((short)0);
                    break;
                }
                case 5: {
                    row[7] = xsqlvars[0].encodeInt(5);
                    row[9] = xsqlvars[0].encodeShort((short)0);
                    break;
                }
                case 91: {
                    row[7] = xsqlvars[0].encodeInt(10);
                    break;
                }
                case 92: {
                    row[7] = xsqlvars[0].encodeInt(8);
                    break;
                }
                case 93: {
                    row[7] = xsqlvars[0].encodeInt(19);
                    break;
                }
                case 16: {
                    row[7] = xsqlvars[0].encodeInt(1);
                    row[10] = xsqlvars[0].encodeShort((short)2);
                }
                default: {
                    row[7] = null;
                }
            }
            short nullFlag = rs.getShort("NULL_FLAG");
            row[11] = nullFlag == 1 ? xsqlvars[0].encodeShort((short)0) : xsqlvars[0].encodeShort((short)1);
            String remarks = rs.getString("REMARKS");
            row[12] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[12].sqllen) {
                xsqlvars[12].sqllen = remarks.length();
            }
            row[13] = null;
            row[14] = null;
            row[15] = null;
            row[17] = xsqlvars[0].encodeInt(rs.getInt("PARAMETER_NUMBER"));
            row[18] = nullFlag == 1 ? this.getBytes("NO") : this.getBytes("YES");
            row[19] = row[2];
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String sql;
        if (tableNamePattern == null || "".equals(tableNamePattern)) {
            tableNamePattern = "%";
        }
        this.checkCatalogAndSchema(catalog, schemaPattern);
        if (types == null) {
            types = ALL_TYPES;
        }
        ArrayList<String> params = new ArrayList<String>();
        if (this.isAllCondition(tableNamePattern)) {
            sql = GET_TABLES_ALL;
            params.add(this.getWantsSystemTables(types));
            params.add(this.getWantsTables(types));
            params.add(this.getWantsViews(types));
        } else if (this.hasNoWildcards(tableNamePattern)) {
            tableNamePattern = this.stripQuotes(this.stripEscape(tableNamePattern), true);
            sql = GET_TABLES_EXACT;
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        } else {
            tableNamePattern = this.stripQuotes(tableNamePattern, true) + SPACES_15 + "%";
            sql = GET_TABLES_LIKE;
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        }
        return this.doQuery(sql, params);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "TABLECATALOGS";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[]{new XSQLVAR()};
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_TYPE";
        xsqlvars[0].relname = "TABLETYPES";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>(ALL_TYPES.length);
        for (int i = 0; i < ALL_TYPES.length; ++i) {
            rows.add(new byte[][]{this.getBytes(ALL_TYPES[i])});
        }
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schemaPattern);
        XSQLVAR[] xsqlvars = new XSQLVAR[24];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "DATA_TYPE";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 449;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "TYPE_NAME";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 496;
        xsqlvars[6].sqlname = "COLUMN_SIZE";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 496;
        xsqlvars[7].sqlname = "BUFFER_LENGTH";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 496;
        xsqlvars[8].sqlname = "DECIMAL_DIGITS";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 496;
        xsqlvars[9].sqlname = "NUM_PREC_RADIX";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 496;
        xsqlvars[10].sqlname = "NULLABLE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 449;
        xsqlvars[11].sqllen = 80;
        xsqlvars[11].sqlname = "REMARKS";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 449;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "COLUMN_DEF";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 496;
        xsqlvars[13].sqlname = "SQL_DATA_TYPE";
        xsqlvars[13].relname = "COLUMNINFO";
        xsqlvars[14] = new XSQLVAR();
        xsqlvars[14].sqltype = 496;
        xsqlvars[14].sqlname = "SQL_DATETIME_SUB";
        xsqlvars[14].relname = "COLUMNINFO";
        xsqlvars[15] = new XSQLVAR();
        xsqlvars[15].sqltype = 496;
        xsqlvars[15].sqlname = "CHAR_OCTET_LENGTH";
        xsqlvars[15].relname = "COLUMNINFO";
        xsqlvars[16] = new XSQLVAR();
        xsqlvars[16].sqltype = 496;
        xsqlvars[16].sqlname = "ORDINAL_POSITION";
        xsqlvars[16].relname = "COLUMNINFO";
        xsqlvars[17] = new XSQLVAR();
        xsqlvars[17].sqltype = 448;
        xsqlvars[17].sqllen = 3;
        xsqlvars[17].sqlname = "IS_NULLABLE";
        xsqlvars[17].relname = "COLUMNINFO";
        xsqlvars[18] = new XSQLVAR();
        xsqlvars[18].sqltype = 448;
        xsqlvars[18].sqllen = 31;
        xsqlvars[18].sqlname = this.getJDBCMajorVersion() > 4 || this.getJDBCMajorVersion() == 4 && this.getJDBCMinorVersion() >= 1 ? "SCOPE_CATALOG" : "SCOPE_CATLOG";
        xsqlvars[18].relname = "COLUMNINFO";
        xsqlvars[19] = new XSQLVAR();
        xsqlvars[19].sqltype = 448;
        xsqlvars[19].sqllen = 31;
        xsqlvars[19].sqlname = "SCOPE_SCHEMA";
        xsqlvars[19].relname = "COLUMNINFO";
        xsqlvars[20] = new XSQLVAR();
        xsqlvars[20].sqltype = 448;
        xsqlvars[20].sqllen = 31;
        xsqlvars[20].sqlname = "SCOPE_TABLE";
        xsqlvars[20].relname = "COLUMNINFO";
        xsqlvars[21] = new XSQLVAR();
        xsqlvars[21].sqltype = 500;
        xsqlvars[21].sqlname = "SOURCE_DATA_TYPE";
        xsqlvars[21].relname = "COLUMNINFO";
        xsqlvars[22] = new XSQLVAR();
        xsqlvars[22].sqltype = 448;
        xsqlvars[22].sqllen = 3;
        xsqlvars[22].sqlname = "IS_AUTOINCREMENT";
        xsqlvars[22].relname = "COLUMNINFO";
        xsqlvars[23] = new XSQLVAR();
        xsqlvars[23].sqltype = 448;
        xsqlvars[23].sqllen = 3;
        xsqlvars[23].sqlname = "IS_GENERATEDCOLUMN";
        xsqlvars[23].relname = "COLUMNINFO";
        Clause tableClause = new Clause("RF.RDB$RELATION_NAME", tableNamePattern);
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMNS_START;
        sql = sql + tableClause.getCondition();
        sql = sql + columnClause.getCondition();
        sql = sql + GET_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getOriginalCaseValue());
        }
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getOriginalCaseValue());
        }
        ResultSet rs = this.doQuery(sql, params);
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        if (!rs.next()) {
            params.clear();
            if (!tableClause.getCondition().equals("")) {
                params.add(tableClause.getValue());
            }
            if (!columnClause.getCondition().equals("")) {
                params.add(columnClause.getValue());
            }
            if (!(rs = this.doQuery(sql, params)).next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            String column_def;
            byte[][] row = new byte[24][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("RELATION_NAME"));
            row[3] = this.getBytes(rs.getString("FIELD_NAME"));
            short fieldType = rs.getShort("FIELD_TYPE");
            short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
            short fieldScale = rs.getShort("FIELD_SCALE");
            int dataType = AbstractDatabaseMetaData.getDataType(fieldType, fieldSubType, fieldScale);
            row[4] = xsqlvars[0].encodeInt(dataType);
            row[5] = this.getBytes(AbstractDatabaseMetaData.getDataTypeName(fieldType, fieldSubType, fieldScale));
            row[7] = null;
            row[8] = null;
            row[9] = xsqlvars[0].encodeInt(10);
            row[15] = null;
            switch (dataType) {
                case 2: 
                case 3: {
                    row[6] = xsqlvars[0].encodeInt(rs.getShort("FIELD_PRECISION"));
                    row[8] = xsqlvars[0].encodeInt(fieldScale * -1);
                    break;
                }
                case 1: 
                case 12: {
                    row[15] = xsqlvars[0].encodeInt(rs.getShort("FIELD_LENGTH"));
                    short charLen = rs.getShort("CHAR_LEN");
                    if (!rs.wasNull()) {
                        row[6] = xsqlvars[0].encodeInt(charLen);
                        break;
                    }
                    row[6] = row[15];
                    break;
                }
                case 6: {
                    row[6] = xsqlvars[0].encodeInt(7);
                    break;
                }
                case 8: {
                    row[6] = xsqlvars[0].encodeInt(15);
                    break;
                }
                case -5: {
                    row[6] = xsqlvars[0].encodeInt(19);
                    row[8] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 4: {
                    row[6] = xsqlvars[0].encodeInt(10);
                    row[8] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 5: {
                    row[6] = xsqlvars[0].encodeInt(5);
                    row[8] = xsqlvars[0].encodeInt(0);
                    break;
                }
                case 91: {
                    row[6] = xsqlvars[0].encodeInt(10);
                    break;
                }
                case 92: {
                    row[6] = xsqlvars[0].encodeInt(8);
                    break;
                }
                case 93: {
                    row[6] = xsqlvars[0].encodeInt(19);
                    break;
                }
                case 16: {
                    row[6] = xsqlvars[0].encodeInt(1);
                    row[9] = xsqlvars[0].encodeInt(2);
                    break;
                }
                default: {
                    row[6] = null;
                }
            }
            short nullFlag = rs.getShort("NULL_FLAG");
            short sourceNullFlag = rs.getShort("SOURCE_NULL_FLAG");
            row[10] = nullFlag == 1 || sourceNullFlag == 1 ? xsqlvars[0].encodeInt(0) : xsqlvars[0].encodeInt(1);
            String remarks = rs.getString("REMARKS");
            row[11] = this.getBytes(remarks);
            if (remarks != null && remarks.length() > xsqlvars[11].sqllen) {
                xsqlvars[11].sqllen = remarks.length();
            }
            if ((column_def = rs.getString("DEFAULT_SOURCE")) == null) {
                column_def = rs.getString("DOMAIN_DEFAULT_SOURCE");
            }
            if (column_def != null) {
                int defaultPos = column_def.toUpperCase().indexOf("DEFAULT");
                if (defaultPos >= 0) {
                    column_def = column_def.substring(7).trim();
                }
                row[12] = this.getBytes(column_def);
            } else {
                row[12] = null;
            }
            row[13] = null;
            row[14] = null;
            row[16] = xsqlvars[0].encodeInt(rs.getInt("FIELD_POSITION"));
            row[17] = nullFlag == 1 || sourceNullFlag == 1 ? this.getBytes("NO") : this.getBytes("YES");
            row[18] = null;
            row[19] = null;
            row[20] = null;
            row[21] = null;
            switch (dataType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    row[22] = this.getBytes("");
                    break;
                }
                case 2: 
                case 3: {
                    if (fieldScale == 0) {
                        row[22] = this.getBytes("");
                        break;
                    }
                    row[22] = this.getBytes("NO");
                    break;
                }
                default: {
                    row[22] = this.getBytes("NO");
                }
            }
            rs.getString("COMPUTED_BLR");
            row[23] = this.getBytes(rs.wasNull() ? "NO" : "YES");
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    private static int getDataType(short fieldType, short fieldSubType, short fieldScale) {
        switch (fieldType) {
            case 7: {
                if (fieldSubType == 1 || fieldSubType == 0 && fieldScale < 0) {
                    return 2;
                }
                if (fieldSubType == 2) {
                    return 3;
                }
                return 5;
            }
            case 8: {
                if (fieldSubType == 1 || fieldSubType == 0 && fieldScale < 0) {
                    return 2;
                }
                if (fieldSubType == 2) {
                    return 3;
                }
                return 4;
            }
            case 11: 
            case 27: {
                if (fieldSubType == 1 || fieldSubType == 0 && fieldScale < 0) {
                    return 2;
                }
                if (fieldSubType == 2) {
                    return 3;
                }
                return 8;
            }
            case 10: {
                return 6;
            }
            case 14: {
                return 1;
            }
            case 37: {
                return 12;
            }
            case 35: {
                return 93;
            }
            case 13: {
                return 92;
            }
            case 12: {
                return 91;
            }
            case 16: {
                if (fieldSubType == 1 || fieldSubType == 0 && fieldScale < 0) {
                    return 2;
                }
                if (fieldSubType == 2) {
                    return 3;
                }
                return -5;
            }
            case 261: {
                if (fieldSubType < 0) {
                    return 2004;
                }
                if (fieldSubType == 0) {
                    return -4;
                }
                if (fieldSubType == 1) {
                    return -1;
                }
                return 1111;
            }
            case 9: {
                return 1111;
            }
            case 23: {
                return 16;
            }
        }
        return 0;
    }

    private static String getDataTypeName(short sqltype, short sqlsubtype, short sqlscale) {
        switch (sqltype) {
            case 7: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "SMALLINT";
            }
            case 8: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "INTEGER";
            }
            case 11: 
            case 27: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "DOUBLE PRECISION";
            }
            case 10: {
                return "FLOAT";
            }
            case 14: {
                return "CHAR";
            }
            case 37: {
                return "VARCHAR";
            }
            case 35: {
                return "TIMESTAMP";
            }
            case 13: {
                return "TIME";
            }
            case 12: {
                return "DATE";
            }
            case 16: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "BIGINT";
            }
            case 261: {
                if (sqlsubtype < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (sqlsubtype == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (sqlsubtype == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE " + sqlsubtype;
            }
            case 9: {
                return "ARRAY";
            }
            case 23: {
                return "BOOLEAN";
            }
        }
        return "NULL";
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNPRIV";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNPRIV";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNPRIV";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNPRIV";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "GRANTOR";
        xsqlvars[4].relname = "COLUMNPRIV";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "GRANTEE";
        xsqlvars[5].relname = "COLUMNPRIV";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "PRIVILEGE";
        xsqlvars[6].relname = "COLUMNPRIV";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "IS_GRANTABLE";
        xsqlvars[7].relname = "COLUMNPRIV";
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMN_PRIVILEGES_START;
        sql = sql + columnClause.getCondition();
        sql = sql + GET_COLUMN_PRIVILEGES_END;
        ArrayList<String> params = new ArrayList<String>();
        table = this.stripQuotes(this.stripEscape(table), false);
        params.add(table);
        if (!columnClause.getCondition().equals("")) {
            params.add(columnClause.getOriginalCaseValue());
        }
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        ResultSet rs = this.doQuery(sql, params);
        if (!rs.next()) {
            params.clear();
            if (!columnClause.getCondition().equals("")) {
                params.add(this.stripQuotes(this.stripEscape(table), true));
                params.add(columnClause.getValue());
            }
            if (!(rs = this.doQuery(sql, params)).next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            byte[][] row = new byte[8][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("TABLE_NAME"));
            row[3] = this.getBytes(rs.getString("COLUMN_NAME"));
            row[4] = this.getBytes(rs.getString("GRANTOR"));
            row[5] = this.getBytes(rs.getString("GRANTEE"));
            String privilege = rs.getString("PRIVILEGE");
            if (privilege.equals("A")) {
                row[6] = this.getBytes("ALL");
            } else if (privilege.equals("S")) {
                row[6] = this.getBytes("SELECT");
            } else if (privilege.equals("D")) {
                row[6] = this.getBytes("DELETE");
            } else if (privilege.equals("I")) {
                row[6] = this.getBytes("INSERT");
            } else if (privilege.equals("U")) {
                row[6] = this.getBytes("UPDATE");
            } else if (privilege.equals("R")) {
                row[6] = this.getBytes("REFERENCE");
            } else if (privilege.equals("M")) {
                row[6] = this.getBytes("MEMBEROF");
            }
            short isGrantable = rs.getShort("IS_GRANTABLE");
            row[7] = isGrantable == 0 ? this.getBytes("NO") : this.getBytes("YES");
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet rs;
        this.checkCatalogAndSchema(catalog, schemaPattern);
        tableNamePattern = this.stripQuotes(this.stripEscape(tableNamePattern), true);
        XSQLVAR[] xsqlvars = this.buildTablePrivilegeRSMetaData();
        Clause tableClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
        String sql = GET_TABLE_PRIVILEGES_START;
        sql = sql + tableClause.getCondition();
        sql = sql + GET_TABLE_PRIVILEGES_END;
        ArrayList<String> params = new ArrayList<String>();
        if (!tableClause.getCondition().equals("")) {
            params.add(tableClause.getOriginalCaseValue());
        }
        if (!(rs = this.doQuery(sql, params)).next()) {
            params.clear();
            if (!tableClause.getCondition().equals("")) {
                params.add(tableClause.getValue());
            }
            if (!(rs = this.doQuery(sql, params)).next()) {
                return new FBResultSet(xsqlvars, new ArrayList());
            }
        }
        return this.processTablePrivileges(xsqlvars, rs);
    }

    protected final XSQLVAR[] buildTablePrivilegeRSMetaData() {
        XSQLVAR[] xsqlvars = new XSQLVAR[7];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "TABLEPRIV";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "TABLEPRIV";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "TABLEPRIV";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "GRANTOR";
        xsqlvars[3].relname = "TABLEPRIV";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "GRANTEE";
        xsqlvars[4].relname = "TABLEPRIV";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "PRIVILEGE";
        xsqlvars[5].relname = "TABLEPRIV";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "IS_GRANTABLE";
        xsqlvars[6].relname = "TABLEPRIV";
        return xsqlvars;
    }

    protected final FBResultSet processTablePrivileges(XSQLVAR[] xsqlvars, ResultSet fbTablePrivileges) throws SQLException {
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        do {
            byte[][] row = new byte[7][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(fbTablePrivileges.getString("TABLE_NAME"));
            row[3] = this.getBytes(fbTablePrivileges.getString("GRANTOR"));
            row[4] = this.getBytes(fbTablePrivileges.getString("GRANTEE"));
            String privilege = fbTablePrivileges.getString("PRIVILEGE");
            if (privilege.equals("A")) {
                row[5] = this.getBytes("ALL");
            } else if (privilege.equals("S")) {
                row[5] = this.getBytes("SELECT");
            } else if (privilege.equals("D")) {
                row[5] = this.getBytes("DELETE");
            } else if (privilege.equals("I")) {
                row[5] = this.getBytes("INSERT");
            } else if (privilege.equals("U")) {
                row[5] = this.getBytes("UPDATE");
            } else if (privilege.equals("R")) {
                row[5] = this.getBytes("REFERENCE");
            } else if (privilege.equals("M")) {
                row[5] = this.getBytes("MEMBEROF");
            }
            short isGrantable = fbTablePrivileges.getShort("IS_GRANTABLE");
            row[6] = isGrantable == 0 ? this.getBytes("NO") : this.getBytes("YES");
            rows.add(row);
        } while (fbTablePrivileges.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 500;
        xsqlvars[0].sqlname = "SCOPE";
        xsqlvars[0].relname = "ROWIDENTIFIER";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "COLUMN_NAME";
        xsqlvars[1].relname = "ROWIDENTIFIER";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 500;
        xsqlvars[2].sqlname = "DATA_TYPE";
        xsqlvars[2].relname = "ROWIDENTIFIER";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "TYPE_NAME";
        xsqlvars[3].relname = "ROWIDENTIFIER";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "COLUMN_SIZE";
        xsqlvars[4].relname = "ROWIDENTIFIER";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 496;
        xsqlvars[5].sqlname = "BUFFER_LENGTH";
        xsqlvars[5].relname = "ROWIDENTIFIER";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "DECIMAL_DIGITS";
        xsqlvars[6].relname = "ROWIDENTIFIER";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PSEUDO_COLUMN";
        xsqlvars[7].relname = "ROWIDENTIFIER";
        String quoteLikeTable = table != null ? table.replaceAll("([_%])", "\\\\$1") : null;
        ResultSet tables = this.getTables(catalog, schema, quoteLikeTable, null);
        if (!tables.next()) {
            return new FBResultSet(xsqlvars, new ArrayList());
        }
        ArrayList rows = this.getPrimaryKeyIdentifier(tables.getString(3), scope, xsqlvars);
        if (rows.size() == 0) {
            byte[][] row = new byte[][]{xsqlvars[0].encodeShort((short)scope), this.getBytes("RDB$DB_KEY"), xsqlvars[0].encodeShort((short)AbstractDatabaseMetaData.getDataType((short)14, (short)0, (short)0)), this.getBytes(AbstractDatabaseMetaData.getDataTypeName((short)14, (short)0, (short)0)), xsqlvars[0].encodeInt(0), null, xsqlvars[0].encodeShort((short)0), xsqlvars[0].encodeShort((short)2)};
            rows.add(row);
        }
        return new FBResultSet(xsqlvars, rows);
    }

    private ArrayList getPrimaryKeyIdentifier(String table, int scope, XSQLVAR[] xsqlvars) throws SQLException {
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>(0);
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(table);
        ResultSet rs = this.doQuery(GET_BEST_ROW_IDENT, params);
        while (rs.next()) {
            byte[][] row = new byte[][]{xsqlvars[0].encodeShort((short)scope), this.getBytes(rs.getString("COLUMN_NAME")), xsqlvars[0].encodeShort((short)AbstractDatabaseMetaData.getDataType(rs.getShort("FIELD_TYPE"), rs.getShort("FIELD_SUB_TYPE"), rs.getShort("FIELD_SCALE"))), this.getBytes(AbstractDatabaseMetaData.getDataTypeName(rs.getShort("FIELD_TYPE"), rs.getShort("FIELD_SUB_TYPE"), rs.getShort("FIELD_SCALE"))), xsqlvars[0].encodeInt(rs.getInt("FIELD_PRECISION")), null, xsqlvars[0].encodeShort(rs.getShort("FIELD_SCALE")), xsqlvars[0].encodeShort((short)1)};
            rows.add(row);
        }
        return rows;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[8];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 500;
        xsqlvars[0].sqlname = "SCOPE";
        xsqlvars[0].relname = "VERSIONCOL";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "COLUMN_NAME";
        xsqlvars[1].relname = "VERSIONCOL";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 500;
        xsqlvars[2].sqlname = "DATA_TYPE";
        xsqlvars[2].relname = "VERSIONCOL";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "TYPE_NAME";
        xsqlvars[3].relname = "VERSIONCOL";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "COLUMN_SIZE";
        xsqlvars[4].relname = "VERSIONCOL";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 496;
        xsqlvars[5].sqlname = "BUFFER_LENGTH";
        xsqlvars[5].relname = "VERSIONCOL";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "DECIMAL_DIGITS";
        xsqlvars[6].relname = "VERSIONCOL";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "PSEUDO_COLUMN";
        xsqlvars[7].relname = "VERSIONCOL";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        XSQLVAR[] xsqlvars = new XSQLVAR[6];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "COLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 500;
        xsqlvars[4].sqlname = "KEY_SEQ";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "PK_NAME";
        xsqlvars[5].relname = "COLUMNINFO";
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.stripQuotes(this.stripEscape(table), false));
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        ResultSet rs = this.doQuery(GET_PRIMARY_KEYS, params);
        if (!rs.next()) {
            params.clear();
            params.add(this.stripQuotes(this.stripEscape(table), true));
            rs = this.doQuery(GET_PRIMARY_KEYS, params);
            if (!rs.next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            byte[][] row = new byte[][]{null, null, this.getBytes(rs.getString("TABLE_NAME")), this.getBytes(rs.getString("COLUMN_NAME")), xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ")), this.getBytes(rs.getString("PK_NAME"))};
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        String sql = GET_IMPORTED_KEYS;
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.stripQuotes(this.stripEscape(table), false));
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        ResultSet rs = this.doQuery(sql, params);
        if (!rs.next()) {
            params.clear();
            params.add(this.stripQuotes(this.stripEscape(table), true));
            rs = this.doQuery(sql, params);
            if (!rs.next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME"));
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME"));
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME"));
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME"));
            row[8] = xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = xsqlvars[0].encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = xsqlvars[0].encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = xsqlvars[0].encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = xsqlvars[0].encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = xsqlvars[0].encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = xsqlvars[0].encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = xsqlvars[0].encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = xsqlvars[0].encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = xsqlvars[0].encodeShort((short)7);
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        String sql = GET_EXPORTED_KEYS;
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.stripQuotes(this.stripEscape(table), false));
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        ResultSet rs = this.doQuery(sql, params);
        if (!rs.next()) {
            params.clear();
            params.add(this.stripQuotes(this.stripEscape(table), true));
            rs = this.doQuery(sql, params);
            if (!rs.next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME"));
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME"));
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME"));
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME"));
            row[8] = xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = xsqlvars[0].encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = xsqlvars[0].encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = xsqlvars[0].encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = xsqlvars[0].encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = xsqlvars[0].encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = xsqlvars[0].encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = xsqlvars[0].encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = xsqlvars[0].encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = xsqlvars[0].encodeShort((short)7);
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.checkCatalogAndSchema(primaryCatalog, primarySchema);
        this.checkCatalogAndSchema(foreignCatalog, foreignSchema);
        XSQLVAR[] xsqlvars = new XSQLVAR[14];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "PKTABLE_CAT";
        xsqlvars[0].relname = "COLUMNINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "PKTABLE_SCHEM";
        xsqlvars[1].relname = "COLUMNINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "PKTABLE_NAME";
        xsqlvars[2].relname = "COLUMNINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "PKCOLUMN_NAME";
        xsqlvars[3].relname = "COLUMNINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "FKTABLE_CAT";
        xsqlvars[4].relname = "COLUMNINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "FKTABLE_SCHEM";
        xsqlvars[5].relname = "COLUMNINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 448;
        xsqlvars[6].sqllen = 31;
        xsqlvars[6].sqlname = "FKTABLE_NAME";
        xsqlvars[6].relname = "COLUMNINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 448;
        xsqlvars[7].sqllen = 31;
        xsqlvars[7].sqlname = "FKCOLUMN_NAME";
        xsqlvars[7].relname = "COLUMNINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "KEY_SEQ";
        xsqlvars[8].relname = "COLUMNINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 500;
        xsqlvars[9].sqlname = "UPDATE_RULE";
        xsqlvars[9].relname = "COLUMNINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 500;
        xsqlvars[10].sqlname = "DELETE_RULE";
        xsqlvars[10].relname = "COLUMNINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 448;
        xsqlvars[11].sqllen = 31;
        xsqlvars[11].sqlname = "FK_NAME";
        xsqlvars[11].relname = "COLUMNINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "PK_NAME";
        xsqlvars[12].relname = "COLUMNINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "DEFERRABILITY";
        xsqlvars[13].relname = "COLUMNINFO";
        String sql = GET_CROSS_KEYS;
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.stripQuotes(this.stripEscape(primaryTable), false));
        params.add(this.stripQuotes(this.stripEscape(foreignTable), false));
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        ResultSet rs = this.doQuery(sql, params);
        if (!rs.next()) {
            params.clear();
            params.add(this.stripQuotes(this.stripEscape(primaryTable), true));
            params.add(this.stripQuotes(this.stripEscape(foreignTable), true));
            rs = this.doQuery(sql, params);
            if (!rs.next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("PKTABLE_NAME"));
            row[3] = this.getBytes(rs.getString("PKCOLUMN_NAME"));
            row[4] = null;
            row[5] = null;
            row[6] = this.getBytes(rs.getString("FKTABLE_NAME"));
            row[7] = this.getBytes(rs.getString("FKCOLUMN_NAME"));
            row[8] = xsqlvars[0].encodeShort(rs.getShort("KEY_SEQ"));
            String updateRule = rs.getString("UPDATE_RULE");
            if (updateRule.equals("NO ACTION") || updateRule.equals("RESTRICT")) {
                row[9] = xsqlvars[0].encodeShort((short)3);
            } else if (updateRule.equals("CASCADE")) {
                row[9] = xsqlvars[0].encodeShort((short)0);
            } else if (updateRule.equals("SET NULL")) {
                row[9] = xsqlvars[0].encodeShort((short)2);
            } else if (updateRule.equals("SET DEFAULT")) {
                row[9] = xsqlvars[0].encodeShort((short)4);
            }
            String deleteRule = rs.getString("DELETE_RULE");
            if (deleteRule.equals("NO ACTION") || deleteRule.equals("RESTRICT")) {
                row[10] = xsqlvars[0].encodeShort((short)3);
            } else if (deleteRule.equals("CASCADE")) {
                row[10] = xsqlvars[0].encodeShort((short)0);
            } else if (deleteRule.equals("SET NULL")) {
                row[10] = xsqlvars[0].encodeShort((short)2);
            } else if (deleteRule.equals("SET DEFAULT")) {
                row[10] = xsqlvars[0].encodeShort((short)4);
            }
            row[11] = this.getBytes(rs.getString("FK_NAME"));
            row[12] = this.getBytes(rs.getString("PK_NAME"));
            row[13] = xsqlvars[0].encodeShort((short)7);
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    private byte[] createShort(int value) throws SQLException {
        if (value > Short.MAX_VALUE) {
            throw new FBSQLException("Cannot convert integer to short.", "HY009");
        }
        return new XSQLVAR().encodeShort((short)value);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        XSQLVAR anXSQLVAR = new XSQLVAR();
        byte[] shortZero = anXSQLVAR.encodeShort((short)0);
        byte[] CASESENSITIVE = this.getBytes("T");
        byte[] CASEINSENSITIVE = this.getBytes("F");
        byte[] UNSIGNED = this.getBytes("T");
        byte[] SIGNED = this.getBytes("F");
        byte[] FIXEDSCALE = this.getBytes("T");
        byte[] VARIABLESCALE = this.getBytes("F");
        byte[] NOTAUTOINC = this.getBytes("F");
        byte[] BINARY = anXSQLVAR.encodeInt(2);
        byte[] RADIX_TEN = anXSQLVAR.encodeInt(10);
        byte[] PREDNONE = anXSQLVAR.encodeShort((short)0);
        byte[] PREDBASIC = anXSQLVAR.encodeShort((short)2);
        byte[] SEARCHABLE = anXSQLVAR.encodeShort((short)3);
        byte[] NULLABLE = anXSQLVAR.encodeShort((short)1);
        XSQLVAR[] xsqlvars = new XSQLVAR[18];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_NAME";
        xsqlvars[0].relname = "TYPEINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 500;
        xsqlvars[1].sqlname = "DATA_TYPE";
        xsqlvars[1].relname = "TYPEINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 496;
        xsqlvars[2].sqlname = "PRECISION";
        xsqlvars[2].relname = "TYPEINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 1;
        xsqlvars[3].sqlname = "LITERAL_PREFIX";
        xsqlvars[3].relname = "TYPEINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 1;
        xsqlvars[4].sqlname = "LITERAL_SUFFIX";
        xsqlvars[4].relname = "TYPEINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "CREATE_PARAMS";
        xsqlvars[5].relname = "TYPEINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "NULLABLE";
        xsqlvars[6].relname = "TYPEINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 452;
        xsqlvars[7].sqllen = 1;
        xsqlvars[7].sqlname = "CASE_SENSITIVE";
        xsqlvars[7].relname = "TYPEINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 500;
        xsqlvars[8].sqlname = "SEARCHABLE";
        xsqlvars[8].relname = "TYPEINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 452;
        xsqlvars[9].sqllen = 1;
        xsqlvars[9].sqlname = "UNSIGNED_ATTRIBUTE";
        xsqlvars[9].relname = "TYPEINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 452;
        xsqlvars[10].sqllen = 1;
        xsqlvars[10].sqlname = "FIXED_PREC_SCALE";
        xsqlvars[10].relname = "TYPEINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 452;
        xsqlvars[11].sqllen = 1;
        xsqlvars[11].sqlname = "AUTO_INCREMENT";
        xsqlvars[11].relname = "TYPEINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "LOCAL_TYPE_NAME";
        xsqlvars[12].relname = "TYPEINFO";
        xsqlvars[13] = new XSQLVAR();
        xsqlvars[13].sqltype = 500;
        xsqlvars[13].sqlname = "MINIMUM_SCALE";
        xsqlvars[13].relname = "TYPEINFO";
        xsqlvars[14] = new XSQLVAR();
        xsqlvars[14].sqltype = 500;
        xsqlvars[14].sqlname = "MAXIMUM_SCALE";
        xsqlvars[14].relname = "TYPEINFO";
        xsqlvars[15] = new XSQLVAR();
        xsqlvars[15].sqltype = 496;
        xsqlvars[15].sqlname = "SQL_DATA_TYPE";
        xsqlvars[15].relname = "TYPEINFO";
        xsqlvars[16] = new XSQLVAR();
        xsqlvars[16].sqltype = 496;
        xsqlvars[16].sqlname = "SQL_DATETIME_SUB";
        xsqlvars[16].relname = "TYPEINFO";
        xsqlvars[17] = new XSQLVAR();
        xsqlvars[17].sqltype = 496;
        xsqlvars[17].sqlname = "NUM_PREC_RADIX";
        xsqlvars[17].relname = "TYPEINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        rows.add(new byte[][]{this.getBytes("BIGINT"), this.createShort(-5), anXSQLVAR.encodeInt(19), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(580), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE 0"), this.createShort(-4), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(520), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE 1"), this.createShort(-1), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(520), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("CHAR"), this.createShort(1), anXSQLVAR.encodeInt(Short.MAX_VALUE), this.getBytes("'"), this.getBytes("'"), this.getBytes("length"), NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(452), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("NUMERIC"), this.createShort(2), anXSQLVAR.encodeInt(18), null, null, this.getBytes("precision,scale"), NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, this.createShort(18), anXSQLVAR.encodeInt(580), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("DECIMAL"), this.createShort(3), anXSQLVAR.encodeInt(18), null, null, this.getBytes("precision,scale"), NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, this.createShort(18), anXSQLVAR.encodeInt(580), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("INTEGER"), this.createShort(4), anXSQLVAR.encodeInt(10), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(496), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("SMALLINT"), this.createShort(5), anXSQLVAR.encodeInt(5), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(500), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("FLOAT"), this.createShort(6), anXSQLVAR.encodeInt(7), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, this.createShort(0), this.createShort(7), anXSQLVAR.encodeInt(482), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("DOUBLE PRECISION"), this.createShort(8), anXSQLVAR.encodeInt(15), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, this.createShort(0), this.createShort(15), anXSQLVAR.encodeInt(480), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("VARCHAR"), this.createShort(12), anXSQLVAR.encodeInt(32765), this.getBytes("'"), this.getBytes("'"), this.getBytes("length"), NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(448), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("DATE"), this.createShort(91), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(570), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("TIME"), this.createShort(92), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(560), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("TIMESTAMP"), this.createShort(93), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(510), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("ARRAY"), this.createShort(1111), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(540), null, RADIX_TEN});
        rows.add(new byte[][]{this.getBytes("BLOB SUB_TYPE <0 "), this.createShort(2004), anXSQLVAR.encodeInt(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(520), null, RADIX_TEN});
        if (this.getDatabaseMajorVersion() >= 3) {
            rows.add(new byte[][]{this.getBytes("BOOLEAN"), this.createShort(16), anXSQLVAR.encodeInt(1), null, null, null, NULLABLE, CASEINSENSITIVE, PREDBASIC, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, shortZero, shortZero, anXSQLVAR.encodeInt(32764), null, BINARY});
        }
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkCatalogAndSchema(catalog, schema);
        XSQLVAR[] xsqlvars = new XSQLVAR[13];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "INDEXINFO";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "INDEXINFO";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "INDEXINFO";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 452;
        xsqlvars[3].sqllen = 1;
        xsqlvars[3].sqlname = "NON_UNIQUE";
        xsqlvars[3].relname = "INDEXINFO";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "INDEX_QUALIFIER";
        xsqlvars[4].relname = "INDEXINFO";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "INDEX_NAME";
        xsqlvars[5].relname = "INDEXINFO";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "TYPE";
        xsqlvars[6].relname = "INDEXINFO";
        xsqlvars[7] = new XSQLVAR();
        xsqlvars[7].sqltype = 500;
        xsqlvars[7].sqlname = "ORDINAL_POSITION";
        xsqlvars[7].relname = "INDEXINFO";
        xsqlvars[8] = new XSQLVAR();
        xsqlvars[8].sqltype = 448;
        xsqlvars[8].sqllen = 31;
        xsqlvars[8].sqlname = "COLUMN_NAME";
        xsqlvars[8].relname = "INDEXINFO";
        xsqlvars[9] = new XSQLVAR();
        xsqlvars[9].sqltype = 448;
        xsqlvars[9].sqllen = 31;
        xsqlvars[9].sqlname = "ASC_OR_DESC";
        xsqlvars[9].relname = "INDEXINFO";
        xsqlvars[10] = new XSQLVAR();
        xsqlvars[10].sqltype = 496;
        xsqlvars[10].sqlname = "CARDINALITY";
        xsqlvars[10].relname = "INDEXINFO";
        xsqlvars[11] = new XSQLVAR();
        xsqlvars[11].sqltype = 496;
        xsqlvars[11].sqlname = "PAGES";
        xsqlvars[11].relname = "INDEXINFO";
        xsqlvars[12] = new XSQLVAR();
        xsqlvars[12].sqltype = 448;
        xsqlvars[12].sqllen = 31;
        xsqlvars[12].sqlname = "FILTER_CONDITION";
        xsqlvars[12].relname = "INDEXINFO";
        ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.stripQuotes(this.stripEscape(table), false));
        ResultSet rs = this.doQuery(GET_INDEX_INFO, params);
        if (!rs.next()) {
            params.set(0, this.stripQuotes(this.stripEscape(table), true));
            rs = this.doQuery(GET_INDEX_INFO, params);
            if (!rs.next()) {
                return new FBResultSet(xsqlvars, rows);
            }
        }
        do {
            boolean isNotUnique;
            byte[][] row = new byte[13][];
            row[0] = null;
            row[1] = null;
            row[2] = this.getBytes(rs.getString("TABLE_NAME"));
            boolean bl = isNotUnique = rs.getInt("UNIQUE_FLAG") == 0;
            if (unique && isNotUnique) continue;
            row[3] = this.getBytes(isNotUnique ? "T" : "F");
            row[4] = null;
            row[5] = this.getBytes(rs.getString("INDEX_NAME"));
            row[6] = xsqlvars[0].encodeShort((short)3);
            String columnName = rs.getString("COLUMN_NAME");
            if (rs.wasNull()) {
                row[7] = xsqlvars[0].encodeShort((short)1);
                String expressionSource = rs.getString("EXPRESSION_SOURCE");
                if (expressionSource != null) {
                    row[8] = this.getBytes(expressionSource);
                    if (expressionSource.length() > xsqlvars[8].sqllen) {
                        xsqlvars[8].sqllen = expressionSource.length();
                    }
                } else {
                    row[8] = null;
                }
            } else {
                row[7] = xsqlvars[0].encodeShort(rs.getShort("ORDINAL_POSITION"));
                row[8] = this.getBytes(columnName);
            }
            int ascOrDesc = rs.getInt("ASC_OR_DESC");
            row[9] = ascOrDesc == 0 ? this.getBytes("A") : (byte[])(ascOrDesc == 1 ? this.getBytes("D") : null);
            row[10] = null;
            row[11] = null;
            row[12] = null;
            rows.add(row);
        } while (rs.next());
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return concurrency == 1007 || concurrency == 1008;
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[7];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_CAT";
        xsqlvars[0].relname = "UDT";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TYPE_SCHEM";
        xsqlvars[1].relname = "UDT";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TYPE_NAME";
        xsqlvars[2].relname = "UDT";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "CLASS_NAME";
        xsqlvars[3].relname = "UDT";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 496;
        xsqlvars[4].sqlname = "DATA_TYPE";
        xsqlvars[4].relname = "UDT";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "REMARKS";
        xsqlvars[5].relname = "UDT";
        xsqlvars[6] = new XSQLVAR();
        xsqlvars[6].sqltype = 500;
        xsqlvars[6].sqlname = "BASE_TYPE";
        xsqlvars[6].relname = "UDT";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getAttributes(String param1, String param2, String param3, String param4) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.gdsHelper.compareToVersion(1, 5) >= 0;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return AbstractGeneratedKeysQuery.isGeneratedKeysSupportLoaded() && this.gdsHelper.compareToVersion(2, 0) >= 0;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[6];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TYPE_CAT";
        xsqlvars[0].relname = "SUPERTYPES";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TYPE_SCHEM";
        xsqlvars[1].relname = "SUPERTYPES";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TYPE_NAME";
        xsqlvars[2].relname = "SUPERTYPES";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "SUPERTYPE_CAT";
        xsqlvars[3].relname = "SUPERTYPES";
        xsqlvars[4] = new XSQLVAR();
        xsqlvars[4].sqltype = 448;
        xsqlvars[4].sqllen = 31;
        xsqlvars[4].sqlname = "SUPERTYPE_SCHEM";
        xsqlvars[4].relname = "SUPERTYPES";
        xsqlvars[5] = new XSQLVAR();
        xsqlvars[5].sqltype = 448;
        xsqlvars[5].sqllen = 31;
        xsqlvars[5].sqlname = "SUPERTYPE_NAME";
        xsqlvars[5].relname = "SUPERTYPES";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[4];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_CAT";
        xsqlvars[0].relname = "SUPERTABLES";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_SCHEM";
        xsqlvars[1].relname = "SUPERTABLES";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "TABLE_NAME";
        xsqlvars[2].relname = "SUPERTABLES";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "SUPERTABLE_NAME";
        xsqlvars[3].relname = "SUPERTABLES";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2 || holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductMinorVersion();
    }

    @Override
    public int getOdsMajorVersion() throws SQLException {
        return this.gdsHelper.getIscDBHandle().getODSMajorVersion();
    }

    @Override
    public int getOdsMinorVersion() throws SQLException {
        return this.gdsHelper.getIscDBHandle().getODSMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[4];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "NAME";
        xsqlvars[0].relname = "UDT";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 496;
        xsqlvars[1].sqllen = 4;
        xsqlvars[1].sqlname = "MAX_LEN";
        xsqlvars[1].relname = "UDT";
        xsqlvars[2] = new XSQLVAR();
        xsqlvars[2].sqltype = 448;
        xsqlvars[2].sqllen = 31;
        xsqlvars[2].sqlname = "DEFAULT";
        xsqlvars[2].relname = "UDT";
        xsqlvars[3] = new XSQLVAR();
        xsqlvars[3].sqltype = 448;
        xsqlvars[3].sqllen = 31;
        xsqlvars[3].sqlname = "DESCRIPTION";
        xsqlvars[3].relname = "UDT";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        XSQLVAR[] xsqlvars = new XSQLVAR[2];
        xsqlvars[0] = new XSQLVAR();
        xsqlvars[0].sqltype = 448;
        xsqlvars[0].sqllen = 31;
        xsqlvars[0].sqlname = "TABLE_SCHEM";
        xsqlvars[0].relname = "TABLESCHEMAS";
        xsqlvars[1] = new XSQLVAR();
        xsqlvars[1].sqltype = 448;
        xsqlvars[1].sqllen = 31;
        xsqlvars[1].sqlname = "TABLE_CATALOG";
        xsqlvars[1].relname = "TABLESCHEMAS";
        ArrayList rows = new ArrayList(0);
        return new FBResultSet(xsqlvars, rows);
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        return arg0 != null && arg0.isAssignableFrom(FBDatabaseMetaData.class);
    }

    public Object unwrap(Class arg0) throws SQLException {
        if (!this.isWrapperFor(arg0)) {
            throw new FBSQLException("No compatible class found.");
        }
        return this;
    }

    public boolean isAllCondition(String pattern) {
        return "%".equals(pattern);
    }

    public boolean hasNoWildcards(String pattern) {
        int pos;
        if (pattern == null) {
            return true;
        }
        int scannedTo = 0;
        while ((pos = pattern.indexOf(37, scannedTo)) < pattern.length() && pos != -1) {
            if (pos == 0 || pattern.charAt(pos - 1) != '\\') {
                return false;
            }
            scannedTo = ++pos;
        }
        scannedTo = 0;
        while ((pos = pattern.indexOf(95, scannedTo)) < pattern.length() && pos != -1) {
            if (pos == 0 || pattern.charAt(pos - 1) != '\\') {
                return false;
            }
            scannedTo = ++pos;
        }
        return true;
    }

    public String stripEscape(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuffer stripped = new StringBuffer(pattern.length());
        for (int pos = 0; pos < pattern.length(); ++pos) {
            if (pattern.charAt(pos) == '\\') continue;
            stripped.append(pattern.charAt(pos));
        }
        return stripped.toString();
    }

    protected String getWantsSystemTables(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!SYSTEM_TABLE.equals(types[i])) continue;
            return "T";
        }
        return "F";
    }

    protected String getWantsTables(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!TABLE.equals(types[i])) continue;
            return "T";
        }
        return "F";
    }

    protected String getWantsViews(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!VIEW.equals(types[i])) continue;
            return "T";
        }
        return "F";
    }

    public String stripQuotes(String pattern, boolean uppercase) {
        if (pattern == null) {
            return null;
        }
        if (pattern.length() >= 2 && pattern.charAt(0) == '\"' && pattern.charAt(pattern.length() - 1) == '\"') {
            return pattern.substring(1, pattern.length() - 1);
        }
        if (uppercase) {
            return pattern.toUpperCase();
        }
        return pattern;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public String getProcedureSourceCode(String procedureName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$PROCEDURE_SOURCE From RDB$PROCEDURES Where RDB$PROCEDURE_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(procedureName);
        ResultSet rs = this.doQuery(sql, params);
        if (rs.next()) {
            sResult = rs.getString(1);
        }
        rs.close();
        return sResult;
    }

    @Override
    public String getTriggerSourceCode(String triggerName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$TRIGGER_SOURCE From RDB$TRIGGERS Where RDB$TRIGGER_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(triggerName);
        ResultSet rs = this.doQuery(sql, params);
        if (rs.next()) {
            sResult = rs.getString(1);
        }
        rs.close();
        return sResult;
    }

    @Override
    public String getViewSourceCode(String viewName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$VIEW_SOURCE From RDB$RELATIONS Where RDB$RELATION_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(viewName);
        ResultSet rs = this.doQuery(sql, params);
        if (rs.next()) {
            sResult = rs.getString(1);
        }
        rs.close();
        return sResult;
    }

    protected void checkCatalogAndSchema(String catalog, String schema) throws SQLException {
    }

    protected byte[] getBytes(String value) {
        if (value != null) {
            return value.getBytes();
        }
        return null;
    }

    private AbstractPreparedStatement getStatement(String sql, boolean standalone) throws SQLException {
        AbstractPreparedStatement s = this.statements.get(sql);
        if (s != null && s.isClosed()) {
            this.statements.remove(sql);
            s = null;
        }
        if (s != null) {
            return s;
        }
        InternalTransactionCoordinator.MetaDataTransactionCoordinator metaDataTransactionCoordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.connection.txCoordinator);
        s = FBStatementFactory.createPreparedStatement(this.gdsHelper, sql, 1004, 1007, 2, metaDataTransactionCoordinator, metaDataTransactionCoordinator, true, standalone, false);
        if (!standalone) {
            this.statements.put(sql, s);
        }
        return s;
    }

    public ResultSet doQuery(String sql, List params) throws SQLException {
        return this.doQuery(sql, params, false);
    }

    public ResultSet doQuery(String sql, List params, boolean standalone) throws SQLException {
        AbstractPreparedStatement s = this.getStatement(sql, standalone);
        for (int i = 0; i < params.size(); ++i) {
            s.setStringForced(i + 1, (String)params.get(i));
        }
        return s.executeMetaDataQuery();
    }

    protected class Clause {
        private String condition = "";
        private String value;
        private String originalCaseValue;

        public Clause(String columnName, String pattern) {
            if (pattern != null && !AbstractDatabaseMetaData.this.isAllCondition(pattern)) {
                if (AbstractDatabaseMetaData.this.hasNoWildcards(pattern)) {
                    this.value = AbstractDatabaseMetaData.this.stripQuotes(AbstractDatabaseMetaData.this.stripEscape(pattern), true);
                    this.originalCaseValue = AbstractDatabaseMetaData.this.stripQuotes(AbstractDatabaseMetaData.this.stripEscape(pattern), false);
                    this.condition = "CAST(" + columnName + " AS VARCHAR(40)) = ? and ";
                } else {
                    this.value = AbstractDatabaseMetaData.this.stripQuotes(pattern, true) + AbstractDatabaseMetaData.SPACES_15 + "%";
                    this.originalCaseValue = AbstractDatabaseMetaData.this.stripQuotes(pattern, false) + AbstractDatabaseMetaData.SPACES_15 + "%";
                    this.condition = columnName + " || '" + AbstractDatabaseMetaData.SPACES_31 + "' like ? escape '\\' and ";
                }
            }
        }

        public String getCondition() {
            return this.condition;
        }

        public String getValue() {
            return this.value;
        }

        public String getOriginalCaseValue() {
            return this.originalCaseValue;
        }
    }
}

