/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.Synchronizable;

public class FBCachedBlob
implements FirebirdBlob,
Synchronizable {
    private static final byte[] BYTES_NULL_VALUE = null;
    private static final InputStream STREAM_NULL_VALUE = null;
    private final Object syncObject = new Object();
    private byte[] blobData;

    @Override
    public FirebirdBlob detach() throws SQLException {
        return this;
    }

    @Override
    public boolean isSegmented() throws SQLException {
        return false;
    }

    public FBCachedBlob(byte[] data) {
        this.blobData = data;
    }

    @Override
    public long length() throws SQLException {
        if (this.blobData == null) {
            return -1L;
        }
        return this.blobData.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.blobData == null) {
            return BYTES_NULL_VALUE;
        }
        byte[] result = new byte[length];
        System.arraycopy(this.blobData, (int)pos - 1, result, 0, length);
        return result;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.blobData == null) {
            return STREAM_NULL_VALUE;
        }
        return new ByteArrayInputStream(this.blobData);
    }

    @Override
    public int setBytes(long l, byte[] abyte0) throws SQLException {
        throw new FBSQLException("Blob in auto-commit mode is read-only.");
    }

    @Override
    public int setBytes(long l, byte[] abyte0, int i, int j) throws SQLException {
        throw new FBSQLException("Blob in auto-commit mode is read-only.");
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new FBSQLException("Blob in auto-commit mode is read-only.");
    }

    @Override
    public void truncate(long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public final Object getSynchronizationObject() {
        return this.syncObject;
    }

    @Override
    public void free() throws SQLException {
        this.blobData = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }
}

