/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBLongField
extends FBField {
    FBLongField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Long value = new Long(this.field.decodeLong(this.getFieldData()));
        if (value > 127L || value < -128L) {
            throw (SQLException)FBLongField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    @Override
    public short getShort() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Long value = new Long(this.field.decodeLong(this.getFieldData()));
        if (value > 32767L || value < -32768L) {
            throw (SQLException)FBLongField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    @Override
    public int getInt() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Long value = new Long(this.field.decodeLong(this.getFieldData()));
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw (SQLException)FBLongField.createException(INT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        if (this.getFieldData() == null) {
            return 0L;
        }
        return this.field.decodeLong(this.getFieldData());
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0f;
        }
        return this.field.decodeLong(this.getFieldData());
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0;
        }
        return this.field.decodeLong(this.getFieldData());
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.getFieldData() == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return BigDecimal.valueOf(this.field.decodeLong(this.getFieldData()));
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.getFieldData() == null) {
            return false;
        }
        return this.field.decodeLong(this.getFieldData()) == 1L;
    }

    @Override
    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeLong(this.getFieldData()));
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setLong(Long.parseLong(value));
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBLongField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setLong(value ? 1L : 0L);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        if (value > 9.223372E18f || value < -9.223372E18f) {
            throw (SQLException)FBLongField.createException(FLOAT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setLong((long)value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            throw (SQLException)FBLongField.createException(DOUBLE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setLong((long)value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setFieldData(this.field.encodeLong(value));
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (value.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 || value.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
            throw (SQLException)FBLongField.createException(BIGDECIMAL_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setLong(value.longValue());
    }
}

