/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.ISCConstants;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBConnectionHelper {
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_BOOLEAN = 1;
    private static final int TYPE_BYTE = 2;
    private static final int TYPE_INT = 3;
    private static final int TYPE_STRING = 4;
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String DPB_PREFIX = "isc_dpb_";
    public static final String TPB_PREFIX = "isc_tpb_";
    public static final String TPB_MAPPING_PROPERTY = "tpb_mapping";
    public static final String ISC_DPB_TYPES_RESOURCE = "isc_dpb_types.properties";
    private static final HashMap dpbTypes = new HashMap();
    private static final HashMap dpbParameterTypes = new HashMap();
    private static final HashMap tpbTypes = new HashMap();

    public static Integer getDpbKey(String name) {
        return (Integer)dpbTypes.get(name);
    }

    public static Map getDpbMap() {
        return Collections.unmodifiableMap(dpbTypes);
    }

    public static Object parseDpbString(String name, Object value) {
        if (value instanceof Boolean || value instanceof Byte || value instanceof Integer) {
            return value;
        }
        if (value != null && !(value instanceof String)) {
            throw new ClassCastException(value.getClass().getName());
        }
        Integer type = (Integer)dpbParameterTypes.get(name);
        if (type == null) {
            type = new Integer(0);
        }
        switch (type) {
            case 1: {
                return "".equals(value) ? Boolean.TRUE : Boolean.valueOf((String)value);
            }
            case 2: {
                return new Byte((String)value);
            }
            case 3: {
                return new Integer((String)value);
            }
            case 4: {
                return value;
            }
        }
        if (value == null || "".equals(value)) {
            return Boolean.TRUE;
        }
        try {
            int intValue = Integer.parseInt((String)value);
            if (intValue < 256) {
                return new Byte((byte)intValue);
            }
            return new Integer(intValue);
        }
        catch (NumberFormatException nfex) {
            return value;
        }
    }

    public static void processTpbMapping(GDS gds, FirebirdConnectionProperties connectionProperties, Properties info) throws FBResourceException {
        if (info.containsKey(TRANSACTION_SERIALIZABLE)) {
            connectionProperties.setTransactionParameters(8, FBTpbMapper.processMapping(gds, info.getProperty(TRANSACTION_SERIALIZABLE)));
        }
        if (info.containsKey(TRANSACTION_REPEATABLE_READ)) {
            connectionProperties.setTransactionParameters(4, FBTpbMapper.processMapping(gds, info.getProperty(TRANSACTION_REPEATABLE_READ)));
        }
        if (info.containsKey(TRANSACTION_READ_COMMITTED)) {
            connectionProperties.setTransactionParameters(2, FBTpbMapper.processMapping(gds, info.getProperty(TRANSACTION_READ_COMMITTED)));
        }
    }

    public static Integer getTpbParam(String name) {
        return (Integer)tpbTypes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String resource) throws IOException {
        ClassLoader cl = FBConnectionHelper.class.getClassLoader();
        InputStream in = null;
        in = cl == null ? ClassLoader.getSystemResourceAsStream(resource) : cl.getResourceAsStream(resource);
        if (in == null) {
            return null;
        }
        try {
            Properties props = new Properties();
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            in.close();
        }
    }

    private static void loadDpbParameterTypes() {
        Properties props;
        try {
            props = FBConnectionHelper.loadProperties(ISC_DPB_TYPES_RESOURCE);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String shortKey = key.substring(DPB_PREFIX.length());
            String value = (String)entry.getValue();
            int hashIndex = value.indexOf(35);
            if (hashIndex != -1) {
                value = value.substring(0, hashIndex).trim();
            }
            if ("boolean".equals(value)) {
                dpbParameterTypes.put(key, new Integer(1));
                dpbParameterTypes.put(shortKey, new Integer(1));
                continue;
            }
            if ("byte".equals(value)) {
                dpbParameterTypes.put(key, new Integer(2));
                dpbParameterTypes.put(shortKey, new Integer(2));
                continue;
            }
            if ("int".equals(value)) {
                dpbParameterTypes.put(key, new Integer(3));
                dpbParameterTypes.put(shortKey, new Integer(3));
                continue;
            }
            if (!"string".equals(value)) continue;
            dpbParameterTypes.put(key, new Integer(4));
            dpbParameterTypes.put(shortKey, new Integer(4));
        }
    }

    static {
        Class<ISCConstants> iscClass = ISCConstants.class;
        Field[] fields = iscClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Integer value;
            if (!fields[i].getType().getName().equals("int")) continue;
            String name = fields[i].getName();
            try {
                value = (Integer)fields[i].get(null);
            }
            catch (IllegalAccessException iaex) {
                continue;
            }
            if (name.startsWith(DPB_PREFIX)) {
                dpbTypes.put(name.substring(DPB_PREFIX.length()), value);
                dpbTypes.put(name, value);
                continue;
            }
            if (!name.startsWith(TPB_PREFIX)) continue;
            tpbTypes.put(name.substring(TPB_PREFIX.length()), value);
            tpbTypes.put(name, value);
        }
        FBConnectionHelper.loadDpbParameterTypes();
    }
}

