/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.oo;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.oo.OODatabaseMetaData;
import org.firebirdsql.jdbc.oo.OOPreparedStatement;
import org.firebirdsql.jdbc.oo.OOStatement;

public class OOConnection
extends FBConnection {
    private OODatabaseMetaData metaData;

    public OOConnection(FBManagedConnection mc) {
        super(mc);
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (this.metaData == null) {
                this.metaData = new OODatabaseMetaData(this);
            }
            return this.metaData;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            OOStatement stmt = new OOStatement(this.getGDSHelper(), resultSetType, resultSetConcurrency, resultSetHoldability, this.txCoordinator);
            this.activeStatements.add(stmt);
            return stmt;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean metaData, boolean generatedKeys) throws SQLException {
        try {
            FBObjectListener.StatementListener coordinator = this.txCoordinator;
            if (metaData) {
                coordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.txCoordinator);
            }
            InternalTransactionCoordinator blobCoordinator = metaData ? null : this.txCoordinator;
            OOPreparedStatement stmt = new OOPreparedStatement(this.getGDSHelper(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, coordinator, blobCoordinator, metaData, false, generatedKeys);
            this.activeStatements.add(stmt);
            return stmt;
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }
}

