/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.ResourceException;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FirebirdLocalTransaction;
import org.firebirdsql.jdbc.AbstractGeneratedKeysQuery;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBCallableStatement;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverConsistencyCheckException;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSavepoint;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.StoredProcedureMetaData;
import org.firebirdsql.jdbc.StoredProcedureMetaDataFactory;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.jdbc.escape.FBEscapedParser;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBConnection
implements FirebirdConnection,
Synchronizable {
    private static final Logger log = LoggerFactory.getLogger(FBConnection.class);
    private static final String GET_CLIENT_INFO_SQL = "SELECT     rdb$get_context('USER_SESSION', ?) session_context   , rdb$get_context('USER_TRANSACTION', ?) tx_context FROM rdb$database";
    private static final String SET_CLIENT_INFO_SQL = "SELECT   rdb$set_context('USER_SESSION', ?, ?) session_context FROM rdb$database";
    protected FBManagedConnection mc;
    private FBLocalTransaction localTransaction;
    private FBDatabaseMetaData metaData;
    protected final InternalTransactionCoordinator txCoordinator;
    private SQLWarning firstWarning;
    protected final Set<Statement> activeStatements = Collections.synchronizedSet(new HashSet());
    private int resultSetHoldability = 2;
    private StoredProcedureMetaData storedProcedureMetaData;
    private FBEscapedParser escapedParser;
    private Set<String> clientInfoPropNames = new HashSet<String>();
    private final AtomicInteger savepointCounter = new AtomicInteger();
    private final List<FBSavepoint> savepoints = new ArrayList<FBSavepoint>();

    public FBConnection(FBManagedConnection mc) {
        this.mc = mc;
        this.txCoordinator = new InternalTransactionCoordinator(this);
        FBConnectionRequestInfo cri = mc.getConnectionRequestInfo();
        this.resultSetHoldability = cri.hasArgument(138) ? 1 : 2;
    }

    public FBObjectListener.StatementListener getStatementListener() {
        return this.txCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldability() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            return this.resultSetHoldability;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldability(int holdability) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            this.resultSetHoldability = holdability;
        }
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("This connection is closed and cannot be used now.", "08003");
        }
    }

    void notifyStatementClosed(FBStatement stmt) {
        if (!this.activeStatements.remove(stmt)) {
            if (stmt instanceof FBPreparedStatement && ((FBPreparedStatement)stmt).isParamSet == null) {
                return;
            }
            log.warn("Specified statement was not created by this connection: " + stmt);
        }
    }

    protected void freeStatements() throws SQLException {
        ArrayList<Statement> statements = new ArrayList<Statement>(this.activeStatements);
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        for (Statement stmt : statements) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagedConnection(FBManagedConnection mc) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.mc != mc && this.metaData != null) {
                try {
                    this.metaData.close();
                }
                finally {
                    this.metaData = null;
                }
            }
            this.mc = mc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FBManagedConnection getManagedConnection() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.mc;
        }
    }

    @Override
    public FbDatabase getFbDatabase() throws SQLException {
        return this.getGDSHelper().getCurrentDatabase();
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() {
        return this.mc != null ? this.mc.getConnectionRequestInfo().getDpb() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setTransactionParameters(int isolationLevel, int[] parameters) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            TransactionParameterBuffer tpbParams = this.createTransactionParameterBuffer();
            for (int parameter : parameters) {
                tpbParams.addArgument(parameter);
            }
            this.setTransactionParameters(isolationLevel, tpbParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolationLevel) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            return this.mc.getTransactionParameters(isolationLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionParameterBuffer createTransactionParameterBuffer() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            return this.getFbDatabase().createTransactionParameterBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionParameters(int isolationLevel, TransactionParameterBuffer tpb) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (this.mc.isManagedEnvironment()) {
                throw new FBSQLException("Cannot set transaction parameters in managed environment.");
            }
            this.mc.setTransactionParameters(isolationLevel, tpb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionParameters(TransactionParameterBuffer tpb) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            try {
                if (this.getLocalTransaction().inTransaction()) {
                    throw new FBSQLException("Cannot set transaction parameters when transaction is already started.");
                }
                this.mc.setTransactionParameters(tpb);
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            return new FBBlob(this.getGDSHelper(), this.txCoordinator);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        FBBlob blob = (FBBlob)this.createBlob();
        return new FBClob(blob);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type STRUCT not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String sql) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            return this.getEscapedParser().parse(sql);
        }
    }

    protected FBEscapedParser getEscapedParser() {
        if (this.escapedParser == null) {
            DatabaseParameterBuffer dpb = this.getDatabaseParameterBuffer();
            FBEscapedParser.EscapeParserMode mode = dpb.hasArgument(134) ? FBEscapedParser.EscapeParserMode.USE_STANDARD_UDF : FBEscapedParser.EscapeParserMode.USE_BUILT_IN;
            this.escapedParser = new FBEscapedParser(mode);
        }
        return this.escapedParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (this.getAutoCommit() == autoCommit) {
                return;
            }
            this.txCoordinator.switchTransactionCoordinator(autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransactionCoordinator(boolean managedConnection, boolean autoCommit) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            this.txCoordinator.setTransactionCoordinator(managedConnection, autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagedEnvironment(boolean managedConnection) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.setTransactionCoordinator(managedConnection, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.isClosed()) {
                throw new FBSQLException("You cannot getAutoCommit on an unassociated closed connection.");
            }
            return this.txCoordinator.getAutoCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.isClosed()) {
                throw new FBSQLException("You cannot commit a closed connection.", "08003");
            }
            if (this.mc.inDistributedTransaction()) {
                throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
            }
            this.txCoordinator.commit();
            this.invalidateTransactionLifetimeObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.isClosed()) {
                throw new FBSQLException("You cannot rollback closed connection.", "08003");
            }
            if (this.mc.inDistributedTransaction()) {
                throw new FBSQLException("Connection enlisted in distributed transaction", "25000");
            }
            this.txCoordinator.rollback();
            this.invalidateTransactionLifetimeObjects();
        }
    }

    protected void invalidateTransactionLifetimeObjects() {
        this.invalidateSavepoints();
        this.storedProcedureMetaData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws SQLException {
        SQLExceptionChainBuilder<SQLException> chainBuilder;
        block43: {
            block44: {
                chainBuilder = new SQLExceptionChainBuilder<SQLException>();
                Object object = this.getSynchronizationObject();
                // MONITORENTER : object
                if (log.isTraceEnabled()) {
                    log.trace("Connection closed requested at", new RuntimeException("Connection close logging"));
                }
                this.freeStatements();
                if (this.metaData != null) {
                    this.metaData.close();
                }
                this.metaData = null;
                if (this.mc == null) break block43;
                if (this.mc.inDistributedTransaction()) break block44;
                try {
                    this.txCoordinator.handleConnectionClose();
                }
                catch (SQLException e) {
                    chainBuilder.append(e);
                }
                finally {
                    block45: {
                        try {
                            this.setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            if ("08003".equals(e.getSQLState())) break block45;
                            chainBuilder.append(e);
                        }
                    }
                }
            }
            this.mc.close(this);
            this.mc = null;
            break block43;
            catch (SQLException e) {
                chainBuilder.append(e);
                break block43;
            }
            finally {
                this.metaData = null;
                if (this.mc != null) {
                    if (!this.mc.inDistributedTransaction()) {
                        try {
                            this.txCoordinator.handleConnectionClose();
                        }
                        catch (SQLException e) {
                            chainBuilder.append(e);
                        }
                        finally {
                            block47: {
                                try {
                                    this.setAutoCommit(true);
                                }
                                catch (SQLException e) {
                                    if ("08003".equals(e.getSQLState())) break block47;
                                    chainBuilder.append(e);
                                }
                            }
                        }
                    }
                    this.mc.close(this);
                    this.mc = null;
                }
            }
        }
        // MONITOREXIT : object
        if (!chainBuilder.hasException()) return;
        throw chainBuilder.getException();
    }

    @Override
    public boolean isClosed() {
        return this.mc == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout should be >= 0", "HY009");
        }
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.isClosed()) {
                return false;
            }
            if (timeout != 0) {
                this.addWarning(new SQLWarning(String.format("Connection.isValid does not support non-zero timeouts, timeout value %d has been ignored", timeout)));
            }
            try {
                this.getFbDatabase().getDatabaseInfo(new byte[]{32, 1}, 10);
                return true;
            }
            catch (SQLException ex) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (this.metaData == null) {
                this.metaData = new FBDatabaseMetaData(this);
            }
            return this.metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            try {
                if (this.getLocalTransaction().inTransaction() && !this.mc.isManagedEnvironment()) {
                    throw new FBSQLException("Calling setReadOnly(boolean) method is not allowed when transaction is already started.");
                }
                this.mc.setReadOnly(readOnly);
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            return this.mc.isReadOnly();
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkValidity();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            try {
                if (!this.getAutoCommit() && !this.mc.isManagedEnvironment()) {
                    this.txCoordinator.commit();
                }
                this.mc.setTransactionIsolation(level);
            }
            catch (ResourceException re) {
                throw new FBSQLException(re);
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            try {
                return this.mc.getTransactionIsolation();
            }
            catch (ResourceException e) {
                throw new FBSQLException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            return this.firstWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            this.firstWarning = null;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (resultSetHoldability == 1 && resultSetType == 1003) {
                this.addWarning(FbExceptionBuilder.forWarning(337248265).toFlatSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            if (resultSetType == 1005) {
                this.addWarning(FbExceptionBuilder.forWarning(337248266).toFlatSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            this.checkHoldability(resultSetType, resultSetHoldability);
            FBStatement stmt = new FBStatement(this.getGDSHelper(), resultSetType, resultSetConcurrency, resultSetHoldability, this.txCoordinator);
            this.activeStatements.add(stmt);
            return stmt;
        }
    }

    private void checkHoldability(int resultSetType, int resultSetHoldability) throws SQLException {
        boolean notScrollable;
        boolean holdable = resultSetHoldability == 1;
        boolean bl = notScrollable = resultSetType != 1004;
        if (holdable && notScrollable) {
            throw new FBDriverNotCapableException("Holdable cursors are supported only for scrollable insensitive result sets.");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
    }

    protected PreparedStatement prepareMetaDataStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability, true, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValidity();
        if (autoGeneratedKeys == 1) {
            this.checkAutoGeneratedKeysSupport();
        }
        GeneratedKeysQuery query = new GeneratedKeysQuery(sql, autoGeneratedKeys);
        return this.prepareStatement(query);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkValidity();
        this.checkAutoGeneratedKeysSupport();
        GeneratedKeysQuery query = new GeneratedKeysQuery(sql, columnIndexes);
        return this.prepareStatement(query);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkValidity();
        this.checkAutoGeneratedKeysSupport();
        GeneratedKeysQuery query = new GeneratedKeysQuery(sql, columnNames);
        return this.prepareStatement(query);
    }

    private PreparedStatement prepareStatement(AbstractGeneratedKeysQuery query) throws SQLException {
        if (query.generatesKeys()) {
            return this.prepareStatement(query.getQueryString(), 1003, 1007, 2, false, true);
        }
        return this.prepareStatement(query.getQueryString());
    }

    protected void checkAutoGeneratedKeysSupport() throws SQLException {
        GDSHelper gdsHelper = this.getGDSHelper();
        if (gdsHelper.compareToVersion(2, 0) < 0) {
            throw new FBDriverNotCapableException("This version of Firebird does not support retrieving generated keys (support was added in Firebird 2.0)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean metaData, boolean generatedKeys) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (resultSetHoldability == 1 && resultSetType == 1003) {
                this.addWarning(FbExceptionBuilder.forWarning(337248265).toFlatSQLException(SQLWarning.class));
                resultSetType = 1004;
            } else if (resultSetType == 1005) {
                this.addWarning(FbExceptionBuilder.forWarning(337248266).toFlatSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            this.checkHoldability(resultSetType, resultSetHoldability);
            FBObjectListener.StatementListener coordinator = metaData ? new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.txCoordinator) : this.txCoordinator;
            InternalTransactionCoordinator blobCoordinator = metaData ? null : this.txCoordinator;
            FBPreparedStatement stmt = new FBPreparedStatement(this.getGDSHelper(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, coordinator, blobCoordinator, metaData, false, generatedKeys);
            this.activeStatements.add(stmt);
            return stmt;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (resultSetHoldability == 1 && resultSetType == 1003) {
                this.addWarning(FbExceptionBuilder.forWarning(337248265).toFlatSQLException(SQLWarning.class));
                resultSetType = 1004;
            } else if (resultSetType == 1005) {
                this.addWarning(FbExceptionBuilder.forWarning(337248266).toFlatSQLException(SQLWarning.class));
                resultSetType = 1004;
            }
            if (resultSetConcurrency != 1007) {
                this.addWarning(FbExceptionBuilder.forWarning(337248267).toSQLException(SQLWarning.class));
                resultSetConcurrency = 1007;
            }
            this.checkHoldability(resultSetType, resultSetHoldability);
            if (this.storedProcedureMetaData == null) {
                this.storedProcedureMetaData = StoredProcedureMetaDataFactory.getInstance(this);
            }
            FBCallableStatement stmt = new FBCallableStatement(this.getGDSHelper(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, this.storedProcedureMetaData, this.txCoordinator, this.txCoordinator);
            this.activeStatements.add(stmt);
            return stmt;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    private int getNextSavepointCounter() {
        return this.savepointCounter.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            FBSavepoint savepoint = new FBSavepoint(this.getNextSavepointCounter());
            this.setSavepoint(savepoint);
            return savepoint;
        }
    }

    private void setSavepoint(FBSavepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode.", "25000");
        }
        if (this.mc.inDistributedTransaction()) {
            throw new SQLException("Connection enlisted in distributed transaction", "25000");
        }
        this.txCoordinator.ensureTransaction();
        this.getGDSHelper().executeImmediate("SAVEPOINT " + savepoint.getServerSavepointId());
        this.savepoints.add(savepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            FBSavepoint savepoint = new FBSavepoint(name);
            this.setSavepoint(savepoint);
            return savepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (this.getAutoCommit()) {
                throw new SQLException("Connection.rollback(Savepoint) method cannot be used in auto-commit mode.", "25000");
            }
            if (!(savepoint instanceof FBSavepoint)) {
                throw new SQLException("Specified savepoint was not obtained from this connection.");
            }
            if (this.mc.inDistributedTransaction()) {
                throw new SQLException("Connection enlisted in distributed transaction", "25000");
            }
            FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
            if (!fbSavepoint.isValid()) {
                throw new SQLException("Savepoint is no longer valid.");
            }
            this.getGDSHelper().executeImmediate("ROLLBACK TO " + fbSavepoint.getServerSavepointId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkValidity();
            if (this.getAutoCommit()) {
                throw new SQLException("Connection.releaseSavepoint() method cannot be used in auto-commit mode.", "25000");
            }
            if (!(savepoint instanceof FBSavepoint)) {
                throw new SQLException("Specified savepoint was not obtained from this connection.");
            }
            FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
            if (!fbSavepoint.isValid()) {
                throw new SQLException("Savepoint is no longer valid.");
            }
            this.getGDSHelper().executeImmediate("RELEASE SAVEPOINT " + fbSavepoint.getServerSavepointId() + " ONLY");
            fbSavepoint.invalidate();
            this.savepoints.remove(fbSavepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateSavepoints() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            for (FBSavepoint savepoint : this.savepoints) {
                savepoint.invalidate();
            }
            this.savepoints.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebirdLocalTransaction getLocalTransaction() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.localTransaction == null) {
                this.localTransaction = new FBLocalTransaction(this.mc, this);
            }
            return this.localTransaction;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(FBConnection.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkValidity();
        return null;
    }

    public boolean inTransaction() throws SQLException {
        return this.getGDSHelper().inTransaction();
    }

    @Override
    public String getIscEncoding() throws SQLException {
        return this.getGDSHelper().getIscEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(SQLWarning warning) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.firstWarning == null) {
                this.firstWarning = warning;
            } else {
                this.firstWarning.setNextWarning(warning);
            }
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        return (NClob)this.createClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    public GDSHelper getGDSHelper() throws SQLException {
        if (this.mc == null) {
            throw new FbExceptionBuilder().exception(335544363).toSQLException();
        }
        return this.mc.getGDSHelper();
    }

    @Override
    public boolean isUseFirebirdAutoCommit() {
        DatabaseParameterBuffer dpb = this.getDatabaseParameterBuffer();
        return dpb != null && dpb.hasArgument(143);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    protected void checkClientInfoSupport() throws SQLException {
        if (!this.getFbDatabase().getServerVersion().isEqualOrAbove(2, 0)) {
            throw new FBDriverNotCapableException("Required functionality (RDB$SET_CONTEXT()) only available in Firebird 2.0 or higher");
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkValidity();
        this.checkClientInfoSupport();
        Properties result = new Properties();
        try (PreparedStatement stmt = this.prepareStatement(GET_CLIENT_INFO_SQL);){
            for (String propName : this.clientInfoPropNames) {
                result.put(propName, this.getClientInfo(stmt, propName));
            }
        }
        return result;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkValidity();
        this.checkClientInfoSupport();
        try (PreparedStatement stmt = this.prepareStatement(GET_CLIENT_INFO_SQL);){
            String string = this.getClientInfo(stmt, name);
            return string;
        }
    }

    protected String getClientInfo(PreparedStatement stmt, String name) throws SQLException {
        stmt.clearParameters();
        stmt.setString(1, name);
        stmt.setString(2, name);
        try (ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String sessionContext = rs.getString(1);
            String transactionContext = rs.getString(2);
            if (transactionContext != null) {
                String string = transactionContext;
                return string;
            }
            if (sessionContext != null) {
                String string = sessionContext;
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        SQLExceptionChainBuilder<SQLClientInfoException> chain = new SQLExceptionChainBuilder<SQLClientInfoException>();
        try {
            this.checkValidity();
            this.checkClientInfoSupport();
            try (PreparedStatement stmt = this.prepareStatement(SET_CLIENT_INFO_SQL);){
                for (String propName : properties.stringPropertyNames()) {
                    String propValue = properties.getProperty(propName);
                    try {
                        this.setClientInfo(stmt, propName, propValue);
                    }
                    catch (SQLClientInfoException ex) {
                        chain.append(ex);
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null, (Throwable)ex);
        }
        if (chain.hasException()) {
            throw (SQLClientInfoException)chain.getException();
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkValidity();
            this.checkClientInfoSupport();
            try (PreparedStatement stmt = this.prepareStatement(SET_CLIENT_INFO_SQL);){
                this.setClientInfo(stmt, name, value);
            }
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(ex.getMessage(), ex.getSQLState(), null, (Throwable)ex);
        }
    }

    protected void setClientInfo(PreparedStatement stmt, String name, String value) throws SQLException {
        try {
            stmt.clearParameters();
            stmt.setString(1, name);
            stmt.setString(2, value);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new FBDriverConsistencyCheckException("Expected result from RDB$SET_CONTEXT call");
            }
            rs.getInt(1);
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(null, (Throwable)ex);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkValidity();
        return 0;
    }

    @Override
    public final Object getSynchronizationObject() {
        FBManagedConnection managedConnection = this.mc;
        if (managedConnection != null) {
            return managedConnection.getSynchronizationObject();
        }
        return this;
    }

    protected class GeneratedKeysQuery
    extends AbstractGeneratedKeysQuery {
        protected GeneratedKeysQuery(String sql, int autoGeneratedKeys) throws SQLException {
            super(sql, autoGeneratedKeys);
        }

        protected GeneratedKeysQuery(String sql, int[] columnIndexes) throws SQLException {
            super(sql, columnIndexes);
        }

        protected GeneratedKeysQuery(String sql, String[] columnNames) throws SQLException {
            super(sql, columnNames);
        }

        @Override
        DatabaseMetaData getDatabaseMetaData() throws SQLException {
            return FBConnection.this.getMetaData();
        }
    }
}

