/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

public enum QuoteStrategy {
    NO_QUOTES{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            return sb.append(objectName);
        }
    }
    ,
    QUOTES{

        @Override
        public StringBuilder appendQuoted(String objectName, StringBuilder sb) {
            return sb.append('\"').append(objectName).append('\"');
        }
    };


    public abstract StringBuilder appendQuoted(String var1, StringBuilder var2);

    public static QuoteStrategy forDialect(int dialect) {
        if (dialect == 1) {
            return NO_QUOTES;
        }
        return QUOTES;
    }
}

