/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.event;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.firebirdsql.event.DatabaseEvent;
import org.firebirdsql.event.DatabaseEventImpl;
import org.firebirdsql.event.EventListener;
import org.firebirdsql.event.EventManager;
import org.firebirdsql.event.OneTimeEventListener;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.gds.ng.listeners.DefaultDatabaseListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBEventManager
implements EventManager {
    private static final Logger log = LoggerFactory.getLogger(FBEventManager.class);
    private final GDSType gdsType;
    private FbDatabase fbDatabase;
    private final IConnectionProperties connectionProperties;
    private final EventManagerBehaviour eventManagerBehaviour;
    private volatile boolean connected = false;
    private final Map<String, Set<EventListener>> listenerMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, GdsEventHandler> handlerMap = Collections.synchronizedMap(new HashMap());
    private final BlockingQueue<DatabaseEvent> eventQueue = new LinkedBlockingQueue<DatabaseEvent>();
    private EventDispatcher eventDispatcher;
    private Thread dispatchThread;
    private volatile long waitTimeout = 1000L;

    public FBEventManager() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBEventManager(GDSType gdsType) {
        this.gdsType = gdsType;
        this.connectionProperties = new FbConnectionProperties();
        this.eventManagerBehaviour = new DefaultEventManagerBehaviour();
    }

    private FBEventManager(Connection connection) throws SQLException {
        this.fbDatabase = connection.unwrap(FirebirdConnection.class).getFbDatabase();
        this.gdsType = null;
        this.connectionProperties = this.fbDatabase.getConnectionProperties().asImmutable();
        this.fbDatabase.addDatabaseListener(new DefaultDatabaseListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detaching(FbDatabase database) {
                try {
                    if (!FBEventManager.this.isConnected()) {
                        return;
                    }
                    try {
                        FBEventManager.this.disconnect();
                    }
                    catch (SQLException e) {
                        log.error("Exception on disconnect of event manager on connection detaching.", e);
                    }
                }
                finally {
                    database.removeDatabaseListener(this);
                    FBEventManager.this.fbDatabase = null;
                }
            }
        });
        this.eventManagerBehaviour = new ManagedEventManagerBehaviour();
    }

    public static EventManager createFor(Connection connection) throws SQLException {
        return new FBEventManager(connection);
    }

    @Override
    public void connect() throws SQLException {
        if (this.connected) {
            throw new IllegalStateException("Connect called while already connected");
        }
        this.eventManagerBehaviour.connectDatabase();
        this.connected = true;
        this.eventDispatcher = new EventDispatcher();
        this.dispatchThread = new Thread(this.eventDispatcher);
        this.dispatchThread.setDaemon(true);
        this.dispatchThread.start();
    }

    @Override
    public void close() throws SQLException {
        if (this.connected) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() throws SQLException {
        if (!this.connected) {
            throw new IllegalStateException("Disconnect called while not connected");
        }
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        try {
            try {
                for (String eventName : new HashSet<String>(this.handlerMap.keySet())) {
                    try {
                        this.unregisterListener(eventName);
                    }
                    catch (SQLException e) {
                        chain.append(e);
                    }
                    catch (Exception e) {
                        chain.append(new SQLException(e));
                    }
                }
            }
            finally {
                this.handlerMap.clear();
                this.listenerMap.clear();
                try {
                    this.eventManagerBehaviour.disconnectDatabase();
                }
                catch (SQLException e) {
                    chain.append(e);
                }
                this.connected = false;
            }
        }
        finally {
            this.eventDispatcher.stop();
            this.dispatchThread.interrupt();
            try {
                this.dispatchThread.join();
            }
            catch (InterruptedException ex) {
                chain.append(new FBSQLException(ex));
            }
            finally {
                this.eventDispatcher = null;
                this.dispatchThread = null;
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void setUser(String user) {
        this.connectionProperties.setUser(user);
    }

    @Override
    public String getUser() {
        return this.connectionProperties.getUser();
    }

    @Override
    public void setPassword(String password) {
        this.connectionProperties.setPassword(password);
    }

    @Override
    public String getPassword() {
        return this.connectionProperties.getPassword();
    }

    @Override
    public void setDatabase(String database) {
        this.connectionProperties.setDatabaseName(database);
    }

    @Override
    public String getDatabase() {
        return this.connectionProperties.getDatabaseName();
    }

    @Override
    public String getHost() {
        return this.connectionProperties.getServerName();
    }

    @Override
    public void setHost(String host) {
        this.connectionProperties.setServerName(host);
    }

    @Override
    public int getPort() {
        return this.connectionProperties.getPortNumber();
    }

    @Override
    public void setPort(int port) {
        this.connectionProperties.setPortNumber(port);
    }

    @Override
    public WireCrypt getWireCrypt() {
        return this.connectionProperties.getWireCrypt();
    }

    @Override
    public void setWireCrypt(WireCrypt wireCrypt) {
        this.connectionProperties.setWireCrypt(wireCrypt);
    }

    @Override
    public String getDbCryptConfig() {
        return this.connectionProperties.getDbCryptConfig();
    }

    @Override
    public void setDbCryptConfig(String dbCryptConfig) {
        this.connectionProperties.setDbCryptConfig(dbCryptConfig);
    }

    @Override
    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void setWaitTimeout(long waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(String eventName, EventListener listener) throws SQLException {
        if (!this.connected) {
            throw new IllegalStateException("Can't add event listeners to disconnected EventManager");
        }
        if (listener == null || eventName == null) {
            throw new NullPointerException();
        }
        Map<String, Set<EventListener>> map = this.listenerMap;
        synchronized (map) {
            if (!this.listenerMap.containsKey(eventName)) {
                this.registerListener(eventName);
                this.listenerMap.put(eventName, new HashSet());
            }
            Set<EventListener> listenerSet = this.listenerMap.get(eventName);
            listenerSet.add(listener);
        }
    }

    @Override
    public void removeEventListener(String eventName, EventListener listener) throws SQLException {
        if (eventName == null || listener == null) {
            throw new NullPointerException();
        }
        Set<EventListener> listenerSet = this.listenerMap.get(eventName);
        if (listenerSet != null) {
            listenerSet.remove(listener);
            if (listenerSet.isEmpty()) {
                this.listenerMap.remove(eventName);
                this.unregisterListener(eventName);
            }
        }
    }

    @Override
    public int waitForEvent(String eventName) throws InterruptedException, SQLException {
        return this.waitForEvent(eventName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForEvent(String eventName, int timeout) throws InterruptedException, SQLException {
        if (!this.connected) {
            throw new IllegalStateException("Can't wait for events with disconnected EventManager");
        }
        if (eventName == null) {
            throw new NullPointerException();
        }
        Object lock = new Object();
        OneTimeEventListener listener = new OneTimeEventListener(lock);
        try {
            Object object = lock;
            synchronized (object) {
                this.addEventListener(eventName, listener);
                lock.wait(timeout);
            }
        }
        finally {
            this.removeEventListener(eventName, listener);
        }
        return listener.getEventCount();
    }

    private void registerListener(String eventName) throws SQLException {
        GdsEventHandler handler = new GdsEventHandler(eventName);
        this.handlerMap.put(eventName, handler);
        handler.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterListener(String eventName) throws SQLException {
        GdsEventHandler handler = this.handlerMap.get(eventName);
        try {
            if (handler != null) {
                handler.unregister();
            }
        }
        finally {
            this.handlerMap.remove(eventName);
        }
    }

    class EventDispatcher
    implements Runnable {
        private volatile boolean running = true;

        EventDispatcher() {
        }

        public void stop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    DatabaseEvent event = (DatabaseEvent)FBEventManager.this.eventQueue.poll(FBEventManager.this.waitTimeout, TimeUnit.MILLISECONDS);
                    if (event == null) continue;
                    Map map = FBEventManager.this.listenerMap;
                    synchronized (map) {
                        Set listenerSet = (Set)FBEventManager.this.listenerMap.get(event.getEventName());
                        if (listenerSet != null) {
                            for (EventListener listener : listenerSet) {
                                listener.eventOccurred(event);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    class GdsEventHandler
    implements EventHandler {
        private final EventHandle eventHandle;
        private boolean initialized = false;
        private volatile boolean cancelled = false;

        public GdsEventHandler(String eventName) throws SQLException {
            this.eventHandle = FBEventManager.this.fbDatabase.createEventHandle(eventName, this);
        }

        public synchronized void register() throws SQLException {
            if (this.cancelled) {
                throw new IllegalStateException("Trying to register a cancelled event handler");
            }
            FBEventManager.this.fbDatabase.queueEvent(this.eventHandle);
        }

        public synchronized void unregister() throws SQLException {
            if (this.cancelled) {
                return;
            }
            FBEventManager.this.fbDatabase.cancelEvent(this.eventHandle);
            this.cancelled = true;
        }

        @Override
        public synchronized void eventOccurred(EventHandle eventHandle) {
            if (!this.cancelled) {
                String message;
                try {
                    FBEventManager.this.fbDatabase.countEvents(eventHandle);
                }
                catch (SQLException e) {
                    message = "Exception processing event counts";
                    log.warn(message + ": " + e + "; see debug level for stacktrace");
                    log.debug(message, e);
                }
                if (this.initialized && !this.cancelled) {
                    FBEventManager.this.eventQueue.add(new DatabaseEventImpl(eventHandle.getEventName(), eventHandle.getEventCount()));
                } else {
                    this.initialized = true;
                }
                try {
                    this.register();
                }
                catch (SQLException e) {
                    message = "Exception registering for event";
                    log.warn(message + ": " + e + "; see debug level for stacktrace");
                    log.debug(message, e);
                }
            }
        }
    }

    private class ManagedEventManagerBehaviour
    implements EventManagerBehaviour {
        private ManagedEventManagerBehaviour() {
        }

        @Override
        public void connectDatabase() throws SQLException {
            if (FBEventManager.this.fbDatabase == null) {
                throw FbExceptionBuilder.forException(337248273).toFlatSQLException();
            }
        }

        @Override
        public void disconnectDatabase() {
        }
    }

    private class DefaultEventManagerBehaviour
    implements EventManagerBehaviour {
        private DefaultEventManagerBehaviour() {
        }

        @Override
        public void connectDatabase() throws SQLException {
            FbDatabaseFactory databaseFactory = GDSFactory.getDatabaseFactoryForType(FBEventManager.this.gdsType);
            FBEventManager.this.fbDatabase = databaseFactory.connect(FBEventManager.this.connectionProperties);
            FBEventManager.this.fbDatabase.attach();
        }

        @Override
        public void disconnectDatabase() throws SQLException {
            FBEventManager.this.fbDatabase.close();
        }
    }

    private static interface EventManagerBehaviour {
        public void connectDatabase() throws SQLException;

        public void disconnectDatabase() throws SQLException;
    }
}

