/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.oo;

import org.firebirdsql.gds.ClassFactory;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.GDSObjectFactory;
import org.firebirdsql.gds.impl.GDSFactoryPlugin;
import org.firebirdsql.gds.impl.wire.AbstractJavaGDSImpl;

public class OOGDSFactoryPlugin
implements GDSFactoryPlugin {
    private static final String TYPE_NAME = "OOREMOTE";
    private static final String[] TYPE_ALIASES = new String[0];
    private static final String[] JDBC_PROTOCOLS = new String[]{"jdbc:firebird:oo:", "jdbc:firebirdsql:oo:"};
    private static AbstractJavaGDSImpl gdsImpl;

    @Override
    public String getPluginName() {
        return "GDS implementation for OpenOffice.";
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String[] getTypeAliases() {
        return TYPE_ALIASES;
    }

    @Override
    public Class getConnectionClass() {
        return ClassFactory.get("org.firebirdsql.jdbc.oo.OOConnection");
    }

    @Override
    public String[] getSupportedProtocols() {
        return JDBC_PROTOCOLS;
    }

    @Override
    public GDS getGDS() {
        if (gdsImpl == null) {
            gdsImpl = GDSObjectFactory.createJavaGDSImpl();
        }
        return gdsImpl;
    }

    @Override
    public String getDatabasePath(String server, Integer port, String path) throws GDSException {
        if (server == null) {
            throw new GDSException("Server name/address is required for pure Java implementation.");
        }
        if (path == null) {
            throw new GDSException("Database name/path is required.");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(server);
        if (port != null) {
            sb.append("/").append(port);
        }
        sb.append(":").append(path);
        return sb.toString();
    }

    @Override
    public String getDatabasePath(String jdbcUrl) throws GDSException {
        String[] protocols = this.getSupportedProtocols();
        for (int i = 0; i < protocols.length; ++i) {
            if (!jdbcUrl.startsWith(protocols[i])) continue;
            return jdbcUrl.substring(protocols[i].length());
        }
        throw new IllegalArgumentException("Incorrect JDBC protocol handling: " + jdbcUrl);
    }

    @Override
    public String getDefaultProtocol() {
        return this.getSupportedProtocols()[0];
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof OOGDSFactoryPlugin;
    }
}

