/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBCachedFetcher;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetMetaData;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FBRowUpdater;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLWarning;
import org.firebirdsql.jdbc.FBStatementFetcher;
import org.firebirdsql.jdbc.FBUpdatableCursorFetcher;
import org.firebirdsql.jdbc.FirebirdResultSet;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public abstract class AbstractResultSet
implements ResultSet,
FirebirdResultSet,
Synchronizable,
FBObjectListener.FetcherListener {
    private AbstractStatement fbStatement;
    private FBFetcher fbFetcher;
    private FirebirdRowUpdater rowUpdater;
    protected AbstractConnection connection;
    protected GDSHelper gdsHelper;
    protected final XSQLVAR[] xsqlvars;
    protected byte[][] row;
    private int maxRows = 0;
    private boolean wasNull = false;
    private boolean wasNullValid = false;
    private volatile boolean closed = false;
    private boolean trimStrings;
    private SQLWarning firstWarning = null;
    private FBField[] fields = null;
    private final Map<String, Integer> colNames;
    private String cursorName;
    private FBObjectListener.ResultSetListener listener;
    private final int rsType;
    private int rsConcurrency;
    private final int rsHoldability;

    @Override
    public void allRowsFetched(FBFetcher fetcher) throws SQLException {
        this.listener.allRowsFetched(this);
    }

    @Override
    public void fetcherClosed(FBFetcher fetcher) throws SQLException {
    }

    @Override
    public void rowChanged(FBFetcher fetcher, byte[][] newRow) throws SQLException {
        this.row = newRow;
    }

    protected AbstractResultSet(AbstractConnection connection, AbstractStatement fbStatement, AbstractIscStmtHandle stmt, FBObjectListener.ResultSetListener listener, boolean metaDataQuery, int rsType, int rsConcurrency, int rsHoldability, boolean cached) throws SQLException {
        this.connection = connection;
        try {
            this.gdsHelper = connection != null ? connection.getGDSHelper() : null;
        }
        catch (GDSException e) {
            throw new FBSQLException(e);
        }
        this.cursorName = fbStatement.getCursorName();
        this.listener = listener;
        if (rsType == 1005) {
            fbStatement.addWarning(new FBSQLWarning("Result set type changed. ResultSet.TYPE_SCROLL_SENSITIVE is not supported."));
            this.rsType = 1004;
        } else {
            this.rsType = rsType;
        }
        this.rsConcurrency = rsConcurrency;
        this.rsHoldability = rsHoldability;
        this.trimStrings = metaDataQuery;
        this.xsqlvars = stmt.getOutSqlda().sqlvar;
        this.maxRows = fbStatement.getMaxRows();
        this.fbStatement = fbStatement;
        boolean updatableCursor = fbStatement.isUpdatableCursor();
        if (rsType != 1003 || metaDataQuery) {
            cached = true;
        }
        this.fields = new FBField[this.xsqlvars.length];
        this.colNames = new HashMap<String, Integer>(this.xsqlvars.length, 1.0f);
        this.prepareVars(cached);
        this.fbFetcher = cached ? new FBCachedFetcher(this.gdsHelper, fbStatement.fetchSize, fbStatement.maxRows, stmt, this, rsType == 1003) : (updatableCursor ? new FBUpdatableCursorFetcher(this.gdsHelper, fbStatement, stmt, this, fbStatement.getMaxRows(), fbStatement.getFetchSize()) : new FBStatementFetcher(this.gdsHelper, fbStatement, stmt, this, fbStatement.getMaxRows(), fbStatement.getFetchSize()));
        if (rsConcurrency == 1008) {
            try {
                this.rowUpdater = new FBRowUpdater(connection, this.xsqlvars, this, cached, listener);
            }
            catch (FBResultSetNotUpdatableException ex) {
                fbStatement.addWarning(new FBSQLWarning("Result set concurrency changed to READ ONLY."));
                this.rsConcurrency = 1007;
            }
        }
    }

    protected AbstractResultSet(XSQLVAR[] xsqlvars, ArrayList rows) throws SQLException {
        this(xsqlvars, null, rows, false);
    }

    protected AbstractResultSet(XSQLVAR[] xsqlvars, GDSHelper gdsHelper, ArrayList rows, boolean retrieveBlobs) throws SQLException {
        this.maxRows = 0;
        this.fbFetcher = new FBCachedFetcher(rows, this, xsqlvars, gdsHelper, retrieveBlobs);
        this.rsType = 1003;
        this.rsConcurrency = 1007;
        this.rsHoldability = 2;
        this.xsqlvars = xsqlvars;
        this.fields = new FBField[xsqlvars.length];
        this.colNames = new HashMap<String, Integer>(xsqlvars.length, 1.0f);
        this.prepareVars(true);
    }

    private void prepareVars(boolean cached) throws SQLException {
        for (int i = 0; i < this.xsqlvars.length; ++i) {
            final int fieldPosition = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return AbstractResultSet.this.row[fieldPosition];
                }

                @Override
                public void setFieldData(byte[] data) {
                    AbstractResultSet.this.row[fieldPosition] = data;
                }
            };
            this.fields[i] = FBField.createField(this.xsqlvars[i], dataProvider, this.gdsHelper, cached);
        }
    }

    private void notifyRowUpdater() throws SQLException {
        if (this.rowUpdater != null) {
            this.rowUpdater.setRow(this.row);
        }
    }

    protected void checkCursorMove() throws SQLException {
        this.checkOpen();
        this.closeFields();
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("The result set is closed", "07005");
        }
    }

    protected void closeFields() throws SQLException {
        this.wasNullValid = false;
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        for (FBField field : this.fields) {
            try {
                field.close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    @Override
    public final Object getSynchronizationObject() {
        return this.fbStatement.getSynchronizationObject();
    }

    @Override
    public boolean next() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.next();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    void close(boolean notifyListener) throws SQLException {
        this.close(notifyListener, CompletionReason.OTHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean notifyListener, CompletionReason completionReason) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        try {
            this.closeFields();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
        finally {
            try {
                if (this.fbFetcher != null) {
                    try {
                        this.fbFetcher.close(completionReason);
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
                if (this.rowUpdater != null) {
                    try {
                        this.rowUpdater.close();
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
                if (notifyListener && this.listener != null) {
                    try {
                        this.listener.resultSetClosed(this);
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
            }
            finally {
                this.fbFetcher = null;
                this.rowUpdater = null;
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (!this.wasNullValid) {
            throw new FBSQLException("Look at a column before testing null.");
        }
        if (this.row == null) {
            throw new FBSQLException("No row available for wasNull.");
        }
        return this.wasNull;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getAsciiStream();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBigDecimal();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBinaryStream();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBlob();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getByte();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDate();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getDouble();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getFloat();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getInt();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getLong();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getObject();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getShort();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnIndex).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnIndex).getString();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTime();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getTimestamp();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getUnicodeStream();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    protected XSQLVAR getXsqlvar(int columnIndex) {
        return this.xsqlvars[columnIndex - 1];
    }

    public FBField getField(int columnIndex) throws SQLException {
        FBField field = this.getField(columnIndex, true);
        this.wasNullValid = true;
        this.wasNull = this.row == null || this.row[columnIndex - 1] == null;
        return field;
    }

    public FBField getField(int columnIndex, boolean checkRowPosition) throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("The resultSet is closed");
        }
        if (checkRowPosition && this.row == null && this.rowUpdater == null) {
            throw new FBSQLException("The resultSet is not in a row, use next", "01S06");
        }
        if (columnIndex > this.xsqlvars.length) {
            throw new FBSQLException("Invalid column index.", "HY002");
        }
        if (this.rowUpdater != null) {
            return this.rowUpdater.getField(columnIndex - 1);
        }
        return this.fields[columnIndex - 1];
    }

    public FBField getField(String columnName) throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("The resultSet is closed");
        }
        if (this.row == null && this.rowUpdater == null) {
            throw new FBSQLException("The resultSet is not in a row, use next", "01S06");
        }
        if (columnName == null) {
            throw new FBSQLException("Column identifier must be not null.", "HY002");
        }
        Integer fieldNum = this.colNames.get(columnName);
        if (fieldNum == null) {
            fieldNum = this.findColumn(columnName);
            this.colNames.put(columnName, fieldNum);
        }
        int colNum = fieldNum;
        FBField field = this.rowUpdater != null ? this.rowUpdater.getField(colNum - 1) : this.fields[colNum - 1];
        this.wasNullValid = true;
        this.wasNull = this.row == null || this.row[colNum - 1] == null;
        return field;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getField(columnIndex).getBigDecimal(scale);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        if (this.trimStrings) {
            String result = this.getField(columnName).getString();
            return result != null ? result.trim() : null;
        }
        return this.getField(columnName).getString();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getField(columnName).getBoolean();
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getField(columnName).getByte();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getField(columnName).getShort();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getField(columnName).getInt();
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getField(columnName).getLong();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getField(columnName).getFloat();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getField(columnName).getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getField(columnName).getBigDecimal(scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getField(columnName).getBytes();
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getField(columnName).getDate();
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getField(columnName).getTime();
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getField(columnName).getTimestamp();
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getField(columnName).getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getField(columnName).getUnicodeStream();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getField(columnName).getBinaryStream();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new FBResultSetMetaData(this.xsqlvars, this.connection);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getField(columnName).getObject();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (columnName == null || columnName.equals("")) {
            throw new FBSQLException("Empty string does not identify column.", "HY002");
        }
        if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
            int i;
            columnName = columnName.substring(1, columnName.length() - 1);
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equals(this.xsqlvars[i].aliasname)) continue;
                return ++i;
            }
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equals(this.xsqlvars[i].sqlname)) continue;
                return ++i;
            }
        } else {
            int i;
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equalsIgnoreCase(this.xsqlvars[i].aliasname)) continue;
                return ++i;
            }
            for (i = 0; i < this.xsqlvars.length; ++i) {
                if (!columnName.equalsIgnoreCase(this.xsqlvars[i].sqlname)) continue;
                return ++i;
            }
        }
        throw new FBSQLException("Column name " + columnName + " not found in result set.", "HY002");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getField(columnIndex).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getField(columnName).getCharacterStream();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getField(columnName).getBigDecimal();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.fbFetcher.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.fbFetcher.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.fbFetcher.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.fbFetcher.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.beforeFirst();
        this.notifyRowUpdater();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkCursorMove();
        this.fbFetcher.afterLast();
        this.notifyRowUpdater();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.first();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.last();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        return this.fbFetcher.getRowNum();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.absolute(row);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.relative(rows);
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkCursorMove();
        boolean result = this.fbFetcher.previous();
        if (result) {
            this.notifyRowUpdater();
        }
        return result;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new FBDriverNotCapableException("Can't set fetch direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new FBSQLException("Can't set negative fetch size.", "HY009");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new FBSQLException("Can't set fetch size > maxRows.", "HY009");
        }
        this.fbFetcher.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fbFetcher.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.rsType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rsHoldability;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.rowUpdater != null) {
            return this.rowUpdater.rowUpdated();
        }
        throw new FBResultSetNotUpdatableException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.rowUpdater != null) {
            return this.rowUpdater.rowUpdated();
        }
        throw new FBResultSetNotUpdatableException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.rowUpdater != null) {
            return this.rowUpdater.rowUpdated();
        }
        throw new FBResultSetNotUpdatableException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setNull();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBoolean(x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setByte(x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setShort(x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setInteger(x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setLong(x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setFloat(x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setDouble(x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBigDecimal(x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setString(x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBytes(x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setDate(x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setTime(x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setTimestamp(x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setAsciiStream(x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setCharacterStream(x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setObject(x);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnIndex).setObject(x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setNull();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBoolean(x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setByte(x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setShort(x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setInteger(x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setLong(x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setFloat(x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setDouble(x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBigDecimal(x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setString(x);
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBytes(x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setDate(x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setTime(x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setTimestamp(x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setAsciiStream(x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setBinaryStream(x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setCharacterStream(reader, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setObject(x);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.getField(columnName).setObject(x);
    }

    @Override
    public void insertRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.insertRow();
        this.fbFetcher.insertRow(this.rowUpdater.getInsertRow());
        this.notifyRowUpdater();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.updateRow();
        this.fbFetcher.updateRow(this.rowUpdater.getNewRow());
        this.notifyRowUpdater();
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.deleteRow();
        this.fbFetcher.deleteRow();
        this.notifyRowUpdater();
    }

    @Override
    public void refreshRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.refreshRow();
        this.fbFetcher.updateRow(this.rowUpdater.getOldRow());
        this.notifyRowUpdater();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.rowUpdater == null) {
            throw new FBResultSetNotUpdatableException();
        }
        this.rowUpdater.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() {
        return this.fbStatement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getField(i).getObject(map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.getField(i).getRef();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.getField(i).getClob();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.getField(i).getArray();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getField(columnName).getObject(map);
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getField(columnName).getRef();
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getField(columnName).getBlob();
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getField(columnName).getClob();
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.getField(columnName).getArray();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getDate(cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getDate(cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTime(cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getField(columnIndex).getTimestamp(cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getField(columnName).getTimestamp(cal);
    }

    @Override
    public URL getURL(int param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public URL getURL(String param1) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateRef(int param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateRef(String param1, Ref param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBlob(int param1, Blob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBlob(String param1, Blob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateClob(int param1, Clob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateClob(String param1, Clob param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateArray(int param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public void updateArray(String param1, Array param2) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public String getExecutionPlan() throws SQLException {
        this.checkCursorMove();
        if (this.fbStatement == null) {
            return "";
        }
        return this.fbStatement.getExecutionPlan();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new FBDriverNotCapableException();
        }
        return iface.cast(this);
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }
}

