/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.flowable.external.worker.annotation.FlowableWorker;
import org.flowable.external.worker.annotation.FlowableWorkerConfigurer;
import org.flowable.external.worker.annotation.FlowableWorkers;
import org.flowable.external.worker.config.FlowableWorkerContainerFactory;
import org.flowable.external.worker.config.FlowableWorkerEndpointRegistrar;
import org.flowable.external.worker.config.FlowableWorkerEndpointRegistry;
import org.flowable.external.worker.config.MethodFlowableWorkerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FlowableWorkerAnnotationBeanPostProcessor
implements MergedBeanDefinitionPostProcessor,
Ordered,
BeanFactoryAware,
SmartInitializingSingleton {
    static final String DEFAULT_FLOWABLE_WORKER_CONTAINER_FACTORY_BEAN_NAME = "flowableWorkerContainerFactory";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String containerFactoryBeanName = "flowableWorkerContainerFactory";
    protected FlowableWorkerEndpointRegistry endpointRegistry;
    protected final MessageHandlerMethodFactoryAdapter messageHandlerMethodFactory = new MessageHandlerMethodFactoryAdapter();
    protected BeanFactory beanFactory;
    protected BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    protected BeanExpressionContext expressionContext;
    protected final FlowableWorkerEndpointRegistrar registrar = new FlowableWorkerEndpointRegistrar();
    protected final AtomicInteger counter = new AtomicInteger();
    protected final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setEndpointRegistry(FlowableWorkerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.registrar.setBeanFactory(beanFactory);
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
            this.resolver = clbf.getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.nonAnnotatedClasses.clear();
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            Map beans = lbf.getBeansOfType(FlowableWorkerConfigurer.class);
            ArrayList configurers = new ArrayList(beans.values());
            AnnotationAwareOrderComparator.sort(configurers);
            for (FlowableWorkerConfigurer configurer : configurers) {
                configurer.configureFlowableWorkers(this.registrar);
            }
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (FlowableWorkerEndpointRegistry)this.beanFactory.getBean("org.flowable.external.client.config.internalFlowableWorkerEndpointRegistry", FlowableWorkerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AopInfrastructureBean || bean instanceof FlowableWorkerContainerFactory || bean instanceof FlowableWorkerEndpointRegistry) {
            return bean;
        }
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass) && AnnotationUtils.isCandidateClass((Class)targetClass, FlowableWorker.class)) {
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set workerMethods = AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)method, FlowableWorker.class, FlowableWorkers.class);
                return !workerMethods.isEmpty() ? workerMethods : null;
            });
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetClass);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No @FlowableWorker annotations found on bean type: " + targetClass);
                }
            } else {
                annotatedMethods.forEach((method, workers) -> workers.forEach(worker -> this.processFlowableWorker((FlowableWorker)worker, (Method)method, bean)));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(annotatedMethods.size() + " @FlowableWorker methods processed on bean '" + beanName + "': " + annotatedMethods);
                }
            }
        }
        return bean;
    }

    protected void processFlowableWorker(FlowableWorker flowableWorker, Method method, Object bean) {
        Method invocableMethod = AopUtils.selectInvocableMethod((Method)method, bean.getClass());
        MethodFlowableWorkerEndpoint endpoint = this.createMethodFlowableWorkerEndpoint();
        endpoint.setBean(bean);
        endpoint.setMethod(invocableMethod);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(flowableWorker));
        endpoint.setTopic(this.resolve(flowableWorker.topic()));
        if (StringUtils.hasText((String)flowableWorker.lockDuration())) {
            endpoint.setLockDuration(this.resolveExpressionAsDuration(flowableWorker.lockDuration(), "lockDuration"));
        }
        if (StringUtils.hasText((String)flowableWorker.pollingInterval())) {
            endpoint.setPollingInterval(this.resolveExpressionAsDuration(flowableWorker.pollingInterval(), "pollingInterval"));
        }
        if (StringUtils.hasText((String)flowableWorker.numberOfRetries())) {
            endpoint.setNumberOfRetries(this.resolveExpressionAsInteger(flowableWorker.numberOfRetries(), "numberOfRetries"));
        }
        if (StringUtils.hasText((String)flowableWorker.numberOfTasks())) {
            endpoint.setNumberOfTasks(this.resolveExpressionAsInteger(flowableWorker.numberOfTasks(), "numberOfTasks"));
        }
        if (StringUtils.hasText((String)flowableWorker.concurrency())) {
            endpoint.setConcurrency(this.resolveExpressionAsInteger(flowableWorker.concurrency(), "concurrency"));
        }
        this.registrar.registerEndpoint(endpoint, null);
    }

    protected MethodFlowableWorkerEndpoint createMethodFlowableWorkerEndpoint() {
        return new MethodFlowableWorkerEndpoint();
    }

    protected String getEndpointId(FlowableWorker flowableWorker) {
        String id = flowableWorker.id();
        if (StringUtils.hasText((String)id)) {
            String resolvedId = this.resolve(id);
            return resolvedId != null ? resolvedId : "";
        }
        return "org.flowable.external.client.FlowableWorkerEndpointContainer#" + this.counter.getAndIncrement();
    }

    protected Duration resolveExpressionAsDuration(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof Duration) {
            Duration duration = (Duration)resolved;
            return duration;
        }
        if (resolved instanceof String) {
            String str = (String)resolved;
            return Duration.parse(str);
        }
        if (resolved != null) {
            throw new IllegalStateException("The [" + attribute + "] must resolve to a Duration or a String that can be parsed as a Duration. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
        }
        return null;
    }

    protected Integer resolveExpressionAsInteger(String value, String attribute) {
        Object resolved = this.resolveExpression(value);
        if (resolved instanceof String) {
            String str = (String)resolved;
            return Integer.parseInt(str);
        }
        if (resolved instanceof Number) {
            Number number = (Number)resolved;
            return number.intValue();
        }
        if (resolved != null) {
            throw new IllegalStateException("The [" + attribute + "] must resolve to a Number or a String that can be parsed as an Integer. Resolved to [" + resolved.getClass() + "] for [" + value + "]");
        }
        return null;
    }

    protected Object resolveExpression(String value) {
        return this.resolver.evaluate(this.resolve(value), this.expressionContext);
    }

    protected String resolve(String value) {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            return cbf.resolveEmbeddedValue(value);
        }
        return value;
    }

    protected class MessageHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        protected MessageHandlerMethodFactory messageHandlerMethodFactory;

        protected MessageHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
            this.messageHandlerMethodFactory = messageHandlerMethodFactory;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        protected MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        protected MessageHandlerMethodFactory createDefaultHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            if (FlowableWorkerAnnotationBeanPostProcessor.this.beanFactory != null) {
                defaultFactory.setBeanFactory(FlowableWorkerAnnotationBeanPostProcessor.this.beanFactory);
            }
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

