/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.config;

import java.time.Duration;
import org.flowable.external.worker.FlowableWorkerJobListener;
import org.flowable.external.worker.config.FlowableWorkerEndpoint;
import org.flowable.external.worker.listener.WorkerJobListenerContainer;
import org.flowable.external.worker.worker.FlowableWorkerContainer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractFlowableWorkerEndpoint
implements FlowableWorkerEndpoint {
    protected String id = "";
    protected String topic;
    protected Duration lockDuration;
    protected Duration pollingInterval;
    protected Integer numberOfRetries;
    protected Integer numberOfTasks;
    protected Integer concurrency;

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setTopic(String topic) {
        Assert.hasText((String)topic, (String)"topic must not be empty");
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public void setPollingInterval(Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public Duration getPollingInterval() {
        return this.pollingInterval;
    }

    public void setNumberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfTasks(Integer numberOfTasks) {
        this.numberOfTasks = numberOfTasks;
    }

    public Integer getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    @Override
    public void setupWorkerContainer(FlowableWorkerContainer workerContainer) {
        if (workerContainer instanceof WorkerJobListenerContainer) {
            WorkerJobListenerContainer abstractContainer = (WorkerJobListenerContainer)workerContainer;
            this.setupFlowableWorkerContainer(abstractContainer);
        }
        this.setupWorkerJobListener(workerContainer);
    }

    protected void setupFlowableWorkerContainer(WorkerJobListenerContainer workerContainer) {
        Integer numberOfTasks;
        Integer numberOfRetries;
        Duration lockDuration;
        Duration pollingInterval;
        if (StringUtils.hasText((String)this.getId())) {
            workerContainer.setBeanName(this.getId());
        }
        String topic = this.getTopic();
        Assert.hasText((String)topic, (String)"topic has to be configured");
        workerContainer.setTopic(topic);
        Integer concurrency = this.getConcurrency();
        if (concurrency != null) {
            workerContainer.setConcurrency(concurrency);
        }
        if ((pollingInterval = this.getPollingInterval()) != null) {
            workerContainer.setPollingInterval(pollingInterval);
        }
        if ((lockDuration = this.getLockDuration()) != null) {
            workerContainer.setLockDuration(lockDuration);
        }
        if ((numberOfRetries = this.getNumberOfRetries()) != null) {
            workerContainer.setNumberOfRetries(numberOfRetries);
        }
        if ((numberOfTasks = this.getNumberOfTasks()) != null) {
            workerContainer.setNumberOfTasks(numberOfTasks);
        }
    }

    protected abstract FlowableWorkerJobListener createWorkerJobListener(FlowableWorkerContainer var1);

    protected void setupWorkerJobListener(FlowableWorkerContainer container) {
        container.setupWorkerJobListener(this.createWorkerJobListener(container));
    }

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append('[').append(this.id).append(']').append(" topic='").append(this.topic).append('\'').append(" | lockDuration=").append(this.lockDuration).append(" | numberOfRetries=").append(this.numberOfRetries).append(" | numberOfTasks=").append(this.numberOfRetries);
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }
}

