/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.config;

import java.time.Duration;
import org.flowable.external.client.ExternalWorkerClient;
import org.flowable.external.worker.config.FlowableWorkerContainerFactory;
import org.flowable.external.worker.config.FlowableWorkerEndpoint;
import org.flowable.external.worker.listener.WorkerJobListenerContainer;
import org.springframework.util.Assert;

public class DefaultFlowableWorkerContainerFactory
implements FlowableWorkerContainerFactory<WorkerJobListenerContainer> {
    protected ExternalWorkerClient externalWorkerClient;
    protected Duration pollingInterval;
    protected Integer concurrency;
    protected Duration lockDuration;
    protected Integer numberOfTasks;
    protected Integer numberOfRetries;

    public void setExternalWorkerClient(ExternalWorkerClient externalWorkerClient) {
        this.externalWorkerClient = externalWorkerClient;
    }

    public void setPollingInterval(Duration pollingInterval) {
        Assert.notNull((Object)pollingInterval, (String)"pollingInterval must not be null");
        Assert.state((!pollingInterval.isNegative() && !pollingInterval.isZero() ? 1 : 0) != 0, (String)"pollingInterval must be positive");
        this.pollingInterval = pollingInterval;
    }

    public void setConcurrency(Integer concurrency) {
        Assert.isTrue((concurrency == null || concurrency > 0 ? 1 : 0) != 0, (String)"concurrency must be greater than 0");
        this.concurrency = concurrency;
    }

    public void setLockDuration(Duration lockDuration) {
        Assert.state((lockDuration == null || !lockDuration.isNegative() && !lockDuration.isZero() ? 1 : 0) != 0, (String)"lockDuration must be positive");
        this.lockDuration = lockDuration;
    }

    public void setNumberOfTasks(Integer numberOfTasks) {
        Assert.state((numberOfTasks == null || numberOfTasks > 0 ? 1 : 0) != 0, (String)"numberOfTasks should be greater than 0");
        this.numberOfTasks = numberOfTasks;
    }

    public void setNumberOfRetries(Integer numberOfRetries) {
        Assert.state((numberOfRetries == null || numberOfRetries > 0 ? 1 : 0) != 0, (String)"numberOfTasks should be greater than 0");
        this.numberOfRetries = numberOfRetries;
    }

    @Override
    public WorkerJobListenerContainer createWorkerContainer(FlowableWorkerEndpoint endpoint) {
        WorkerJobListenerContainer container = new WorkerJobListenerContainer(this.externalWorkerClient);
        if (this.concurrency != null) {
            container.setConcurrency(this.concurrency);
        }
        if (this.pollingInterval != null) {
            container.setPollingInterval(this.pollingInterval);
        }
        if (this.lockDuration != null) {
            container.setLockDuration(this.lockDuration);
        }
        if (this.numberOfTasks != null) {
            container.setNumberOfTasks(this.numberOfTasks);
        }
        if (this.numberOfRetries != null) {
            container.setNumberOfRetries(this.numberOfRetries);
        }
        endpoint.setupWorkerContainer(container);
        return container;
    }
}

