/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.config;

import java.util.ArrayList;
import java.util.List;
import org.flowable.external.worker.config.FlowableWorkerContainerFactory;
import org.flowable.external.worker.config.FlowableWorkerEndpoint;
import org.flowable.external.worker.config.FlowableWorkerEndpointRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.Assert;

public class FlowableWorkerEndpointRegistrar
implements BeanFactoryAware,
InitializingBean {
    protected FlowableWorkerEndpointRegistry endpointRegistry;
    protected MessageHandlerMethodFactory messageHandlerMethodFactory;
    protected FlowableWorkerContainerFactory<?> containerFactory;
    protected String containerFactoryBeanName;
    protected BeanFactory beanFactory;
    protected final List<FlowableWorkerEndpointDescriptor> endpointDescriptors;
    protected boolean startImmediately;
    protected Object mutex;

    public FlowableWorkerEndpointRegistrar() {
        this.mutex = this.endpointDescriptors = new ArrayList<FlowableWorkerEndpointDescriptor>();
    }

    public void setEndpointRegistry(FlowableWorkerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public FlowableWorkerEndpointRegistry getEndpointRegistry() {
        return this.endpointRegistry;
    }

    public void setMessageHandlerMethodFactory(@Nullable MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    @Nullable
    public MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    public void setContainerFactory(FlowableWorkerContainerFactory<?> containerFactory) {
        this.containerFactory = containerFactory;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            this.mutex = cbf.getSingletonMutex();
        }
    }

    public void afterPropertiesSet() {
        this.registerAllEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAllEndpoints() {
        Assert.state((this.endpointRegistry != null ? 1 : 0) != 0, (String)"No FlowableWorkerEndpointRegistry set");
        Object object = this.mutex;
        synchronized (object) {
            for (FlowableWorkerEndpointDescriptor descriptor : this.endpointDescriptors) {
                this.endpointRegistry.registerWorkerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor));
            }
            this.startImmediately = true;
        }
    }

    protected FlowableWorkerContainerFactory<?> resolveContainerFactory(FlowableWorkerEndpointDescriptor descriptor) {
        if (descriptor.containerFactory != null) {
            return descriptor.containerFactory;
        }
        if (this.containerFactory != null) {
            return this.containerFactory;
        }
        if (this.containerFactoryBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            this.containerFactory = (FlowableWorkerContainerFactory)this.beanFactory.getBean(this.containerFactoryBeanName, FlowableWorkerContainerFactory.class);
            return this.containerFactory;
        }
        throw new IllegalStateException("Could not resolve the " + FlowableWorkerContainerFactory.class.getSimpleName() + " to use for [" + descriptor.endpoint + "] no factory was given and no default is set.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEndpoint(FlowableWorkerEndpoint endpoint, @Nullable FlowableWorkerContainerFactory<?> factory) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.hasText((String)endpoint.getId(), (String)"Endpoint id must be set");
        FlowableWorkerEndpointDescriptor descriptor = new FlowableWorkerEndpointDescriptor(endpoint, factory);
        Object object = this.mutex;
        synchronized (object) {
            if (this.startImmediately) {
                Assert.state((this.endpointRegistry != null ? 1 : 0) != 0, (String)"No FlowableWorkerEndpointRegistry set");
                this.endpointRegistry.registerWorkerContainer(descriptor.endpoint, this.resolveContainerFactory(descriptor), true);
            } else {
                this.endpointDescriptors.add(descriptor);
            }
        }
    }

    public void registerEndpoint(FlowableWorkerEndpoint endpoint) {
        this.registerEndpoint(endpoint, null);
    }

    protected static class FlowableWorkerEndpointDescriptor {
        public final FlowableWorkerEndpoint endpoint;
        public final FlowableWorkerContainerFactory<?> containerFactory;

        public FlowableWorkerEndpointDescriptor(FlowableWorkerEndpoint endpoint, FlowableWorkerContainerFactory<?> containerFactory) {
            this.endpoint = endpoint;
            this.containerFactory = containerFactory;
        }
    }
}

