/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.flowable.external.worker.config.FlowableWorkerContainerFactory;
import org.flowable.external.worker.config.FlowableWorkerEndpoint;
import org.flowable.external.worker.worker.FlowableWorkerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class FlowableWorkerEndpointRegistry
implements DisposableBean,
SmartLifecycle,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, FlowableWorkerContainer> workerContainers = new ConcurrentHashMap<String, FlowableWorkerContainer>();
    protected int phase = Integer.MAX_VALUE;
    protected ApplicationContext applicationContext;
    protected boolean contextRefreshed;
    private volatile boolean running;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            this.contextRefreshed = true;
        }
    }

    @Nullable
    public FlowableWorkerContainer getWorkerContainer(String id) {
        Assert.notNull((Object)id, (String)"Container identifier must not be null");
        return this.workerContainers.get(id);
    }

    public Set<String> getWorkerContainerIds() {
        return Collections.unmodifiableSet(this.workerContainers.keySet());
    }

    public Collection<FlowableWorkerContainer> getWorkerContainers() {
        return Collections.unmodifiableCollection(this.workerContainers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWorkerContainer(FlowableWorkerEndpoint endpoint, FlowableWorkerContainerFactory<?> factory, boolean startImmediately) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.notNull(factory, (String)"Factory must not be null");
        String id = endpoint.getId();
        Assert.hasText((String)id, (String)"Endpoint id must be set");
        Map<String, FlowableWorkerContainer> map = this.workerContainers;
        synchronized (map) {
            if (this.workerContainers.containsKey(id)) {
                throw new IllegalStateException("Another endpoint is already registered with id '" + id + "'");
            }
            FlowableWorkerContainer container = this.createWorkerContainer(endpoint, factory);
            this.workerContainers.put(id, container);
            if (startImmediately) {
                this.startIfNecessary(container);
            }
        }
    }

    public void registerWorkerContainer(FlowableWorkerEndpoint endpoint, FlowableWorkerContainerFactory<?> factory) {
        this.registerWorkerContainer(endpoint, factory, false);
    }

    protected FlowableWorkerContainer createWorkerContainer(FlowableWorkerEndpoint endpoint, FlowableWorkerContainerFactory<?> factory) {
        int containerPhase;
        Object workerContainer = factory.createWorkerContainer(endpoint);
        if (workerContainer instanceof InitializingBean) {
            InitializingBean initializingBean = (InitializingBean)workerContainer;
            try {
                initializingBean.afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Failed to initialize worker container", (Throwable)ex);
            }
        }
        if ((containerPhase = workerContainer.getPhase()) < Integer.MAX_VALUE) {
            if (this.phase < Integer.MAX_VALUE && this.phase != containerPhase) {
                throw new IllegalStateException("Encountered phase mismatch between container factory definitions: " + this.phase + " vs " + containerPhase);
            }
            this.phase = workerContainer.getPhase();
        }
        return workerContainer;
    }

    public int getPhase() {
        return this.phase;
    }

    public void start() {
        for (FlowableWorkerContainer workerContainer : this.getWorkerContainers()) {
            this.startIfNecessary(workerContainer);
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        for (FlowableWorkerContainer workerContainer : this.getWorkerContainers()) {
            workerContainer.stop();
        }
    }

    public void stop(Runnable callback) {
        this.running = false;
        Collection<FlowableWorkerContainer> workerContainers = this.getWorkerContainers();
        if (!workerContainers.isEmpty()) {
            AggregatingCallback aggregatingCallback = new AggregatingCallback(workerContainers.size(), callback);
            for (FlowableWorkerContainer workerContainer : workerContainers) {
                if (workerContainer.isRunning()) {
                    workerContainer.stop(aggregatingCallback);
                    continue;
                }
                aggregatingCallback.run();
            }
        } else {
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void startIfNecessary(FlowableWorkerContainer workerContainer) {
        if (this.contextRefreshed || workerContainer.isAutoStartup()) {
            workerContainer.start();
        }
    }

    public void destroy() {
        for (FlowableWorkerContainer workerContainer : this.getWorkerContainers()) {
            if (!(workerContainer instanceof DisposableBean)) continue;
            DisposableBean disposableBean = (DisposableBean)workerContainer;
            try {
                disposableBean.destroy();
            }
            catch (Throwable ex) {
                this.logger.warn("Failed to destroy worker container", ex);
            }
        }
    }

    private static class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        public AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() == 0) {
                this.finishCallback.run();
            }
        }
    }
}

