/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.config;

import java.lang.reflect.Method;
import org.flowable.external.worker.FlowableWorkerJobListener;
import org.flowable.external.worker.config.AbstractFlowableWorkerEndpoint;
import org.flowable.external.worker.listener.adapter.MessagingWorkerJobListenerAdapter;
import org.flowable.external.worker.worker.FlowableWorkerContainer;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class MethodFlowableWorkerEndpoint
extends AbstractFlowableWorkerEndpoint {
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    @Override
    protected FlowableWorkerJobListener createWorkerJobListener(FlowableWorkerContainer container) {
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create worker job listener - MessageHandlerMethodFactory not set");
        Object bean = this.getBean();
        Method method = this.getMethod();
        Assert.state((bean != null && method != null ? 1 : 0) != 0, (String)"No bean+method set on endpoint");
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(bean, method);
        return new MessagingWorkerJobListenerAdapter(invocableHandlerMethod);
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append('\'').append(" | method='").append(this.method).append('\'');
    }
}

