/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.listener;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.flowable.external.client.AcquiredExternalWorkerJob;
import org.flowable.external.client.ExternalWorkerClient;
import org.flowable.external.client.ExternalWorkerJobCompletionBuilder;
import org.flowable.external.client.ExternalWorkerJobFailureBuilder;
import org.flowable.external.worker.FlowableWorkerException;
import org.flowable.external.worker.FlowableWorkerJobListener;
import org.flowable.external.worker.WorkerContext;
import org.flowable.external.worker.WorkerContextAwareFlowableWorkerJobListener;
import org.flowable.external.worker.WorkerResult;
import org.flowable.external.worker.WorkerResultBuilder;
import org.flowable.external.worker.worker.FlowableWorkerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WorkerJobListenerContainer
implements FlowableWorkerContainer,
BeanNameAware {
    private static final int DEFAULT_SLEEP_INTERVAL = 100;
    private static final int SMALL_SLEEP_INTERVAL = 10;
    private static final long SMALL_INTERVAL_THRESHOLD = 500L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<AsyncTaskExecutor> executors = new ArrayList<AsyncTaskExecutor>();
    protected final List<CompletableFuture<Void>> runningJobs = new ArrayList<CompletableFuture<Void>>();
    protected final Object lifecycleMonitor = new Object();
    protected volatile boolean running = false;
    protected String beanName;
    protected int phase = Integer.MAX_VALUE;
    protected int concurrency = 1;
    protected int shutdownTimeout = 10000;
    protected String topic;
    protected Duration lockDuration = Duration.ofMinutes(5L);
    protected int numberOfRetries = 5;
    protected int numberOfTasks = 1;
    protected Duration pollingInterval = Duration.ofSeconds(10L);
    protected FlowableWorkerJobListener workerJobListener;
    protected final ExternalWorkerClient externalWorkerClient;

    public WorkerJobListenerContainer(ExternalWorkerClient externalWorkerClient) {
        Assert.notNull((Object)externalWorkerClient, (String)"externalWorkerClient cannot be null");
        this.externalWorkerClient = externalWorkerClient;
    }

    @Override
    public void setupWorkerJobListener(FlowableWorkerJobListener workerJobListener) {
        this.workerJobListener = workerJobListener;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                return;
            }
            Assert.notNull((Object)this.workerJobListener, (String)("A " + FlowableWorkerJobListener.class.getName() + " implementation must be provided"));
            Assert.notNull((Object)this.topic, (String)"A topic must be provided");
            this.running = true;
            String beanName = this.beanName == null ? "worker" : this.beanName;
            for (int i = 0; i < this.concurrency; ++i) {
                SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor(beanName + "-" + (i + 1) + "-C-");
                this.executors.add((AsyncTaskExecutor)executor);
                this.runningJobs.add(executor.submitCompletable((Runnable)((Object)new ListenerConsumer(i + 1))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.doStop(() -> {});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.doStop(callback);
            } else {
                callback.run();
            }
        }
    }

    protected void doStop(Runnable callback) {
        this.running = false;
        if (!this.runningJobs.isEmpty()) {
            try {
                CompletableFuture.allOf((CompletableFuture[])this.runningJobs.toArray(CompletableFuture[]::new)).get(this.shutdownTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread has been interrupted", ex);
            }
            catch (ExecutionException e) {
                this.logger.error("Exception during shutdown of running workers", (Throwable)e);
            }
            catch (TimeoutException e) {
                this.logger.error("Running jobs did not finish within the configured shutdown {}", (Object)Duration.ofMillis(this.shutdownTimeout));
            }
        }
        this.runningJobs.clear();
        this.executors.clear();
        callback.run();
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        Assert.isTrue((concurrency > 0 ? 1 : 0) != 0, (String)"concurrency must be greater than 0");
        this.concurrency = concurrency;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        Assert.notNull((Object)topic, (String)"topic must not be null");
        this.topic = topic;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public void setLockDuration(Duration lockDuration) {
        Assert.notNull((Object)lockDuration, (String)"lockDuration must not be null");
        Assert.state((!lockDuration.isNegative() && !lockDuration.isZero() ? 1 : 0) != 0, (String)"lockDuration must be positive");
        this.lockDuration = lockDuration;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        Assert.state((numberOfRetries > 0 ? 1 : 0) != 0, (String)"numberOfRetries must be greater than 0");
        this.numberOfRetries = numberOfRetries;
    }

    public int getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public void setNumberOfTasks(int numberOfTasks) {
        Assert.state((numberOfTasks > 0 ? 1 : 0) != 0, (String)"numberOfTasks must be greater than 0");
        this.numberOfTasks = numberOfTasks;
    }

    public Duration getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(Duration pollingInterval) {
        Assert.notNull((Object)pollingInterval, (String)"pollingInterval must not be null");
        Assert.state((!pollingInterval.isNegative() && !pollingInterval.isZero() ? 1 : 0) != 0, (String)"pollingInterval must be positive");
        this.pollingInterval = pollingInterval;
    }

    protected class ListenerConsumer
    implements SchedulingAwareRunnable {
        protected final int index;

        protected ListenerConsumer(int index) {
            this.index = index;
        }

        public boolean isLongLived() {
            return true;
        }

        public void run() {
            while (WorkerJobListenerContainer.this.isRunning()) {
                try {
                    this.pollAndInvoke();
                }
                catch (Error e) {
                    WorkerJobListenerContainer.this.logger.error("Stopping container due to an Error", (Throwable)e);
                    throw e;
                }
                catch (Exception ex) {
                    WorkerJobListenerContainer.this.logger.error("Consumer exception", (Throwable)ex);
                    this.doIdle();
                }
            }
        }

        protected void pollAndInvoke() {
            WorkerJobListenerContainer.this.logger.debug("Polling for jobs");
            List<AcquiredExternalWorkerJob> jobs = this.doPoll();
            WorkerJobListenerContainer.this.logger.debug("Found {} jobs", (Object)jobs.size());
            this.invokeIfHasJobs(jobs);
        }

        protected List<AcquiredExternalWorkerJob> doPoll() {
            return WorkerJobListenerContainer.this.externalWorkerClient.createJobAcquireBuilder().topic(WorkerJobListenerContainer.this.topic).lockDuration(WorkerJobListenerContainer.this.lockDuration).numberOfRetries(WorkerJobListenerContainer.this.numberOfRetries).numberOfTasks(WorkerJobListenerContainer.this.numberOfTasks).acquireAndLock();
        }

        protected void invokeIfHasJobs(List<AcquiredExternalWorkerJob> jobs) {
            if (!jobs.isEmpty()) {
                this.invokeListener(jobs);
            } else {
                this.doIdle();
            }
        }

        protected void doIdle() {
            try {
                long interval = WorkerJobListenerContainer.this.pollingInterval.toMillis();
                WorkerJobListenerContainer.this.logger.debug("Waiting for {}ms before polling again", (Object)interval);
                long timeout = System.currentTimeMillis() + interval;
                long sleepInterval = interval > 500L ? 100L : 10L;
                do {
                    Thread.sleep(sleepInterval);
                } while (WorkerJobListenerContainer.this.isRunning() && System.currentTimeMillis() < timeout);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Consumer Thread [" + this + "] has been interrupted", ex);
            }
        }

        protected void invokeListener(List<AcquiredExternalWorkerJob> jobs) {
            for (AcquiredExternalWorkerJob job : jobs) {
                if (!WorkerJobListenerContainer.this.isRunning()) break;
                this.doInvokeOnListener(job);
            }
        }

        protected void doInvokeOnListener(AcquiredExternalWorkerJob job) {
            block11: {
                WorkerJobListenerContainer.this.logger.debug("Invoking job {} on listener {}", (Object)job, (Object)WorkerJobListenerContainer.this.workerJobListener);
                try {
                    WorkerContextImpl workerContext = new WorkerContextImpl(job);
                    FlowableWorkerJobListener flowableWorkerJobListener = WorkerJobListenerContainer.this.workerJobListener;
                    if (flowableWorkerJobListener instanceof WorkerContextAwareFlowableWorkerJobListener) {
                        WorkerContextAwareFlowableWorkerJobListener contextAwareFlowableWorkerJobListener = (WorkerContextAwareFlowableWorkerJobListener)flowableWorkerJobListener;
                        contextAwareFlowableWorkerJobListener.onAcquiredJob(job, workerContext);
                    } else {
                        WorkerJobListenerContainer.this.workerJobListener.onAcquiredJob(job);
                    }
                    WorkerResult result = workerContext.result;
                    if (result == null) {
                        WorkerJobListenerContainer.this.externalWorkerClient.createCompletionBuilder(job).complete();
                        break block11;
                    }
                    if (result instanceof WorkerSuccessResultImpl) {
                        WorkerSuccessResultImpl success = (WorkerSuccessResultImpl)result;
                        success.complete();
                        break block11;
                    }
                    if (result instanceof WorkerFailureResultImpl) {
                        WorkerFailureResultImpl failure = (WorkerFailureResultImpl)result;
                        failure.failureBuilder.fail();
                        break block11;
                    }
                    throw new IllegalStateException("Received an unknown WorkerResult " + result);
                }
                catch (FlowableWorkerException ex) {
                    Duration retryTimeout;
                    int retries;
                    ExternalWorkerJobFailureBuilder failureBuilder = WorkerJobListenerContainer.this.externalWorkerClient.createFailureBuilder(job).message(ex.getMessage());
                    String errorDetails = ex.getErrorDetails();
                    if (StringUtils.hasText((String)errorDetails)) {
                        failureBuilder.details(errorDetails);
                    }
                    if ((retries = ex.getRetries()) > 0) {
                        failureBuilder.retries(retries);
                    }
                    if ((retryTimeout = ex.getRetryTimeout()) != null) {
                        failureBuilder.retryTimeout(retryTimeout);
                    }
                    failureBuilder.fail();
                }
                catch (Exception ex) {
                    WorkerJobListenerContainer.this.externalWorkerClient.createFailureBuilder(job).error(ex).fail();
                }
            }
        }

        public String toString() {
            return "FlowableWorkerJobListenerContainer.ListenerConsumer [\ntopic=" + WorkerJobListenerContainer.this.topic + "\nconsumerIndex=" + this.index + "\n]";
        }
    }

    static class WorkerFailureResultImpl
    implements WorkerResult.Failure {
        protected final ExternalWorkerJobFailureBuilder failureBuilder;

        WorkerFailureResultImpl(ExternalWorkerJobFailureBuilder failureBuilder) {
            this.failureBuilder = failureBuilder;
        }

        @Override
        public WorkerResult.Failure error(Exception exception) {
            this.failureBuilder.error(exception);
            return this;
        }

        @Override
        public WorkerResult.Failure message(String message) {
            this.failureBuilder.message(message);
            return this;
        }

        @Override
        public WorkerResult.Failure details(String details) {
            this.failureBuilder.details(details);
            return this;
        }

        @Override
        public WorkerResult.Failure retries(int retries) {
            this.failureBuilder.retries(retries);
            return this;
        }

        @Override
        public WorkerResult.Failure retryTimeout(Duration retryTimeout) {
            this.failureBuilder.retryTimeout(retryTimeout);
            return this;
        }
    }

    static class WorkerSuccessResultImpl
    implements WorkerResult.Success {
        protected final ExternalWorkerJobCompletionBuilder completionBuilder;
        protected final Consumer<ExternalWorkerJobCompletionBuilder> completionBuilderFinisher;

        WorkerSuccessResultImpl(ExternalWorkerJobCompletionBuilder completionBuilder, Consumer<ExternalWorkerJobCompletionBuilder> completionBuilderFinisher) {
            this.completionBuilder = completionBuilder;
            this.completionBuilderFinisher = completionBuilderFinisher;
        }

        @Override
        public WorkerResult.Success variable(String name, String value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, Short value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, Integer value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, Long value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, Double value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, Boolean value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, Date value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, Instant value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, LocalDate value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, LocalDateTime value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success variable(String name, JsonNode value) {
            this.completionBuilder.variable(name, value);
            return this;
        }

        @Override
        public WorkerResult.Success convertAndAddJsonVariable(String name, Object value) {
            this.completionBuilder.convertAndAddJsonVariable(name, value);
            return this;
        }

        public void complete() {
            this.completionBuilderFinisher.accept(this.completionBuilder);
        }
    }

    class WorkerResultBuilderImpl
    implements WorkerResultBuilder {
        protected final AcquiredExternalWorkerJob job;

        WorkerResultBuilderImpl(AcquiredExternalWorkerJob job) {
            this.job = job;
        }

        @Override
        public WorkerResult.Success success() {
            return new WorkerSuccessResultImpl(WorkerJobListenerContainer.this.externalWorkerClient.createCompletionBuilder(this.job), ExternalWorkerJobCompletionBuilder::complete);
        }

        @Override
        public WorkerResult.Success bpmnError() {
            return new WorkerSuccessResultImpl(WorkerJobListenerContainer.this.externalWorkerClient.createCompletionBuilder(this.job), ExternalWorkerJobCompletionBuilder::bpmnError);
        }

        @Override
        public WorkerResult.Success bpmnError(String errorCode) {
            return new WorkerSuccessResultImpl(WorkerJobListenerContainer.this.externalWorkerClient.createCompletionBuilder(this.job), builder -> builder.bpmnError(errorCode));
        }

        @Override
        public WorkerResult.Success cmmnTerminate() {
            return new WorkerSuccessResultImpl(WorkerJobListenerContainer.this.externalWorkerClient.createCompletionBuilder(this.job), ExternalWorkerJobCompletionBuilder::cmmnTerminate);
        }

        @Override
        public WorkerResult.Failure failure() {
            return new WorkerFailureResultImpl(WorkerJobListenerContainer.this.externalWorkerClient.createFailureBuilder(this.job));
        }
    }

    class WorkerContextImpl
    implements WorkerContext {
        protected final AcquiredExternalWorkerJob job;
        protected WorkerResult result;

        WorkerContextImpl(AcquiredExternalWorkerJob job) {
            this.job = job;
        }

        @Override
        public WorkerResultBuilder createResultBuilder() {
            return new WorkerResultBuilderImpl(this.job);
        }

        @Override
        public void markSuccessful(WorkerResult.Success result) {
            if (result == null) {
                throw new IllegalArgumentException("success result is null");
            }
            if (!(result instanceof WorkerSuccessResultImpl)) {
                throw new IllegalArgumentException("Unsupported success result type " + result);
            }
            this.result = result;
        }

        @Override
        public void markFailed(WorkerResult.Failure result) {
            if (result == null) {
                throw new IllegalArgumentException("failure result is null");
            }
            if (!(result instanceof WorkerFailureResultImpl)) {
                throw new IllegalArgumentException("Unsupported failure result type " + result);
            }
            this.result = result;
        }
    }
}

