/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.worker.listener.adapter;

import org.flowable.external.client.AcquiredExternalWorkerJob;
import org.flowable.external.worker.FlowableWorkerException;
import org.flowable.external.worker.WorkerContext;
import org.flowable.external.worker.WorkerContextAwareFlowableWorkerJobListener;
import org.flowable.external.worker.WorkerResult;
import org.flowable.external.worker.listener.adapter.ListenerExceptionFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagingWorkerJobListenerAdapter
implements WorkerContextAwareFlowableWorkerJobListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final InvocableHandlerMethod handlerMethod;

    public MessagingWorkerJobListenerAdapter(InvocableHandlerMethod handlerMethod) {
        Assert.notNull((Object)handlerMethod, (String)"handlerMethod is null");
        this.handlerMethod = handlerMethod;
    }

    @Override
    public void onAcquiredJob(AcquiredExternalWorkerJob job, WorkerContext workerContext) {
        Message<?> message = this.toMessagingMessage(job);
        this.logger.debug("Processing [{}]", message);
        Object result = this.invokeHandler(job, message, workerContext);
        if (result != null) {
            this.handleResult(result, job, workerContext);
        } else {
            this.logger.trace("No result object given - no result to handle");
        }
    }

    protected Message<?> toMessagingMessage(AcquiredExternalWorkerJob job) {
        return MessageBuilder.withPayload((Object)job).build();
    }

    protected Object invokeHandler(AcquiredExternalWorkerJob job, Message<?> message, WorkerContext workerContext) {
        try {
            return this.handlerMethod.invoke(message, new Object[]{job, workerContext.createResultBuilder()});
        }
        catch (MessagingException ex) {
            throw new ListenerExceptionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with incoming message"), ex);
        }
        catch (FlowableWorkerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ListenerExceptionFailedException(this.createMessagingErrorMessage("Listener method '" + this.handlerMethod.getMethod().toGenericString() + "' threw exception"), ex);
        }
    }

    protected void handleResult(Object result, AcquiredExternalWorkerJob job, WorkerContext workerContext) {
        if (result instanceof WorkerResult.Success) {
            WorkerResult.Success success = (WorkerResult.Success)result;
            workerContext.markSuccessful(success);
        } else if (result instanceof WorkerResult.Failure) {
            WorkerResult.Failure failure = (WorkerResult.Failure)result;
            workerContext.markFailed(failure);
        }
    }

    protected String createMessagingErrorMessage(String description) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerMethod.getMethod() + "]\nBean [" + this.handlerMethod.getBean() + "]\n";
    }
}

