/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import org.fluentlenium.core.FluentAdapter;
import org.fluentlenium.core.FluentPage;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatchman;
import org.junit.runners.model.FrameworkMethod;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;

public abstract class FluentTest
extends FluentAdapter {
    private Mode snapshotMode = Mode.NEVER_TAKE_SNAPSHOT;
    private String snapshotPath;
    public Class classe = this.getClass();
    @Rule
    public TestName name = new TestName();
    @Rule
    public MethodRule watchman = new TestWatchman(){

        public void starting(FrameworkMethod method) {
            super.starting(method);
            FluentTest.this.initFluent(FluentTest.this.getDefaultDriver());
            FluentTest.this.initTest();
        }

        public void finished(FrameworkMethod method) {
            super.finished(method);
            if (FluentTest.this.getDriver() != null) {
                FluentTest.this.quit();
            }
        }

        public void failed(Throwable e, FrameworkMethod method) {
            if (FluentTest.this.snapshotMode == Mode.TAKE_SNAPSHOT_ON_FAIL) {
                FluentTest.this.takeScreenShot(FluentTest.this.snapshotPath + "/" + FluentTest.this.classe.getSimpleName() + "_" + method.getName() + ".png");
            }
        }
    };

    public void setSnapshotPath(String path) {
        this.snapshotPath = path;
    }

    public void setSnapshotMode(Mode mode) {
        this.snapshotMode = mode;
    }

    public WebDriver getDefaultDriver() {
        return new FirefoxDriver();
    }

    public static void assertAt(FluentPage fluent) {
        fluent.isAt();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Mode {
        TAKE_SNAPSHOT_ON_FAIL,
        NEVER_TAKE_SNAPSHOT;

    }
}

