/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.action.FillConstructor;
import org.fluentlenium.core.action.FluentDefaultActions;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchActions;
import org.fluentlenium.core.wait.FluentLeniumWait;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Fluent
implements SearchActions {
    private WebDriver driver;
    private Search search;
    private FluentLeniumWait wait;

    public Fluent(WebDriver driver) {
        this.driver = driver;
        this.search = new Search((SearchContext)driver);
        this.wait = new FluentLeniumWait(driver, this.search);
    }

    public Fluent() {
    }

    public void takeScreenShot() {
        this.takeScreenShot(new Date().getTime() + ".png");
    }

    public void takeScreenShot(String fileName) {
        File scrFile = (File)((TakesScreenshot)this.getDriver()).getScreenshotAs(OutputType.FILE);
        try {
            File destFile = new File(fileName);
            FileUtils.copyFile((File)scrFile, (File)destFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error when taking the snapshot", e);
        }
    }

    protected final void initFluent(WebDriver driver) {
        this.driver = driver;
        this.search = new Search((SearchContext)driver);
        if (driver != null) {
            this.wait = new FluentLeniumWait(driver, this.search);
        }
    }

    protected WebDriver getDriver() {
        return this.driver;
    }

    public FluentLeniumWait await() {
        return this.wait;
    }

    public String title() {
        return this.driver.getTitle();
    }

    public Set<Cookie> getCookies() {
        return this.driver.manage().getCookies();
    }

    public Cookie getCookie(String name) {
        return this.driver.manage().getCookieNamed(name);
    }

    public String url() {
        return this.driver.getCurrentUrl();
    }

    public String pageSource() {
        return this.driver.getPageSource();
    }

    public static void goTo(FluentPage page) {
        if (page == null) {
            throw new IllegalArgumentException("Page is mandatory");
        }
        page.go();
    }

    public void goTo(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Url is mandatory");
        }
        this.getDriver().get(url);
    }

    public void executeScript(String script) {
        ((JavascriptExecutor)this.driver).executeScript(script, new Object[0]);
    }

    public FluentList<FluentWebElement> $(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    public FluentWebElement $(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    @Override
    public FluentWebElement find(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    @Override
    public FluentWebElement findFirst(String name, Filter ... filters) {
        return this.search.findFirst(name, filters);
    }

    public FillConstructor fill(String cssSelector, Filter ... filters) {
        return new FillConstructor(cssSelector, this.getDriver(), filters);
    }

    public FillConstructor fill(FluentDefaultActions list, Filter ... filters) {
        return new FillConstructor(list, this.getDriver(), filters);
    }

    public void click(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).click();
    }

    public void clear(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).clear();
    }

    public void submit(String cssSelector, Filter ... filters) {
        this.$(cssSelector, filters).submit();
    }

    public List<String> text(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getTexts();
    }

    public List<String> value(String cssSelector, Filter ... filters) {
        return this.$(cssSelector, filters).getValues();
    }

    public void click(FluentDefaultActions fluentObject) {
        fluentObject.click();
    }

    public void clear(FluentDefaultActions fluentObject) {
        fluentObject.clear();
    }

    public void submit(FluentDefaultActions fluentObject) {
        fluentObject.submit();
    }
}

