/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.annotation.AjaxElement;
import org.fluentlenium.core.annotation.Page;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.exception.ConstructionException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentAdapter
extends Fluent {
    public FluentAdapter(WebDriver webDriver) {
        super(webDriver);
    }

    public FluentAdapter() {
    }

    protected void initTest() {
        Class<?> cls = null;
        try {
            cls = Class.forName(this.getClass().getName());
            for (Field field : cls.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Page.class)) continue;
                field.setAccessible(true);
                Class<?> clsField = field.getType();
                cls = Class.forName(clsField.getName());
                Object page = this.initClass(cls);
                field.set(this, page);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
    }

    public <T extends FluentPage> T createPage(Class<T> classOfPage) {
        return this.initClass(classOfPage);
    }

    protected <T extends FluentPage> T initClass(Class<T> cls) {
        FluentPage page = null;
        try {
            Field[] fields;
            Constructor<T> construct = cls.getDeclaredConstructor(new Class[0]);
            construct.setAccessible(true);
            page = (FluentPage)construct.newInstance(new Object[0]);
            Class<?> parent = Class.forName(Fluent.class.getName());
            Method m = parent.getDeclaredMethod("initFluent", WebDriver.class);
            m.setAccessible(true);
            m.invoke((Object)page, this.getDriver());
            for (Field fieldFromPage : fields = cls.getDeclaredFields()) {
                if (!FluentWebElement.class.isAssignableFrom(fieldFromPage.getType())) continue;
                fieldFromPage.setAccessible(true);
                AjaxElement elem = fieldFromPage.getAnnotation(AjaxElement.class);
                if (elem == null) {
                    FluentAdapter.proxyElement((ElementLocatorFactory)new DefaultElementLocatorFactory((SearchContext)this.getDriver()), page, fieldFromPage);
                    continue;
                }
                FluentAdapter.proxyElement((ElementLocatorFactory)new AjaxElementLocatorFactory(this.getDriver(), elem.timeOutInSeconds()), page, fieldFromPage);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructionException("No constructor found on class " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InstantiationException e) {
            throw new ConstructionException("Unable to instantiate " + (cls != null ? cls.getName() : " null"), e);
        }
        catch (InvocationTargetException e) {
            throw new ConstructionException("Cannot invoke method setDriver on " + (cls != null ? cls.getName() : " null"), e);
        }
        return (T)page;
    }

    private static void proxyElement(ElementLocatorFactory factory, Object page, Field field) {
        ElementLocator locator = factory.createLocator(field);
        if (locator == null) {
            return;
        }
        LocatingElementHandler handler = new LocatingElementHandler(locator);
        WebElement proxy = (WebElement)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{WebElement.class}, (InvocationHandler)handler);
        try {
            field.setAccessible(true);
            field.set(page, new FluentWebElement(proxy));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public WebDriver getDefaultDriver() {
        return new FirefoxDriver();
    }

    public static void assertAt(FluentPage fluent) {
        fluent.isAt();
    }

    public void quit() {
        this.getDriver().quit();
    }
}

