/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import org.fluentlenium.core.action.FluentDefaultActions;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchActions;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class FluentWebElement
implements FluentDefaultActions,
SearchActions {
    private final WebElement webElement;
    private final Search search;

    public FluentWebElement(WebElement webElement) {
        this.webElement = webElement;
        this.search = new Search((SearchContext)webElement);
    }

    public void click() {
        this.webElement.click();
    }

    public void clear() {
        this.webElement.clear();
    }

    public void submit() {
        this.webElement.submit();
    }

    public void text(String ... text) {
        this.webElement.clear();
        if (text.length != 0) {
            this.webElement.sendKeys(new CharSequence[]{text[0]});
        }
    }

    public String getName() {
        return this.webElement.getAttribute("name");
    }

    public String getAttribute(String attribute) {
        return this.webElement.getAttribute(attribute);
    }

    public String getId() {
        return this.webElement.getAttribute("id");
    }

    public String getText() {
        return this.webElement.getText();
    }

    public String getValue() {
        return this.webElement.getAttribute("value");
    }

    public boolean isDisplayed() {
        return this.webElement.isDisplayed();
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public boolean isSelected() {
        return this.webElement.isSelected();
    }

    public String getTagName() {
        return this.webElement.getTagName();
    }

    public Dimension getSize() {
        return this.webElement.getSize();
    }

    public FluentList find(String name, Filter ... filters) {
        return this.search.find(name, filters);
    }

    public FluentWebElement find(String name, Integer number, Filter ... filters) {
        return this.search.find(name, number, filters);
    }

    public FluentWebElement findFirst(String name, Filter ... filters) {
        return this.search.findFirst(name, filters);
    }
}

