/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import java.util.regex.Pattern;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.filter.matcher.ContainsMatcher;
import org.fluentlenium.core.filter.matcher.EndsWithMatcher;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.filter.matcher.Matcher;
import org.fluentlenium.core.filter.matcher.NotContainsMatcher;
import org.fluentlenium.core.filter.matcher.NotEndsWithMatcher;
import org.fluentlenium.core.filter.matcher.NotStartsWithMatcher;
import org.fluentlenium.core.filter.matcher.StartsWithMatcher;
import org.fluentlenium.core.wait.FluentWaitBuilder;

public class FluentLeniumWaitBuilder {
    FluentWaitBuilder fluentLeniumWait;
    String attribute;

    public FluentLeniumWaitBuilder(FluentWaitBuilder fluentWaitBuilder, FilterType filterType) {
        this.fluentLeniumWait = fluentWaitBuilder;
        this.attribute = filterType.name();
    }

    public FluentLeniumWaitBuilder(FluentWaitBuilder fluentWaitBuilder, String attribute) {
        this.fluentLeniumWait = fluentWaitBuilder;
        this.attribute = attribute;
    }

    public FluentWaitBuilder equalTo(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EqualMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder contains(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new ContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder contains(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new ContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder startsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder startsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder endsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder endsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder notContains(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder notContains(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder notStartsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder notStartsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder notEndsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitBuilder notEndsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }
}

