/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.FluentWaitBuilder;
import org.fluentlenium.core.wait.WaitMessage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentSizeBuilder {
    String selector;
    private FluentWait wait;
    private Search search;
    private List<Filter> filters = new ArrayList<Filter>();

    public FluentSizeBuilder(Search search, FluentWait fluentWait, String selector, List<Filter> filters) {
        this.selector = selector;
        this.wait = fluentWait;
        this.search = search;
        this.filters = filters;
    }

    public void equalTo(final int size) {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                return FluentSizeBuilder.this.getSize() == size;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.equalToMessage(this.selector, size));
    }

    public void notEqualTo(final int size) {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                return FluentSizeBuilder.this.getSize() != size;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.notEqualToMessage(this.selector, size));
    }

    public void lessThan(final int size) {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                return FluentSizeBuilder.this.getSize() < size;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.lessThanMessage(this.selector, size));
    }

    public void lessThanOrEqualTo(final int size) {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                return FluentSizeBuilder.this.getSize() <= size;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.lessThanOrEqualToMessage(this.selector, size));
    }

    public void greaterThan(final int size) {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                return FluentSizeBuilder.this.getSize() > size;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.greatherThanMessage(this.selector, size));
    }

    public void greaterThanOrEqualTo(final int size) {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                return FluentSizeBuilder.this.getSize() >= size;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.greatherThanOrEqualToMessage(this.selector, size));
    }

    private int getSize() {
        if (this.filters.size() > 0) {
            return this.search.find(this.selector, this.filters.toArray(new Filter[this.filters.size()])).size();
        }
        return this.search.find(this.selector, new Filter[0]).size();
    }
}

