/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterConstructor;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.FluentLeniumWaitBuilder;
import org.fluentlenium.core.wait.FluentSizeBuilder;
import org.fluentlenium.core.wait.WaitMessage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentWaitBuilder {
    private List<Filter> filters = new ArrayList<Filter>();
    private Search search;
    private String selector;
    private FluentWait wait;

    public FluentWaitBuilder(Search search, FluentWait fluentWait, String selector) {
        this.selector = selector;
        this.wait = fluentWait;
        this.search = search;
    }

    public void hasAttribute(final String attribute, final String value) {
        Predicate<WebDriver> hasAttribute = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                if (FluentWaitBuilder.this.filters.size() > 0) {
                    return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, FluentWaitBuilder.this.filters.toArray(new Filter[FluentWaitBuilder.this.filters.size()])).getAttributes(attribute).contains(value);
                }
                return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, new Filter[0]).getAttributes(attribute).contains(value);
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)hasAttribute, this.filters, WaitMessage.hasAttributeMessage(this.selector, attribute, value));
    }

    static void until(FluentWait wait, Predicate present, List<Filter> filters, String defaultMessage) {
        StringBuilder message = new StringBuilder(defaultMessage);
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                message.append(filter.toString());
            }
            message.append(" Filters : ");
        }
        wait.withMessage(message.toString()).until(present);
    }

    public void hasId(final String value) {
        Predicate<WebDriver> hasId = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                if (FluentWaitBuilder.this.filters.size() > 0) {
                    return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, FluentWaitBuilder.this.filters.toArray(new Filter[FluentWaitBuilder.this.filters.size()])).getIds().contains(value);
                }
                return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, new Filter[0]).getIds().contains(value);
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)hasId, this.filters, WaitMessage.hasIdMessage(this.selector, value));
    }

    public void hasName(final String value) {
        Predicate<WebDriver> hasName = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                if (FluentWaitBuilder.this.filters.size() > 0) {
                    return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, FluentWaitBuilder.this.filters.toArray(new Filter[FluentWaitBuilder.this.filters.size()])).getNames().contains(value);
                }
                return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, new Filter[0]).getNames().contains(value);
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)hasName, this.filters, WaitMessage.hasNameMessage(this.selector, value));
    }

    public FluentSizeBuilder hasSize() {
        return new FluentSizeBuilder(this.search, this.wait, this.selector, this.filters);
    }

    public void hasSize(final int size) {
        Predicate<WebDriver> hasSize = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                int size1 = FluentWaitBuilder.this.filters.size() > 0 ? FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, FluentWaitBuilder.this.filters.toArray(new Filter[FluentWaitBuilder.this.filters.size()])).size() : FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, new Filter[0]).size();
                return size1 == size;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)hasSize, this.filters, WaitMessage.hasSizeMessage(this.selector, size));
    }

    public void hasText(final String value) {
        Predicate<WebDriver> hasText = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                if (FluentWaitBuilder.this.filters.size() > 0) {
                    return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, FluentWaitBuilder.this.filters.toArray(new Filter[FluentWaitBuilder.this.filters.size()])).getTexts().contains(value);
                }
                return FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, new Filter[0]).getTexts().contains(value);
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)hasText, this.filters, WaitMessage.hasTextMessage(this.selector, value));
    }

    public void isPresent() {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                int size = FluentWaitBuilder.this.filters.size() > 0 ? FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, FluentWaitBuilder.this.filters.toArray(new Filter[FluentWaitBuilder.this.filters.size()])).size() : FluentWaitBuilder.this.search.find(FluentWaitBuilder.this.selector, new Filter[0]).size();
                return size > 0;
            }
        };
        FluentWaitBuilder.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.isPresentMessage(this.selector));
    }

    public FluentLeniumWaitBuilder with(String attribute) {
        return new FluentLeniumWaitBuilder(this, attribute);
    }

    public FluentLeniumWaitBuilder withId() {
        return new FluentLeniumWaitBuilder(this, FilterType.ID);
    }

    public FluentWaitBuilder withId(String value) {
        this.filters.add(FilterConstructor.withId(value));
        return this;
    }

    public FluentLeniumWaitBuilder withName() {
        return new FluentLeniumWaitBuilder(this, FilterType.NAME);
    }

    public FluentWaitBuilder withName(String value) {
        this.filters.add(FilterConstructor.withName(value));
        return this;
    }

    public FluentLeniumWaitBuilder withText() {
        return new FluentLeniumWaitBuilder(this, FilterType.TEXT);
    }

    public FluentWaitBuilder withText(String value) {
        this.filters.add(FilterConstructor.withText(value));
        return this;
    }

    void addFilter(Filter filter) {
        this.filters.add(filter);
    }
}

