/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fluentlenium.core.action.FluentDefaultActions;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.search.SearchActions;
import org.openqa.selenium.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentList<E extends FluentWebElement>
extends ArrayList<E>
implements FluentDefaultActions<FluentList>,
SearchActions {
    public FluentList(Collection<E> listFiltered) {
        super(listFiltered);
    }

    public E first() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Element not found");
        }
        return (E)((FluentWebElement)this.get(0));
    }

    @Override
    public FluentList click() {
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.click();
        }
        return this;
    }

    @Override
    public FluentList text(String ... with) {
        if (with.length > 0) {
            int id = 0;
            for (FluentWebElement fluentWebElement : this) {
                if (!fluentWebElement.isDisplayed()) continue;
                String value = with.length > id ? with[id++] : with[with.length - 1];
                if (!fluentWebElement.isEnabled()) continue;
                fluentWebElement.clear();
                fluentWebElement.text(value);
            }
        }
        return this;
    }

    public FluentList clearAll() {
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.clear();
        }
        return this;
    }

    @Override
    public void clear() {
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.clear();
        }
    }

    @Override
    public FluentList submit() {
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.submit();
        }
        return this;
    }

    public List<String> getValues() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getValue();
            }
        });
    }

    public List<String> getIds() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getId();
            }
        });
    }

    public List<String> getAttributes(final String attribute) {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getAttribute(attribute);
            }
        });
    }

    public List<String> getNames() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getName();
            }
        });
    }

    public List<String> getTexts() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getText();
            }
        });
    }

    public String getValue() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getValue();
        }
        return null;
    }

    public String getId() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getId();
        }
        return null;
    }

    public String getAttribute(String attribute) {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getAttribute(attribute);
        }
        return null;
    }

    public String getName() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getName();
        }
        return null;
    }

    public String getText() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getText();
        }
        return null;
    }

    public FluentList find(String name, Filter ... filters) {
        ArrayList finds = new ArrayList();
        for (FluentWebElement e : this) {
            finds.addAll(e.find(name, filters));
        }
        return new FluentList(finds);
    }

    public E find(String name, Integer number, Filter ... filters) {
        FluentList fluentList = this.find(name, filters);
        if (number >= fluentList.size()) {
            throw new NoSuchElementException("No such element with position :" + number + ". Number of elements available :" + fluentList.size());
        }
        return (E)((FluentWebElement)fluentList.get(number));
    }

    public E findFirst(String name, Filter ... filters) {
        return this.find(name, 0, filters);
    }
}

