/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterBuilder;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.filter.MatcherConstructor;
import org.fluentlenium.core.filter.matcher.ContainsWordMatcher;
import org.fluentlenium.core.filter.matcher.Matcher;

public final class FilterConstructor {
    private FilterConstructor() {
    }

    public static Filter buildFilter(String name, FilterType type, Class matcherType) {
        if (matcherType.equals(ContainsWordMatcher.class)) {
            return new Filter(FilterType.NAME, name);
        }
        return null;
    }

    public static Filter withName(String name) {
        return new Filter(FilterType.NAME, name);
    }

    public static Filter withId(String id) {
        return new Filter(FilterType.ID, id);
    }

    public static Filter withClass(String klass) {
        return new Filter(FilterType.CLASS, klass);
    }

    public static Filter withText(String text) {
        return new Filter(FilterType.TEXT, MatcherConstructor.equal(text));
    }

    public static FilterBuilder with(String attribute) {
        return new FilterBuilder(attribute);
    }

    public static FilterBuilder withName() {
        return new FilterBuilder(FilterType.NAME);
    }

    public static FilterBuilder withId() {
        return new FilterBuilder(FilterType.ID);
    }

    public static FilterBuilder withClass() {
        return new FilterBuilder(FilterType.CLASS);
    }

    public static FilterBuilder withText() {
        return new FilterBuilder(FilterType.TEXT);
    }

    @Deprecated
    public static Filter withName(Matcher matcher) {
        return new Filter(FilterType.NAME, matcher);
    }

    @Deprecated
    public static Filter withId(Matcher matcher) {
        return new Filter(FilterType.ID, matcher);
    }

    @Deprecated
    public static Filter withText(Matcher matcher) {
        return new Filter(FilterType.TEXT, matcher);
    }

    @Deprecated
    public static Filter with(String customAttribute, Matcher matcher) {
        return new Filter(customAttribute, matcher);
    }

    @Deprecated
    public static Filter with(String customAttribute, String matcher) {
        return new Filter(customAttribute, matcher);
    }
}

