/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.fluentlenium.core.events.AbstractAnnotationListener;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.core.events.NavigateAllListener;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebDriver;

class AnnotationNavigateAllListener
extends AbstractAnnotationListener
implements NavigateAllListener {
    private final Method method;
    private final String annotationName;

    AnnotationNavigateAllListener(Method method, Object container, String annotationName, int priority) {
        super(container, priority);
        this.method = method;
        this.annotationName = annotationName;
    }

    protected Function<Class<?>, Object> getArgsFunction(String url, WebDriver driver, NavigateAllListener.Direction direction) {
        return input -> {
            if (input.isAssignableFrom(String.class)) {
                return url;
            }
            if (input.isAssignableFrom(WebDriver.class)) {
                return driver;
            }
            if (input.isAssignableFrom(NavigateAllListener.Direction.class)) {
                return direction;
            }
            return null;
        };
    }

    @Override
    public void on(String url, WebDriver driver, NavigateAllListener.Direction direction) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(url, driver, direction), parameterTypes);
        try {
            ReflectionUtils.invoke(this.method, this.getContainer(), args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
    }
}

