/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import java.util.Collection;
import java.util.stream.Collectors;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.AttributeFilterPredicate;
import org.fluentlenium.core.filter.matcher.AbstractMatcher;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.search.SearchFilter;

public class AttributeFilter
implements SearchFilter {
    private final String attributeName;
    private final AbstractMatcher matcher;

    public AttributeFilter(String attributeName, String value) {
        this.attributeName = attributeName;
        this.matcher = new EqualMatcher(value);
    }

    public AttributeFilter(String customAttribute, AbstractMatcher matcher) {
        this.attributeName = customAttribute;
        this.matcher = matcher;
    }

    public String getAttribute() {
        return this.attributeName;
    }

    public AbstractMatcher getMatcher() {
        return this.matcher;
    }

    public String toString() {
        String matcherRepr;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("with ").append(this.getAttribute());
        String string = matcherRepr = this.matcher == null ? null : this.matcher.toString();
        if (matcherRepr != null) {
            stringBuilder.append(' ').append(matcherRepr).append(' ');
        }
        stringBuilder.append('\"').append(this.matcher.getValue()).append('\"');
        return stringBuilder.toString();
    }

    @Override
    public String getCssFilter() {
        String matcherAttribute;
        String string = matcherAttribute = this.matcher == null ? null : this.matcher.getMatcherSymbol();
        if (matcherAttribute == null) {
            matcherAttribute = "";
        }
        return "[" + this.getAttribute() + matcherAttribute + "=\"" + this.matcher.getValue() + "\"]";
    }

    @Override
    public boolean isCssFilterSupported() {
        return this.matcher != null && this.matcher.isCssFilterSupported() && !"text".equalsIgnoreCase(this.getAttribute()) && !"textContent".equalsIgnoreCase(this.getAttribute());
    }

    @Override
    public Collection<FluentWebElement> applyFilter(Collection<FluentWebElement> elements) {
        return elements.stream().filter(new AttributeFilterPredicate(this)).collect(Collectors.toList());
    }
}

