/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.inject;

import java.util.List;
import java.util.function.Supplier;
import org.fluentlenium.core.inject.InjectionAnnotations;
import org.fluentlenium.core.label.FluentLabelImpl;
import org.fluentlenium.core.label.FluentLabelProvider;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class InjectionElementLocator
implements ElementLocator,
FluentLabelProvider {
    private final SearchContext searchContext;
    private final boolean shouldCache;
    private final By by;
    private final boolean isFirst;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;
    private final FluentLabelImpl<InjectionElementLocator> label;

    public InjectionElementLocator(SearchContext searchContext, InjectionAnnotations annotations, boolean isFirst) {
        this.searchContext = searchContext;
        this.shouldCache = annotations.isLookupCached();
        this.by = annotations.buildBy();
        this.isFirst = isFirst;
        this.label = new FluentLabelImpl<InjectionElementLocator>(this, new Supplier<String>(){

            @Override
            public String get() {
                return InjectionElementLocator.this.by.toString() + (InjectionElementLocator.this.isFirst ? " (first)" : "");
            }
        });
        this.label.withLabel(annotations.getLabel());
        this.label.withLabelHint(annotations.getLabelHints());
    }

    private FluentLabelProvider getLabelProvider() {
        return this.label;
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        WebElement element = this.searchContext.findElement(this.by);
        if (this.shouldCache) {
            this.cachedElement = element;
        }
        return element;
    }

    public List<WebElement> findElements() {
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        List elements = this.searchContext.findElements(this.by);
        if (this.shouldCache) {
            this.cachedElementList = elements;
        }
        return elements;
    }

    public String toString() {
        return this.label.toString();
    }

    @Override
    public String getLabel() {
        return this.getLabelProvider().getLabel();
    }

    @Override
    public String[] getLabelHints() {
        return this.getLabelProvider().getLabelHints();
    }
}

