/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.fluentlenium.custom;

import java.util.List;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.fluentlenium.custom.FluentListSizeBuilder;
import org.fluentlenium.core.domain.FluentList;

public class FluentListAssert
extends GenericAssert<FluentListAssert, FluentList> {
    public FluentListAssert(FluentList<?> actual) {
        super(FluentListAssert.class, actual);
    }

    public FluentListAssert hasText(String textToFind) {
        List actualTexts = ((FluentList)this.actual).getTexts();
        for (String text : actualTexts) {
            if (!text.contains(textToFind)) continue;
            return this;
        }
        super.fail("No selected elements contains text: " + textToFind + " . Actual texts found : " + actualTexts);
        return this;
    }

    public FluentListAssert hasNotText(String textToFind) {
        List actualTexts = ((FluentList)this.actual).getTexts();
        for (String text : actualTexts) {
            if (!text.contains(textToFind)) continue;
            super.fail("At least one selected elements contains text: " + textToFind + " . Actual texts found : " + actualTexts);
        }
        return this;
    }

    public FluentListAssert hasSize(int expectedSize) {
        if (((FluentList)this.actual).size() != expectedSize) {
            super.fail("Expected size: " + expectedSize + ". Actual size: " + ((FluentList)this.actual).size() + ".");
        }
        return this;
    }

    public FluentListSizeBuilder hasSize() {
        return new FluentListSizeBuilder(((FluentList)this.actual).size(), this);
    }

    public FluentListAssert hasId(String idToFind) {
        List actualIds = ((FluentList)this.actual).getIds();
        if (!actualIds.contains(idToFind)) {
            super.fail("No selected elements has id: " + idToFind + " . Actual texts found : " + actualIds);
        }
        return this;
    }

    public FluentListAssert hasClass(String classToFind) {
        List actualClasses = ((FluentList)this.actual).getAttributes("class");
        if (!actualClasses.contains(classToFind)) {
            super.fail("No selected elements has class: " + classToFind + " . Actual classes found : " + actualClasses);
        }
        return this;
    }

    void internalFail(String reason) {
        super.fail(reason);
    }
}

