/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.freedesktop.gstreamer.BufferFlags;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.Meta;
import org.freedesktop.gstreamer.MiniObject;
import org.freedesktop.gstreamer.glib.NativeFlags;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GstBufferAPI;
import org.freedesktop.gstreamer.lowlevel.GstMetaPtr;

public class Buffer
extends MiniObject {
    public static final String GTYPE_NAME = "GstBuffer";
    private final GstBufferAPI.MapInfoStruct mapInfo = new GstBufferAPI.MapInfoStruct();
    private final GstBufferAPI.BufferStruct struct = new GstBufferAPI.BufferStruct(this.getRawPointer());

    public Buffer() {
        this(Natives.initializer(GstBufferAPI.GSTBUFFER_API.ptr_gst_buffer_new()));
    }

    public Buffer(int size) {
        this(Natives.initializer(Buffer.allocBuffer(size)));
    }

    Buffer(NativeObject.Initializer init) {
        super(init);
    }

    private static Pointer allocBuffer(int size) {
        Pointer ptr = GstBufferAPI.GSTBUFFER_API.ptr_gst_buffer_new_allocate(null, size, null);
        if (ptr == null) {
            throw new OutOfMemoryError("Could not allocate Buffer of size " + size);
        }
        return ptr;
    }

    public ByteBuffer map(boolean writable) {
        boolean ok = GstBufferAPI.GSTBUFFER_API.gst_buffer_map(this, this.mapInfo, writable ? 2 : 1);
        if (ok && this.mapInfo.data != null) {
            return this.mapInfo.data.getByteBuffer(0L, (long)this.mapInfo.size.intValue());
        }
        return null;
    }

    public void unmap() {
        GstBufferAPI.GSTBUFFER_API.gst_buffer_unmap(this, this.mapInfo);
    }

    public int getMemoryCount() {
        return GstBufferAPI.GSTBUFFER_API.gst_buffer_n_memory(this);
    }

    public long getDecodeTimestamp() {
        return (Long)this.struct.readField("dts");
    }

    public void setDecodeTimestamp(long val) {
        this.struct.writeField("dts", val);
    }

    public long getPresentationTimestamp() {
        return (Long)this.struct.readField("pts");
    }

    public void setPresentationTimestamp(long val) {
        this.struct.writeField("pts", val);
    }

    public long getDuration() {
        return (Long)this.struct.readField("duration");
    }

    public void setDuration(long val) {
        this.struct.writeField("duration", val);
    }

    public long getOffset() {
        return (Long)this.struct.readField("offset");
    }

    public void setOffset(long val) {
        this.struct.writeField("offset", val);
    }

    public long getOffsetEnd() {
        return (Long)this.struct.readField("offset_end");
    }

    public void setOffsetEnd(long val) {
        this.struct.writeField("offset_end", val);
    }

    @Gst.Since(minor=10)
    public EnumSet<BufferFlags> getFlags() {
        Gst.checkVersion(1, 10);
        int nativeInt = GstBufferAPI.GSTBUFFER_API.gst_buffer_get_flags(this);
        return NativeFlags.fromInt(BufferFlags.class, nativeInt);
    }

    public <T extends Meta> T getMeta(Meta.API<T> api) {
        GType apiType = api.getAPIGType();
        if (apiType == GType.INVALID) {
            return null;
        }
        GstMetaPtr ptr = GstBufferAPI.GSTBUFFER_API.gst_buffer_get_meta(this, apiType);
        if (ptr == null) {
            return null;
        }
        return (T)((Meta)Natives.objectFor(ptr, api.getImplClass(), false, false));
    }

    public Iterator<Meta> iterateMeta() {
        return new MetaIterator(this);
    }

    @Gst.Since(minor=14)
    public <T extends Meta> boolean hasMeta(Meta.API<T> api) {
        return this.getMetaCount(api) > 0;
    }

    @Gst.Since(minor=14)
    public <T extends Meta> int getMetaCount(Meta.API<T> api) {
        Gst.checkVersion(1, 14);
        GType apiType = api.getAPIGType();
        if (apiType == GType.INVALID) {
            return 0;
        }
        return GstBufferAPI.GSTBUFFER_API.gst_buffer_get_n_meta(this, apiType);
    }

    @Gst.Since(minor=10)
    public boolean setFlags(EnumSet<BufferFlags> flags) {
        Gst.checkVersion(1, 10);
        return GstBufferAPI.GSTBUFFER_API.gst_buffer_set_flags(this, NativeFlags.toInt(flags));
    }

    @Gst.Since(minor=10)
    public boolean unsetFlags(EnumSet<BufferFlags> flags) {
        Gst.checkVersion(1, 10);
        return GstBufferAPI.GSTBUFFER_API.gst_buffer_unset_flags(this, NativeFlags.toInt(flags));
    }

    private static class MetaIterator
    implements Iterator<Meta> {
        private final PointerByReference state = new PointerByReference();
        private final Buffer buffer;
        private Meta next;

        MetaIterator(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public Meta next() {
            if (!this.hasNext() || this.next == null) {
                throw new NoSuchElementException();
            }
            Meta m = this.next;
            this.next = null;
            return m;
        }

        private Meta getNext() {
            return Natives.objectFor(GstBufferAPI.GSTBUFFER_API.gst_buffer_iterate_meta(this.buffer, this.state), Meta.class, false, false);
        }
    }
}

