/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freedesktop.gstreamer.Fraction;
import org.freedesktop.gstreamer.Range;
import org.freedesktop.gstreamer.glib.GObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GValueAPI;
import org.freedesktop.gstreamer.lowlevel.GstStructureAPI;
import org.freedesktop.gstreamer.lowlevel.GstValueAPI;

public class Structure
extends NativeObject {
    public static final String GTYPE_NAME = "GstStructure";

    public Structure(String name) {
        this(new Handle(new GPointer(GstStructureAPI.GSTSTRUCTURE_API.ptr_gst_structure_new_empty(name)), true));
    }

    public Structure(String name, String firstFieldName, Object ... data) {
        this(new Handle(new GPointer(GstStructureAPI.GSTSTRUCTURE_API.ptr_gst_structure_new(name, firstFieldName, data)), true));
    }

    Structure(NativeObject.Initializer init) {
        this(new Handle(init.ptr, init.ownsHandle));
    }

    private Structure(Handle handle) {
        super(handle);
    }

    public Structure copy() {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_copy(this);
    }

    public boolean fixateNearestInteger(String field, Integer value) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_fixate_field_nearest_int(this, field, value);
    }

    public boolean getBoolean(String fieldName) {
        int[] val = new int[]{0};
        if (!GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_boolean(this, fieldName, val)) {
            throw new InvalidFieldException("boolean", fieldName);
        }
        return val[0] != 0;
    }

    public double getDouble(String fieldName) {
        double[] val = new double[]{0.0};
        if (!GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_double(this, fieldName, val)) {
            throw new InvalidFieldException("double", fieldName);
        }
        return val[0];
    }

    public double[] getDoubles(String fieldName) {
        return this.getDoubles(fieldName, null);
    }

    public double[] getDoubles(String fieldName, double[] array) {
        Object val = this.getValue(fieldName);
        if (val instanceof GValueAPI.GValueArray) {
            GValueAPI.GValueArray arr = (GValueAPI.GValueArray)((Object)val);
            int count = arr.getNValues();
            double[] values = array == null || array.length != count ? new double[count] : array;
            for (int i = 0; i < count; ++i) {
                GValueAPI.GValue gval = arr.nth(i);
                if (!gval.checkHolds(GType.DOUBLE)) {
                    throw new InvalidFieldException("doubles", fieldName);
                }
                values[i] = GValueAPI.GVALUE_API.g_value_get_double(gval);
            }
            return values;
        }
        if (Double.class.isInstance(val)) {
            double[] values = array == null || array.length != 1 ? new double[1] : array;
            values[0] = (Double)val;
            return values;
        }
        throw new InvalidFieldException("double", fieldName);
    }

    public int getFields() {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_n_fields(this);
    }

    public int getFourcc(String fieldName) {
        int[] val = new int[]{0};
        if (!GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_fourcc(this, fieldName, val)) {
            throw new InvalidFieldException("FOURCC", fieldName);
        }
        return val[0];
    }

    public String getFourccString(String fieldName) {
        int f = this.getFourcc(fieldName);
        byte[] b = new byte[]{(byte)(f >> 0 & 0xFF), (byte)(f >> 8 & 0xFF), (byte)(f >> 16 & 0xFF), (byte)(f >> 24 & 0xFF)};
        return new String(b);
    }

    public Fraction getFraction(String fieldName) {
        int[] numerator = new int[]{0};
        int[] denominator = new int[]{0};
        if (!GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_fraction(this, fieldName, numerator, denominator)) {
            throw new InvalidFieldException("fraction", fieldName);
        }
        return new Fraction(numerator[0], denominator[0]);
    }

    public int getInteger(String fieldName) {
        int[] val = new int[]{0};
        if (!GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_int(this, fieldName, val)) {
            throw new InvalidFieldException("integer", fieldName);
        }
        return val[0];
    }

    public int[] getIntegers(String fieldName) {
        return this.getIntegers(fieldName, null);
    }

    public int[] getIntegers(String fieldName, int[] array) {
        Object val = this.getValue(fieldName);
        if (val instanceof GValueAPI.GValueArray) {
            GValueAPI.GValueArray arr = (GValueAPI.GValueArray)((Object)val);
            int count = arr.getNValues();
            int[] values = array == null || array.length != count ? new int[count] : array;
            for (int i = 0; i < count; ++i) {
                GValueAPI.GValue gval = arr.nth(i);
                if (!gval.checkHolds(GType.INT)) {
                    throw new InvalidFieldException("integers", fieldName);
                }
                values[i] = GValueAPI.GVALUE_API.g_value_get_int(gval);
            }
            return values;
        }
        if (Integer.class.isInstance(val)) {
            int[] values = array == null || array.length != 1 ? new int[1] : array;
            values[0] = (Integer)val;
            return values;
        }
        throw new InvalidFieldException("integer", fieldName);
    }

    public void setName(String name) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set_name(this, name);
    }

    public String getName() {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_name(this);
    }

    public String getName(int i) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_nth_field_name(this, i);
    }

    public Range getRange(String fieldName) {
        GValueAPI.GValue val = GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_value(this, fieldName);
        if (val == null) {
            throw new InvalidFieldException("Range", fieldName);
        }
        return new Range(val);
    }

    public String getString(String fieldName) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_string(this, fieldName);
    }

    public Object getValue(String fieldName) {
        GValueAPI.GValue val = GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_value(this, fieldName);
        if (val == null) {
            throw new InvalidFieldException("Object", fieldName);
        }
        return val.getValue();
    }

    public <T> List<T> getValues(Class<T> type, String fieldName) {
        GValueAPI.GValue gValue = GstStructureAPI.GSTSTRUCTURE_API.gst_structure_get_value(this, fieldName);
        if (gValue == null) {
            throw new InvalidFieldException(type.getSimpleName(), fieldName);
        }
        GType gType = gValue.getType();
        if (gType.equals((Object)GstValueAPI.GSTVALUE_API.gst_value_list_get_type())) {
            int size = GstValueAPI.GSTVALUE_API.gst_value_list_get_size(gValue);
            ArrayList<T> values = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                Object o = GstValueAPI.GSTVALUE_API.gst_value_list_get_value(gValue, i).getValue();
                if (!type.isInstance(o)) {
                    throw new InvalidFieldException(type.getSimpleName(), fieldName);
                }
                values.add(type.cast(o));
            }
            return values;
        }
        Object val = gValue.getValue();
        if (val instanceof GValueAPI.GValueArray) {
            GValueAPI.GValueArray arr = (GValueAPI.GValueArray)((Object)val);
            int count = arr.getNValues();
            ArrayList<T> values = new ArrayList<T>(count);
            for (int i = 0; i < count; ++i) {
                Object o = arr.getValue(i);
                if (!type.isInstance(o)) {
                    throw new InvalidFieldException(type.getSimpleName(), fieldName);
                }
                values.add(type.cast(o));
            }
            return values;
        }
        if (type.isInstance(val)) {
            return Collections.singletonList(type.cast(val));
        }
        throw new InvalidFieldException(type.getSimpleName(), fieldName);
    }

    public boolean hasDoubleField(String fieldName) {
        return this.hasField(fieldName, GType.DOUBLE);
    }

    public boolean hasField(String fieldName) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_has_field(this, fieldName);
    }

    boolean hasField(String fieldName, GType fieldType) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_has_field_typed(this, fieldName, fieldType);
    }

    public boolean hasField(String fieldName, Class<?> fieldType) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_has_field_typed(this, fieldName, GType.valueOf(fieldType));
    }

    public boolean hasIntField(String fieldName) {
        return this.hasField(fieldName, GType.INT);
    }

    public boolean hasName(String name) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_has_name(this, name);
    }

    public boolean isEqual(Structure structure) {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_is_equal(this, structure);
    }

    public void removeField(String fieldName) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_remove_field(this, fieldName);
    }

    public void removeFields(String ... fieldNames) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_remove_fields(this, fieldNames);
    }

    public void setDouble(String field, Double value) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set(this, field, new Object[]{GType.DOUBLE, value});
    }

    public void setDoubleRange(String field, Double min, Double max) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set(this, field, new Object[]{GstValueAPI.GSTVALUE_API.gst_double_range_get_type(), min, max});
    }

    public void setFraction(String field, Integer numerator, Integer denominator) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set(this, field, new Object[]{GstValueAPI.GSTVALUE_API.gst_fraction_get_type(), numerator, denominator});
    }

    public void setInteger(String field, Integer value) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set(this, field, new Object[]{GType.INT, value});
    }

    public void setIntegerRange(String field, Integer min, Integer max) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set(this, field, new Object[]{GstValueAPI.GSTVALUE_API.gst_int_range_get_type(), min, max});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(String field, String typeName, GObject object) {
        GType realType;
        GType type = GType.valueOf(typeName);
        if (type == GType.INVALID) throw new IllegalArgumentException("Unknown GType name: " + typeName);
        if (object == null) throw new IllegalArgumentException("Null object provided");
        for (realType = GType.valueOf(object.getTypeName()); realType != GType.OBJECT && realType != type; realType = realType.getParentType()) {
        }
        if (realType != type) {
            throw new IllegalArgumentException("Provided instance of " + object.getTypeName() + " is not a " + typeName);
        }
        this.setValue(field, type, object);
    }

    void setPointer(String field, Pointer value) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set(this, field, new Object[]{GType.POINTER, value});
    }

    void setValue(String field, GType type, Object value) {
        GstStructureAPI.GSTSTRUCTURE_API.gst_structure_set(this, field, new Object[]{type, value});
    }

    @Override
    public String toString() {
        return GstStructureAPI.GSTSTRUCTURE_API.gst_structure_to_string(this);
    }

    public static Structure fromString(String data) {
        return new Structure(new Handle(new GPointer(GstStructureAPI.GSTSTRUCTURE_API.ptr_gst_structure_from_string(data, new PointerByReference())), true));
    }

    static Structure objectFor(Pointer ptr, boolean needRef, boolean ownsHandle) {
        return Natives.objectFor(ptr, Structure.class, needRef, ownsHandle);
    }

    private static final class Handle
    extends NativeObject.Handle {
        public Handle(GPointer ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GstStructureAPI.GSTSTRUCTURE_API.gst_structure_free(ptr.getPointer());
        }
    }

    public class InvalidFieldException
    extends RuntimeException {
        private static final long serialVersionUID = 864118748304334069L;

        public InvalidFieldException(String type, String fieldName) {
            super(String.format("Structure does not contain %s field '%s'", type, fieldName));
        }
    }
}

