/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.freedesktop.gstreamer.Bin;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.ElementFactory;
import org.freedesktop.gstreamer.Pad;
import org.freedesktop.gstreamer.glib.NativeEnum;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GType;
import org.freedesktop.gstreamer.lowlevel.GValueAPI;
import org.freedesktop.gstreamer.lowlevel.GstAPI;
import org.freedesktop.gstreamer.query.Query;

public class URIDecodeBin
extends Bin {
    public static final String GST_NAME = "uridecodebin";
    public static final String GTYPE_NAME = "GstURIDecodeBin";

    public URIDecodeBin(String name) {
        this(URIDecodeBin.makeRawElement(GST_NAME, name));
    }

    URIDecodeBin(NativeObject.Initializer init) {
        super(init);
    }

    public void connect(final UNKNOWN_TYPE listener) {
        this.connect(UNKNOWN_TYPE.class, listener, new GstAPI.GstCallback(){

            public void callback(URIDecodeBin elem, Pad pad, Caps caps) {
                listener.unknownType(elem, pad, caps);
            }
        });
    }

    public void disconnect(UNKNOWN_TYPE listener) {
        this.disconnect(UNKNOWN_TYPE.class, listener);
    }

    public void connect(final AUTOPLUG_CONTINUE listener) {
        this.connect(AUTOPLUG_CONTINUE.class, listener, new GstAPI.GstCallback(){

            public boolean callback(URIDecodeBin elem, Pad pad, Caps caps) {
                return listener.autoplugContinue(elem, pad, caps);
            }
        });
    }

    public void disconnect(AUTOPLUG_CONTINUE listener) {
        this.disconnect(AUTOPLUG_CONTINUE.class, listener);
    }

    public void connect(final AUTOPLUG_FACTORIES listener) {
        this.connect(AUTOPLUG_FACTORIES.class, listener, new GstAPI.GstCallback(){

            public GValueAPI.GValueArray callback(URIDecodeBin elem, Pad pad, Caps caps) {
                Optional<List<ElementFactory>> factories = listener.autoplugFactories(elem, pad, caps);
                return factories.map(list -> {
                    GValueAPI.GValueArray array = new GValueAPI.GValueArray(list.size(), false);
                    list.forEach(factory -> array.append(new GValueAPI.GValue(GType.OBJECT, factory)));
                    return array;
                }).orElse(null);
            }
        });
    }

    public void disconnect(AUTOPLUG_FACTORIES listener) {
        this.disconnect(AUTOPLUG_FACTORIES.class, listener);
    }

    public void connect(final AUTOPLUG_SORT listener) {
        this.connect(AUTOPLUG_SORT.class, listener, new GstAPI.GstCallback(){

            public GValueAPI.GValueArray callback(URIDecodeBin elem, Pad pad, Caps caps, GValueAPI.GValueArray factories) {
                int size = factories.getNValues();
                ArrayList<ElementFactory> list = new ArrayList<ElementFactory>(size);
                for (int i = 0; i < size; ++i) {
                    Object factory = factories.getValue(i);
                    if (!(factory instanceof ElementFactory)) continue;
                    list.add((ElementFactory)factory);
                }
                Optional<List<ElementFactory>> response = listener.autoplugSort(elem, pad, caps, list);
                return response.map(l -> {
                    GValueAPI.GValueArray array = new GValueAPI.GValueArray(l.size(), false);
                    list.forEach(factory -> array.append(new GValueAPI.GValue(GType.OBJECT, factory)));
                    return array;
                }).orElse(null);
            }
        });
    }

    public void disconnect(AUTOPLUG_SORT listener) {
        this.disconnect(AUTOPLUG_SORT.class, listener);
    }

    public void connect(final AUTOPLUG_SELECT listener) {
        this.connect(AUTOPLUG_SELECT.class, listener, new GstAPI.GstCallback(){

            public AutoplugSelectResult callback(URIDecodeBin elem, Pad pad, Caps caps, ElementFactory factory) {
                return listener.autoplugSelect(elem, pad, caps, factory);
            }
        });
    }

    public void disconnect(AUTOPLUG_SELECT listener) {
        this.disconnect(AUTOPLUG_SELECT.class, listener);
    }

    public void connect(final AUTOPLUG_QUERY listener) {
        this.connect(AUTOPLUG_QUERY.class, listener, new GstAPI.GstCallback(){

            public boolean callback(URIDecodeBin elem, Pad pad, Element child, Query query) {
                return listener.autoplugQuery(elem, pad, child, query);
            }
        });
    }

    public void disconnect(AUTOPLUG_QUERY listener) {
        this.disconnect(AUTOPLUG_QUERY.class, listener);
    }

    public void connect(final DRAINED listener) {
        this.connect(DRAINED.class, listener, new GstAPI.GstCallback(){

            public void callback(URIDecodeBin elem) {
                listener.drained(elem);
            }
        });
    }

    public void disconnect(DRAINED listener) {
        this.disconnect(DRAINED.class, listener);
    }

    public void connect(final SOURCE_SETUP listener) {
        this.connect(SOURCE_SETUP.class, listener, new GstAPI.GstCallback(){

            public void callback(URIDecodeBin bin, Element elem) {
                listener.sourceSetup(bin, elem);
            }
        });
    }

    public void disconnect(SOURCE_SETUP listener) {
        this.disconnect(SOURCE_SETUP.class, listener);
    }

    public static interface SOURCE_SETUP {
        public void sourceSetup(URIDecodeBin var1, Element var2);
    }

    public static interface DRAINED {
        public void drained(URIDecodeBin var1);
    }

    public static interface AUTOPLUG_QUERY {
        public boolean autoplugQuery(URIDecodeBin var1, Pad var2, Element var3, Query var4);
    }

    public static interface AUTOPLUG_SELECT {
        public AutoplugSelectResult autoplugSelect(URIDecodeBin var1, Pad var2, Caps var3, ElementFactory var4);
    }

    public static enum AutoplugSelectResult implements NativeEnum<AutoplugSelectResult>
    {
        TRY(0),
        EXPOSE(1),
        SKIP(2);

        private final int value;

        private AutoplugSelectResult(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }
    }

    public static interface AUTOPLUG_SORT {
        public Optional<List<ElementFactory>> autoplugSort(URIDecodeBin var1, Pad var2, Caps var3, List<ElementFactory> var4);
    }

    public static interface AUTOPLUG_FACTORIES {
        public Optional<List<ElementFactory>> autoplugFactories(URIDecodeBin var1, Pad var2, Caps var3);
    }

    public static interface AUTOPLUG_CONTINUE {
        public boolean autoplugContinue(URIDecodeBin var1, Pad var2, Caps var3);
    }

    public static interface UNKNOWN_TYPE {
        public void unknownType(URIDecodeBin var1, Pad var2, Caps var3);
    }
}

