/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.glib;

import com.sun.jna.Pointer;
import java.util.concurrent.Callable;
import org.freedesktop.gstreamer.glib.GMainContext;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.RefCountedObject;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;

public class GSource
extends RefCountedObject {
    private GlibAPI.GSourceFunc callback;

    GSource(NativeObject.Initializer init) {
        super(new Handle(init.ptr, init.ownsHandle), init.needRef);
    }

    public int attach(GMainContext context) {
        return GlibAPI.GLIB_API.g_source_attach(this, context);
    }

    public void setCallback(final Callable<Boolean> call) {
        this.callback = new GlibAPI.GSourceFunc(){

            @Override
            public boolean callback(Pointer data) {
                if (GlibAPI.GLIB_API.g_source_is_destroyed(GSource.this.getRawPointer())) {
                    return false;
                }
                try {
                    return (Boolean)call.call();
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };
        GlibAPI.GLIB_API.g_source_set_callback(this, this.callback, null, null);
    }

    private static final class Handle
    extends RefCountedObject.Handle {
        Handle(GPointer ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GlibAPI.GLIB_API.g_source_destroy(ptr.getPointer());
            GlibAPI.GLIB_API.g_source_unref(ptr.getPointer());
        }

        @Override
        protected void ref() {
            GlibAPI.GLIB_API.g_source_ref(this.getPointer().getPointer());
        }

        @Override
        protected void unref() {
            GlibAPI.GLIB_API.g_source_unref(this.getPointer().getPointer());
        }
    }
}

