/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.video;

import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GstVideoAPI;
import org.freedesktop.gstreamer.video.VideoTimeCodeConfig;

@Gst.Since(minor=10)
public class VideoTimeCode
extends NativeObject {
    private final GstVideoAPI.GstVideoTimeCodeStruct timeCodeStruct;
    private final VideoTimeCodeConfig timeCodeConfig;

    VideoTimeCode(GstVideoAPI.GstVideoTimeCodeStruct struct) {
        this(struct, new Handle(new GPointer(struct.getPointer()), false));
    }

    private VideoTimeCode(GstVideoAPI.GstVideoTimeCodeStruct struct, Handle handle) {
        super(handle);
        this.timeCodeStruct = struct;
        this.timeCodeConfig = new VideoTimeCodeConfig(this.timeCodeStruct.config);
    }

    public VideoTimeCodeConfig getConfig() {
        return this.timeCodeConfig;
    }

    public int getHours() {
        return this.timeCodeStruct.hours;
    }

    public int getMinutes() {
        return this.timeCodeStruct.minutes;
    }

    public int getSeconds() {
        return this.timeCodeStruct.seconds;
    }

    public int getFrames() {
        return this.timeCodeStruct.frames;
    }

    @Override
    public String toString() {
        return "GstVideoTimeCode{" + this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() + ":" + this.getFrames() + ", timeconfig=" + this.timeCodeConfig + "}";
    }

    @Override
    public void disown() {
        this.timeCodeConfig.disown();
        super.disown();
    }

    private static final class Handle
    extends NativeObject.Handle {
        public Handle(GPointer ptr, boolean ownsReference) {
            super(ptr, ownsReference);
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GstVideoAPI.GSTVIDEO_API.gst_video_time_code_free(ptr.getPointer());
        }

        @Override
        protected GPointer getPointer() {
            return super.getPointer();
        }
    }
}

