/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;
import org.apache.lucene.store.bytebuffer.ByteBufferFileOutput;
import org.apache.lucene.store.bytebuffer.ByteBufferIndexInput;
import org.apache.lucene.store.bytebuffer.ByteBufferIndexOutput;
import org.apache.lucene.store.bytebuffer.PlainByteBufferAllocator;

public class ByteBufferDirectory
extends Directory {
    protected final Map<String, ByteBufferFile> files = new ConcurrentHashMap<String, ByteBufferFile>();
    private final ByteBufferAllocator allocator;
    private final boolean internalAllocator;
    final AtomicLong sizeInBytes = new AtomicLong();

    public ByteBufferDirectory() {
        this.allocator = new PlainByteBufferAllocator(false, 1024, 10240);
        this.internalAllocator = true;
        try {
            this.setLockFactory(new SingleInstanceLockFactory());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteBufferDirectory(ByteBufferAllocator allocator) {
        this.allocator = allocator;
        this.internalAllocator = false;
        try {
            this.setLockFactory(new SingleInstanceLockFactory());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long sizeInBytes() {
        return this.sizeInBytes.get();
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    @Override
    public String[] listAll() throws IOException {
        return this.files.keySet().toArray(new String[0]);
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.files.containsKey(name);
    }

    @Override
    public long fileModified(String name) throws IOException {
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    @Override
    public void touchFile(String name) throws IOException {
        long ts2;
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.setLastModified(ts2);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        ByteBufferFile file = this.files.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        this.sizeInBytes.addAndGet(-file.sizeInBytes());
        file.delete();
    }

    @Override
    public long fileLength(String name) throws IOException {
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    @Override
    public IndexOutput createOutput(String name) throws IOException {
        ByteBufferFileOutput file;
        ByteBufferFile existing;
        ByteBufferAllocator.Type allocatorType = ByteBufferAllocator.Type.LARGE;
        if (name.contains("segments") || name.endsWith(".del")) {
            allocatorType = ByteBufferAllocator.Type.SMALL;
        }
        if ((existing = this.files.put(name, file = new ByteBufferFileOutput(this, this.allocator.sizeInBytes(allocatorType)))) != null) {
            this.sizeInBytes.addAndGet(-existing.sizeInBytes());
            existing.delete();
        }
        return new ByteBufferIndexOutput(this, name, this.allocator, allocatorType, file);
    }

    void closeOutput(String name, ByteBufferFileOutput file) {
        this.files.put(name, new ByteBufferFile(file));
    }

    @Override
    public IndexInput openInput(String name) throws IOException {
        ByteBufferFile file = this.files.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new ByteBufferIndexInput(name, file);
    }

    @Override
    public void close() throws IOException {
        String[] files;
        for (String file : files = this.listAll()) {
            this.deleteFile(file);
        }
        if (this.internalAllocator) {
            this.allocator.close();
        }
    }

    void releaseBuffer(ByteBuffer byteBuffer) {
        this.allocator.release(byteBuffer);
    }
}

