/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.PlainByteBufferAllocator;

public class CachingByteBufferAllocator
extends PlainByteBufferAllocator {
    private final ArrayBlockingQueue<ByteBuffer> smallCache;
    private final ArrayBlockingQueue<ByteBuffer> largeCache;

    public CachingByteBufferAllocator(boolean direct, int smallBufferSizeInBytes, int largeBufferSizeInBytes, int smallCacheSizeInBytes, int largeCacheSizeInBytes) {
        super(direct, smallBufferSizeInBytes, largeBufferSizeInBytes);
        this.smallCache = new ArrayBlockingQueue(smallCacheSizeInBytes / smallBufferSizeInBytes);
        this.largeCache = new ArrayBlockingQueue(largeCacheSizeInBytes / largeBufferSizeInBytes);
    }

    @Override
    public ByteBuffer allocate(ByteBufferAllocator.Type type) throws IOException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = type == ByteBufferAllocator.Type.SMALL ? this.smallCache.poll() : this.largeCache.poll();
        if (buffer == null) {
            buffer = super.allocate(type);
        }
        return buffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        boolean success;
        if (buffer.capacity() == this.smallBufferSizeInBytes) {
            boolean success2 = this.smallCache.offer(buffer);
            if (!success2) {
                super.release(buffer);
            }
        } else if (buffer.capacity() == this.largeBufferSizeInBytes && !(success = this.largeCache.offer(buffer))) {
            super.release(buffer);
        }
    }

    @Override
    public void close() {
        for (ByteBuffer buffer : this.smallCache) {
            super.release(buffer);
        }
        this.smallCache.clear();
        for (ByteBuffer buffer : this.largeCache) {
            super.release(buffer);
        }
        this.largeCache.clear();
    }
}

