/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteIndexRequest
extends MasterNodeOperationRequest {
    private String[] indices;
    private TimeValue timeout = TimeValue.timeValueSeconds(10L);

    DeleteIndexRequest() {
    }

    public DeleteIndexRequest(String index) {
        this.indices = new String[]{index};
    }

    public DeleteIndexRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("index / indices is missing", validationException);
        }
        return validationException;
    }

    public DeleteIndexRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    String[] indices() {
        return this.indices;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public DeleteIndexRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public DeleteIndexRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readUTF();
        }
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indices.length);
            for (String index : this.indices) {
                out.writeUTF(index);
            }
        }
        this.timeout.writeTo(out);
    }
}

