/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class ValidateQueryRequest
extends BroadcastOperationRequest {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private byte[] querySource;
    private int querySourceOffset;
    private int querySourceLength;
    private boolean querySourceUnsafe;
    private boolean explain;
    private String[] types = Strings.EMPTY_ARRAY;

    ValidateQueryRequest() {
    }

    public ValidateQueryRequest(String ... indices) {
        super(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        return validationException;
    }

    @Override
    public ValidateQueryRequest operationThreading(BroadcastOperationThreading operationThreading) {
        super.operationThreading(operationThreading);
        return this;
    }

    @Override
    protected void beforeStart() {
        if (this.querySourceUnsafe) {
            this.querySource = Arrays.copyOfRange(this.querySource, this.querySourceOffset, this.querySourceOffset + this.querySourceLength);
            this.querySourceOffset = 0;
            this.querySourceUnsafe = false;
        }
    }

    @Override
    public ValidateQueryRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public ValidateQueryRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    BytesHolder querySource() {
        return new BytesHolder(this.querySource, this.querySourceOffset, this.querySourceLength);
    }

    @Required
    public ValidateQueryRequest query(QueryBuilder queryBuilder) {
        BytesStream bos = queryBuilder.buildAsBytes();
        this.querySource = bos.underlyingBytes();
        this.querySourceOffset = 0;
        this.querySourceLength = bos.size();
        this.querySourceUnsafe = false;
        return this;
    }

    @Required
    public ValidateQueryRequest query(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(querySource);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    @Required
    public ValidateQueryRequest query(XContentBuilder builder) {
        try {
            this.querySource = builder.underlyingBytes();
            this.querySourceOffset = 0;
            this.querySourceLength = builder.underlyingBytesLength();
            this.querySourceUnsafe = false;
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + builder + "]", e);
        }
    }

    @Required
    public ValidateQueryRequest query(String querySource) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(querySource);
        this.querySource = result.result;
        this.querySourceOffset = 0;
        this.querySourceLength = result.length;
        this.querySourceUnsafe = true;
        return this;
    }

    @Required
    public ValidateQueryRequest query(byte[] querySource) {
        return this.query(querySource, 0, querySource.length, false);
    }

    @Required
    public ValidateQueryRequest query(byte[] querySource, int offset, int length, boolean unsafe) {
        this.querySource = querySource;
        this.querySourceOffset = offset;
        this.querySourceLength = length;
        this.querySourceUnsafe = unsafe;
        return this;
    }

    String[] types() {
        return this.types;
    }

    public ValidateQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public boolean explain() {
        return this.explain;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        BytesHolder bytes = in.readBytesReference();
        this.querySourceUnsafe = false;
        this.querySource = bytes.bytes();
        this.querySourceOffset = bytes.offset();
        this.querySourceLength = bytes.length();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
        this.explain = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesHolder(this.querySource, this.querySourceOffset, this.querySourceLength);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
        out.writeBoolean(this.explain);
    }

    public String toString() {
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", querySource[" + Unicode.fromBytes(this.querySource, this.querySourceOffset, this.querySourceLength) + "], explain:" + this.explain;
    }
}

