/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends TransportAction<BulkRequest, BulkResponse> {
    private final boolean autoCreateIndex;
    private final boolean allowIdGeneration;
    private final ClusterService clusterService;
    private final TransportShardBulkAction shardBulkAction;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TransportBulkAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportShardBulkAction shardBulkAction, TransportCreateIndexAction createIndexAction) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.shardBulkAction = shardBulkAction;
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = settings.getAsBoolean("action.auto_create_index", true);
        this.allowIdGeneration = this.componentSettings.getAsBoolean("action.allow_id_generation", true);
        transportService.registerHandler("bulk", new TransportHandler());
    }

    @Override
    protected void doExecute(final BulkRequest bulkRequest, final ActionListener<BulkResponse> listener) {
        final long startTime = System.currentTimeMillis();
        HashSet<String> indices = Sets.newHashSet();
        for (ActionRequest request : bulkRequest.requests) {
            DeleteRequest deleteRequest;
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                if (indices.contains(indexRequest.index())) continue;
                indices.add(indexRequest.index());
                continue;
            }
            if (!(request instanceof DeleteRequest) || indices.contains((deleteRequest = (DeleteRequest)request).index())) continue;
            indices.add(deleteRequest.index());
        }
        if (this.autoCreateIndex) {
            final AtomicInteger counter = new AtomicInteger(indices.size());
            final AtomicBoolean failed = new AtomicBoolean();
            for (String index : indices) {
                if (!this.clusterService.state().metaData().hasConcreteIndex(index)) {
                    this.createIndexAction.execute(new CreateIndexRequest(index).cause("auto(bulk api)"), new ActionListener<CreateIndexResponse>(){

                        @Override
                        public void onResponse(CreateIndexResponse result) {
                            if (counter.decrementAndGet() == 0) {
                                TransportBulkAction.this.executeBulk(bulkRequest, startTime, listener);
                            }
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                                if (counter.decrementAndGet() == 0) {
                                    TransportBulkAction.this.executeBulk(bulkRequest, startTime, listener);
                                }
                            } else if (failed.compareAndSet(false, true)) {
                                listener.onFailure(e);
                            }
                        }
                    });
                    continue;
                }
                if (counter.decrementAndGet() != 0) continue;
                this.executeBulk(bulkRequest, startTime, listener);
            }
        } else {
            this.executeBulk(bulkRequest, startTime, listener);
        }
    }

    private void executeBulk(BulkRequest bulkRequest, final long startTime, final ActionListener<BulkResponse> listener) {
        ShardId shardId;
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.WRITE);
        MetaData metaData = clusterState.metaData();
        for (ActionRequest request : bulkRequest.requests) {
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                String aliasOrIndex = indexRequest.index();
                indexRequest.index(clusterState.metaData().concreteIndex(indexRequest.index()));
                MappingMetaData mappingMd = null;
                if (metaData.hasIndex(indexRequest.index())) {
                    mappingMd = metaData.index(indexRequest.index()).mappingOrDefault(indexRequest.type());
                }
                indexRequest.process(metaData, aliasOrIndex, mappingMd, this.allowIdGeneration);
                continue;
            }
            if (!(request instanceof DeleteRequest)) continue;
            DeleteRequest deleteRequest = (DeleteRequest)request;
            deleteRequest.routing(clusterState.metaData().resolveIndexRouting(deleteRequest.routing(), deleteRequest.index()));
            deleteRequest.index(clusterState.metaData().concreteIndex(deleteRequest.index()));
        }
        final BulkItemResponse[] responses = new BulkItemResponse[bulkRequest.requests.size()];
        HashMap requestsByShard = Maps.newHashMap();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            ActionRequest request = bulkRequest.requests.get(i);
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                shardId = this.clusterService.operationRouting().indexShards(clusterState, indexRequest.index(), indexRequest.type(), indexRequest.id(), indexRequest.routing()).shardId();
                ArrayList<BulkItemRequest> list = (ArrayList<BulkItemRequest>)requestsByShard.get(shardId);
                if (list == null) {
                    list = Lists.newArrayList();
                    requestsByShard.put(shardId, list);
                }
                list.add(new BulkItemRequest(i, request));
                continue;
            }
            if (!(request instanceof DeleteRequest)) continue;
            DeleteRequest deleteRequest = (DeleteRequest)request;
            MappingMetaData mappingMd = clusterState.metaData().index(deleteRequest.index()).mappingOrDefault(deleteRequest.type());
            if (mappingMd != null && mappingMd.routing().required() && deleteRequest.routing() == null) {
                GroupShardsIterator groupShards = this.clusterService.operationRouting().broadcastDeleteShards(clusterState, deleteRequest.index());
                for (ShardIterator shardIt : groupShards) {
                    ArrayList<BulkItemRequest> list = (ArrayList<BulkItemRequest>)requestsByShard.get(shardIt.shardId());
                    if (list == null) {
                        list = Lists.newArrayList();
                        requestsByShard.put(shardIt.shardId(), list);
                    }
                    list.add(new BulkItemRequest(i, request));
                }
                continue;
            }
            ShardId shardId2 = this.clusterService.operationRouting().deleteShards(clusterState, deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), deleteRequest.routing()).shardId();
            ArrayList<BulkItemRequest> list = (ArrayList<BulkItemRequest>)requestsByShard.get(shardId2);
            if (list == null) {
                list = Lists.newArrayList();
                requestsByShard.put(shardId2, list);
            }
            list.add(new BulkItemRequest(i, request));
        }
        if (requestsByShard.isEmpty()) {
            listener.onResponse(new BulkResponse(responses, System.currentTimeMillis() - startTime));
            return;
        }
        final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
        for (Map.Entry entry : requestsByShard.entrySet()) {
            shardId = (ShardId)entry.getKey();
            final List requests = (List)entry.getValue();
            BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId.index().name(), shardId.id(), bulkRequest.refresh(), requests.toArray(new BulkItemRequest[requests.size()]));
            bulkShardRequest.replicationType(bulkRequest.replicationType());
            bulkShardRequest.consistencyLevel(bulkRequest.consistencyLevel());
            this.shardBulkAction.execute(bulkShardRequest, new ActionListener<BulkShardResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(BulkShardResponse bulkShardResponse) {
                    BulkItemResponse[] bulkItemResponseArray = responses;
                    synchronized (responses) {
                        BulkItemResponse[] arr$ = bulkShardResponse.responses();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            BulkItemResponse bulkItemResponse;
                            responses[bulkItemResponse.itemId()] = bulkItemResponse = arr$[i$];
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable e) {
                    String message = ExceptionsHelper.detailedMessage(e);
                    BulkItemResponse[] bulkItemResponseArray = responses;
                    synchronized (responses) {
                        for (BulkItemRequest request : requests) {
                            if (request.request() instanceof IndexRequest) {
                                IndexRequest indexRequest = (IndexRequest)request.request();
                                responses[request.id()] = new BulkItemResponse(request.id(), indexRequest.opType().toString().toLowerCase(), new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), message));
                                continue;
                            }
                            if (!(request.request() instanceof DeleteRequest)) continue;
                            DeleteRequest deleteRequest = (DeleteRequest)request.request();
                            responses[request.id()] = new BulkItemResponse(request.id(), "delete", new BulkItemResponse.Failure(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), message));
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        if (counter.decrementAndGet() == 0) {
                            this.finishHim();
                        }
                        return;
                    }
                }

                private void finishHim() {
                    listener.onResponse(new BulkResponse(responses, System.currentTimeMillis() - startTime));
                }
            });
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<BulkRequest> {
        TransportHandler() {
        }

        @Override
        public BulkRequest newInstance() {
            return new BulkRequest();
        }

        @Override
        public void messageReceived(final BulkRequest request, final TransportChannel channel) throws Exception {
            request.listenerThreaded(false);
            TransportBulkAction.this.execute(request, new ActionListener<BulkResponse>(){

                @Override
                public void onResponse(BulkResponse result) {
                    try {
                        channel.sendResponse(result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportBulkAction.this.logger.warn("Failed to send error response for action [bulk] and request [" + request + "]", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

