/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;

public enum SearchOperationThreading {
    NO_THREADS(0),
    SINGLE_THREAD(1),
    THREAD_PER_SHARD(2);

    private final byte id;

    private SearchOperationThreading(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static SearchOperationThreading fromId(byte id) {
        if (id == 0) {
            return NO_THREADS;
        }
        if (id == 1) {
            return SINGLE_THREAD;
        }
        if (id == 2) {
            return THREAD_PER_SHARD;
        }
        throw new ElasticSearchIllegalArgumentException("No type matching id [" + id + "]");
    }

    public static SearchOperationThreading fromString(String value, @Nullable SearchOperationThreading defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if ("no_threads".equals(value) || "noThreads".equals(value)) {
            return NO_THREADS;
        }
        if ("single_thread".equals(value) || "singleThread".equals(value)) {
            return SINGLE_THREAD;
        }
        if ("thread_per_shard".equals(value) || "threadPerShard".equals(value)) {
            return THREAD_PER_SHARD;
        }
        throw new ElasticSearchIllegalArgumentException("No value for search operation threading matching [" + value + "]");
    }
}

