/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.ExtTIntArrayList;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchQueryThenFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache transportSearchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, transportSearchCache, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<QuerySearchResult> {
        private final Map<SearchShardTarget, QuerySearchResultProvider> queryResults;
        private final Map<SearchShardTarget, FetchSearchResult> fetchResults;
        private volatile Map<SearchShardTarget, ExtTIntArrayList> docIdsToLoad;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(TransportSearchQueryThenFetchAction.this, request, listener);
            this.queryResults = TransportSearchQueryThenFetchAction.this.searchCache.obtainQueryResults();
            this.fetchResults = TransportSearchQueryThenFetchAction.this.searchCache.obtainFetchResults();
        }

        @Override
        protected String firstPhaseName() {
            return "query";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, InternalSearchRequest request, SearchServiceListener<QuerySearchResult> listener) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteQuery(node, request, listener);
        }

        @Override
        protected void processFirstPhaseResult(ShardRouting shard, QuerySearchResult result) {
            this.queryResults.put(result.shardTarget(), result);
        }

        @Override
        protected void moveToSecondPhase() {
            this.sortedShardList = TransportSearchQueryThenFetchAction.this.searchPhaseController.sortDocs(this.queryResults.values());
            final Map<SearchShardTarget, ExtTIntArrayList> docIdsToLoad = TransportSearchQueryThenFetchAction.this.searchPhaseController.docIdsToLoad(this.sortedShardList);
            this.docIdsToLoad = docIdsToLoad;
            if (docIdsToLoad.isEmpty()) {
                this.finishHim();
                return;
            }
            final AtomicInteger counter = new AtomicInteger(docIdsToLoad.size());
            int localOperations = 0;
            for (Map.Entry<SearchShardTarget, ExtTIntArrayList> entry : docIdsToLoad.entrySet()) {
                DiscoveryNode node = this.nodes.get(entry.getKey().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.queryResults.get(entry.getKey()).id(), entry.getValue());
                this.executeFetch(entry.getKey(), counter, fetchSearchRequest, node);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (Map.Entry entry : docIdsToLoad.entrySet()) {
                                DiscoveryNode node = AsyncAction.this.nodes.get(((SearchShardTarget)entry.getKey()).nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(((QuerySearchResultProvider)AsyncAction.this.queryResults.get(entry.getKey())).id(), (ExtTIntArrayList)entry.getValue());
                                AsyncAction.this.executeFetch((SearchShardTarget)entry.getKey(), counter, fetchSearchRequest, node);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final Map.Entry<SearchShardTarget, ExtTIntArrayList> entry : docIdsToLoad.entrySet()) {
                        final DiscoveryNode node = this.nodes.get(entry.getKey().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.queryResults.get(entry.getKey()).id(), entry.getValue());
                        if (localAsync) {
                            TransportSearchQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                @Override
                                public void run() {
                                    AsyncAction.this.executeFetch((SearchShardTarget)entry.getKey(), counter, fetchSearchRequest, node);
                                }
                            });
                            continue;
                        }
                        this.executeFetch(entry.getKey(), counter, fetchSearchRequest, node);
                    }
                }
            }
        }

        void executeFetch(final SearchShardTarget shardTarget, final AtomicInteger counter, final FetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
            TransportSearchQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                @Override
                public void onResult(FetchSearchResult result) {
                    result.shardTarget(shardTarget);
                    AsyncAction.this.fetchResults.put(result.shardTarget(), result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                        TransportSearchQueryThenFetchAction.this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
                    }
                    AsyncAction.this.addShardFailure(new ShardSearchFailure(t));
                    AsyncAction.this.successulOps.decrementAndGet();
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Exception e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures());
                if (TransportSearchQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchQueryThenFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
            finally {
                this.releaseIrrelevantSearchContexts(this.queryResults, this.docIdsToLoad);
                TransportSearchQueryThenFetchAction.this.searchCache.releaseQueryResults(this.queryResults);
                TransportSearchQueryThenFetchAction.this.searchCache.releaseFetchResults(this.fetchResults);
            }
        }

        void innerFinishHim() throws Exception {
            InternalSearchResponse internalResponse = TransportSearchQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), this.queryResults.values(), null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

