/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class MasterNodeOperationRequest
implements ActionRequest {
    public static TimeValue DEFAULT_MASTER_NODE_TIMEOUT = TimeValue.timeValueSeconds(30L);
    protected TimeValue masterNodeTimeout = DEFAULT_MASTER_NODE_TIMEOUT;

    @Override
    public boolean listenerThreaded() {
        return true;
    }

    @Override
    public MasterNodeOperationRequest listenerThreaded(boolean listenerThreaded) {
        return this;
    }

    public MasterNodeOperationRequest masterNodeTimeout(TimeValue timeout) {
        this.masterNodeTimeout = timeout;
        return this;
    }

    public MasterNodeOperationRequest masterNodeTimeout(String timeout) {
        return this.masterNodeTimeout(TimeValue.parseTimeValue(timeout, null));
    }

    public TimeValue masterNodeTimeout() {
        return this.masterNodeTimeout;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.masterNodeTimeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.masterNodeTimeout.writeTo(out);
    }
}

